/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.soap.impl.stream.bus;

import com.cognos.portal.utils.Parameters;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class BiBusParamsUpdater
extends StreamReaderDelegate {
    private Parameters formParams;
    private XMLStreamReader originalReader;
    private String pathInfo;
    private Parameters dispatchVars;

    public BiBusParamsUpdater(XMLStreamReader xsr, Parameters formParams, String pathInfo) {
        super(xsr);
        this.formParams = formParams;
        this.pathInfo = pathInfo;
        this.dispatchVars = new Parameters();
        this.dispatchVars.setValue("html", "false");
        this.dispatchVars.setValue("front", "false");
        this.dispatchVars.setValue("requester", "cps");
    }

    @Override
    public int next() throws XMLStreamException {
        int event = super.next();
        if (event == 8 && this.originalReader != null) {
            this.setParent(this.originalReader);
            event = this.originalReader.getEventType();
            this.originalReader = null;
        }
        if (event == 1 && this.originalReader == null) {
            XMLStreamReader parent = this.getParent();
            if ("formFieldVars".equals(parent.getLocalName())) {
                StaxUtils.moveToNextSibling(parent);
                parent.next();
                event = this.delegateStream("formFieldVar", this.formParams);
                this.formParams = null;
            } else if ("environmentVars".equals(parent.getLocalName())) {
                Parameters envParams = BiBusParamsUpdater.processBiBusParams(parent);
                envParams.setValue("REQUEST_METHOD", "POST");
                envParams.setValue("PATH_INFO", this.pathInfo);
                envParams.setValue("PATH_TRANSLATED", "");
                parent.next();
                event = this.delegateStream("environmentVar", envParams);
            } else if ("dispatcherTransportVars".equals(parent.getLocalName())) {
                StaxUtils.moveToNextSibling(parent);
                parent.next();
                event = this.delegateStream("dispatcherTransportVar", this.dispatchVars);
                this.dispatchVars = null;
            }
        } else if (event == 2) {
            if ("hdrSession".equals(this.getParent().getLocalName()) && this.formParams != null) {
                event = this.delegateStream("formFieldVar", this.formParams);
                this.formParams = null;
            } else if ("biBusHeader".equals(this.getParent().getLocalName()) && this.dispatchVars != null) {
                event = this.delegateStream("dispatcherTransportVar", this.dispatchVars);
                this.dispatchVars = null;
            }
        }
        return event;
    }

    private int delegateStream(String type, Parameters parameters) throws XMLStreamException {
        this.originalReader = this.getParent();
        XMLRecorderStreamWriter xrsw = BiBusParamsUpdater.createFormParamsXML(type, parameters);
        this.setParent(xrsw.toXMLStreamReader());
        return this.getParent().next();
    }

    private static Parameters processBiBusParams(XMLStreamReader xsr) throws XMLStreamException {
        Parameters params = new Parameters();
        int level = 0;
        String name = null;
        while (level >= 0) {
            int event = xsr.next();
            if (event == 1) {
                if ("name".equals(xsr.getLocalName())) {
                    name = xsr.getElementText();
                    continue;
                }
                if (name != null && "value".equals(xsr.getLocalName())) {
                    params.add(name, xsr.getElementText());
                    name = null;
                    continue;
                }
                ++level;
                continue;
            }
            if (event != 2) continue;
            --level;
        }
        return params;
    }

    private static XMLRecorderStreamWriter createFormParamsXML(String type, Parameters parameters) throws XMLStreamException {
        XMLRecorderStreamWriter xrsw = XMLStreamFactory.createXMLRecorderStreamWriter();
        xrsw.writeStartDocument();
        xrsw.writeStartElement("bus", type + "s", "http://developer.cognos.com/schemas/bibus/3/");
        xrsw.writeNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        xrsw.writeNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        xrsw.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        xrsw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "SOAP-ENC:Array");
        xrsw.writeAttribute("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/", "arrayType", "bus:" + type + "[]");
        for (Parameters.NameValuePair pair : parameters) {
            String name = pair.getName();
            String[] values = pair.getValues();
            for (int i = 0; i < values.length; ++i) {
                xrsw.writeStartElement("item");
                xrsw.writeStartElement("name");
                xrsw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:string");
                xrsw.writeCharacters(name);
                xrsw.writeEndElement();
                xrsw.writeStartElement("value");
                xrsw.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "xsd:string");
                xrsw.writeCharacters(values[i]);
                xrsw.writeEndElement();
                xrsw.writeEndElement();
            }
        }
        xrsw.writeEndElement();
        xrsw.writeEndDocument();
        xrsw.flush();
        xrsw.close();
        return xrsw;
    }
}

