/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.thread;

import com.cognos.portal.thread.IRerunnable;
import com.cognos.portal.thread.ThreadPool;
import com.cognos.portal.utils.LocalizableException;

public class RerunnableThread
extends Thread {
    IRerunnable m_rerunnable = null;
    String m_name = null;
    long m_id = 0L;
    ThreadPool m_pool = null;
    boolean m_terminated = false;
    boolean m_ready = false;

    public RerunnableThread(ThreadGroup threadGroup, IRerunnable rerunnable, String name, long id, ThreadPool pool) {
        super(threadGroup, rerunnable, name);
        this.m_rerunnable = rerunnable;
        this.m_name = name;
        this.m_id = id;
        this.m_pool = pool;
    }

    public synchronized void ready(long waittime) throws LocalizableException {
        if (!this.m_ready) {
            try {
                this.wait(waittime);
            }
            catch (InterruptedException e) {
                throw new LocalizableException("The thread \"" + this.m_name + "\" is not ready to be executed", e);
            }
            if (!this.m_ready) {
                throw new LocalizableException("The thread \"" + this.m_name + "\" is not ready to be executed");
            }
        }
    }

    @Override
    public synchronized void run() {
        this.m_ready = true;
        this.notify();
        try {
            do {
                this.wait();
                if (this.m_terminated) {
                    break;
                }
                this.m_rerunnable.run();
                if (this.m_terminated) break;
                if (!this.isInterrupted()) continue;
                break;
            } while (this.m_rerunnable.recycle() && this.m_pool.put(this, this.m_id));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_rerunnable.terminate();
        }
    }

    public synchronized void execute() {
        this.notify();
    }

    public synchronized void terminate() {
        this.m_terminated = true;
        this.notify();
    }

    public IRerunnable getRerunnable() {
        return this.m_rerunnable;
    }

    public ThreadPool getPool() {
        return this.m_pool;
    }
}

