/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.thread;

import com.cognos.portal.thread.IRerunnable;
import com.cognos.portal.thread.RerunnableThread;
import com.cognos.portal.thread.ThreadPoolCleanup;
import com.cognos.portal.utils.LocalizableException;
import java.util.ArrayList;
import java.util.LinkedList;

public class ThreadPool {
    private static long WAIT_FOR_READY = 60000L;
    private int m_initsize = 10;
    private long m_cleanupTime = 3600000L;
    private String m_rerunnable_classname = null;
    private String m_name = null;
    private LinkedList m_freeList = new LinkedList();
    private long m_id = 0L;
    private ThreadPoolCleanup m_cleanupThread = null;
    private boolean m_bInitialized = false;
    private String m_threadGroupName = null;
    private ThreadGroup m_threadGroup = null;

    public ThreadPool(String groupName) {
        this.m_threadGroupName = groupName == null ? "PORTAL" : groupName;
    }

    public synchronized void initialize(int initsize, String name, long cleanuptime, String rerunnable_classname) throws LocalizableException {
        if (this.m_bInitialized) {
            return;
        }
        this.m_initsize = initsize;
        this.m_cleanupTime = cleanuptime;
        this.m_rerunnable_classname = rerunnable_classname;
        this.m_name = name;
        this.m_threadGroup = new ThreadGroup(this.m_threadGroupName);
        this.m_id = System.currentTimeMillis();
        for (int i = 0; i < this.m_initsize; ++i) {
            this.m_freeList.addFirst(this.createThread(rerunnable_classname));
        }
        this.m_cleanupThread = new ThreadPoolCleanup(this, this.m_cleanupTime, this.m_name + "-Trim");
        this.m_cleanupThread.start();
        this.m_bInitialized = true;
    }

    public synchronized void terminate() {
        if (!this.m_bInitialized) {
            return;
        }
        if (this.m_cleanupThread != null) {
            this.m_cleanupThread.terminate();
            this.m_cleanupThread = null;
        }
        while (this.m_freeList.size() > 0) {
            ((RerunnableThread)this.m_freeList.removeFirst()).terminate();
        }
        this.m_id = System.currentTimeMillis();
        this.m_threadGroup = null;
        this.m_initsize = 10;
        this.m_cleanupTime = 3600000L;
        this.m_bInitialized = false;
    }

    public synchronized void interrupt() {
        if (!this.m_bInitialized) {
            return;
        }
        if (this.m_cleanupThread != null) {
            this.m_cleanupThread.terminate();
            this.m_cleanupThread = null;
        }
        this.m_bInitialized = false;
        while (this.m_freeList.size() > 0) {
            ((RerunnableThread)this.m_freeList.removeFirst()).terminate();
        }
        this.m_id = System.currentTimeMillis();
        int count = this.m_threadGroup.activeCount();
        Thread[] threads = new Thread[count];
        int activeCount = this.m_threadGroup.enumerate(threads, true);
        for (int i = 0; i < activeCount; ++i) {
            threads[i].interrupt();
        }
        this.m_threadGroup = null;
        this.m_initsize = 10;
        this.m_cleanupTime = 3600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RerunnableThread acquireThread() throws LocalizableException {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.m_freeList.size() > 0) {
                return (RerunnableThread)this.m_freeList.removeFirst();
            }
        }
        return this.createThread(this.m_rerunnable_classname);
    }

    public synchronized boolean put(RerunnableThread thread, long id) {
        if (!this.m_bInitialized || this.m_id != id) {
            return false;
        }
        this.m_freeList.addFirst(thread);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim() {
        ArrayList threads = new ArrayList();
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            while (this.m_freeList.size() > this.m_initsize) {
                threads.add(this.m_freeList.removeLast());
            }
        }
        for (int i = 0; i < threads.size(); ++i) {
            ((RerunnableThread)threads.get(i)).terminate();
        }
    }

    private RerunnableThread createThread(String rerunnable_classname) throws LocalizableException {
        try {
            IRerunnable rerunnable = (IRerunnable)Class.forName(rerunnable_classname).newInstance();
            RerunnableThread thread = new RerunnableThread(this.m_threadGroup, rerunnable, this.m_name, this.m_id, this);
            thread.start();
            thread.ready(WAIT_FOR_READY);
            return thread;
        }
        catch (Throwable e) {
            throw new LocalizableException("Could not create thread :" + this.m_name, e);
        }
    }

    public synchronized boolean isInitialized() {
        return this.m_bInitialized;
    }
}

