/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class Boyer {
    private static final boolean debugging = true;
    private static final int breakEvenLenPat = 1;
    private static final int breakEvenLenText = 1;
    private String pattern;
    private String prevPattern;
    private char[] patternArray;
    private String text;
    private char[] textArray;
    private int[] skip;
    int lenPat = 0;
    int lenText = 0;
    int offset = 0;

    public Boyer(String text) {
        this.setText(text);
    }

    public Boyer(char[] text, int len) {
        this.setText(text, 0, len);
    }

    public Boyer(char[] text, int offset, int len) {
        this.setText(text, offset, len);
    }

    public Boyer(char[] text) {
        this.setText(text, 0, text.length);
    }

    private final void analysePattern() {
        int i;
        if (this.pattern.equals(this.prevPattern)) {
            return;
        }
        this.patternArray = this.pattern.toCharArray();
        if (this.skip == null) {
            this.skip = new int[256];
        }
        for (i = 0; i < 256; ++i) {
            this.skip[i] = this.lenPat;
        }
        for (i = 0; i < this.lenPat - 1; ++i) {
            this.skip[this.patternArray[i] & 0xFF] = this.lenPat - i - 1;
        }
        this.prevPattern = this.pattern;
    }

    public static int indexOf(String text, String pattern) {
        return Boyer.indexOf(text, pattern, 0);
    }

    public static int indexOf(String text, String pattern, int index) {
        return new Boyer(text).indexOf(pattern, index);
    }

    public static int indexOf(char[] text, String pattern, int index) {
        return new Boyer(text).indexOf(pattern, index);
    }

    public static int indexOf(char[] text, String pattern) {
        return Boyer.indexOf(text, pattern, 0);
    }

    public int indexOf(String pattern, int index) {
        this.setPattern(pattern);
        return this.indexOf(index);
    }

    public int indexOf(String pattern) {
        return this.indexOf(pattern, 0);
    }

    protected final int indexOf(int index) {
        if (this.text != null) {
            return this.indexOfViaText(index);
        }
        return this.indexOfViaTextArray(index);
    }

    private final int indexOfViaText(int index) {
        if (this.lenText <= 0 || this.lenPat <= 1) {
            return this.text.indexOf(this.pattern, index);
        }
        this.analysePattern();
        char testChar = '\u0000';
        char lastPatChar = this.patternArray[this.lenPat - 1];
        block0: for (int tforward = index + this.lenPat - 1; tforward < this.lenText; tforward += this.skip[testChar & 0xFF]) {
            testChar = this.text.charAt(tforward);
            if (testChar != lastPatChar) continue;
            int tback = tforward - 1;
            for (int pback = this.lenPat - 2; pback >= 0; --pback) {
                if (this.text.charAt(tback) != this.patternArray[pback]) continue block0;
                --tback;
            }
            return tforward - this.lenPat + 1;
        }
        return -1;
    }

    private final int indexOfViaTextArray(int index) {
        if (this.lenText <= 0 || this.lenPat <= 1) {
            return new String(this.textArray, this.offset, this.lenText).indexOf(this.pattern, index);
        }
        this.analysePattern();
        char testChar = '\u0000';
        char lastPatChar = this.patternArray[this.lenPat - 1];
        int maxLen = this.offset + this.lenText;
        block0: for (int tforward = this.offset + index + this.lenPat - 1; tforward < maxLen; tforward += this.skip[testChar & 0xFF]) {
            testChar = this.textArray[tforward];
            if (testChar != lastPatChar) continue;
            int tback = tforward - 1;
            for (int pback = this.lenPat - 2; pback >= 0; --pback) {
                if (this.textArray[tback] != this.patternArray[pback]) continue block0;
                --tback;
            }
            return tforward - this.offset - this.lenPat + 1;
        }
        return -1;
    }

    protected void setPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        this.pattern = pattern;
        this.lenPat = pattern.length();
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.text = text;
        this.lenText = text.length();
        this.textArray = null;
    }

    public void setText(char[] text, int offset, int len) {
        if (text == null) {
            throw new NullPointerException();
        }
        this.textArray = text;
        this.offset = offset;
        this.lenText = len;
        this.text = null;
    }

    public void setText(char[] text, int len) {
        this.setText(text, 0, len);
    }

    public static void main(String[] args) {
        System.out.println(Boyer.indexOf("dogcatwombat", "cat"));
        System.out.println("dogcatwombat".indexOf("cat"));
        System.out.println(Boyer.indexOf("crtcamccmcarogcatwombat", "cat"));
        System.out.println("crtcamccmcarogcatwombat".indexOf("cat"));
        System.out.println(Boyer.indexOf("dogcatwombat", ""));
        System.out.println("dogcatwombat".indexOf(""));
        System.out.println(Boyer.indexOf("", ""));
        System.out.println("".indexOf(""));
        System.out.println(Boyer.indexOf("", "abcde"));
        System.out.println("".indexOf("abcde"));
        System.out.println(Boyer.indexOf("dogcatwombat", "cow"));
        System.out.println("dogcatwombat".indexOf("cow"));
        String s = "create table foo (created_date datetime default sysdate not null)";
        System.out.println(s.indexOf("create", 10));
        System.out.println(Boyer.indexOf(s, "create", 10));
        System.out.println(new String(s.toCharArray(), 8, s.length() - 8).indexOf("create") + 8);
        System.out.println(new Boyer(s.toCharArray(), 8, s.length() - 8).indexOf("create"));
        try {
            int i;
            File f = new File("C:/temp/temp.txt");
            int size = (int)f.length();
            FileReader fr = new FileReader(f);
            char[] ca = new char[size];
            fr.read(ca);
            s = new String(ca);
            int result = 0;
            long start = System.currentTimeMillis();
            for (i = 0; i < 1000; ++i) {
                result = Boyer.indexOf(ca, "efficiency" + i % 10);
            }
            System.out.println("Boyer.indexOf(char[]): " + result);
            long stop = System.currentTimeMillis();
            System.out.println("Elapsed:" + (stop - start));
            start = System.currentTimeMillis();
            for (i = 0; i < 1000; ++i) {
                result = Boyer.indexOf(s, "efficiency" + i % 10);
            }
            System.out.println("Boyer.indexOf(String): " + result);
            stop = System.currentTimeMillis();
            System.out.println("Elapsed:" + (stop - start));
            start = System.currentTimeMillis();
            for (i = 0; i < 1000; ++i) {
                result = s.indexOf("efficiency" + i % 10);
            }
            System.out.println("String.indexOf: " + result);
            stop = System.currentTimeMillis();
            System.out.println("Elapsed:" + (stop - start));
            fr.close();
        }
        catch (IOException e) {
            return;
        }
    }
}

