/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cps.common.utils.LocaleUtils;
import com.cognos.i18n.CollationKey;
import com.cognos.i18n.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class CCLLocaleUtils {
    public static String getValidContentLocale(String locale, Object[] supportedLocales, String defaultLocale) {
        try {
            int i;
            ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
            String normalizedLocale = cclConfig.normalizeLocale(locale);
            boolean isValid = cclConfig.validateContentLocale(normalizedLocale);
            if (isValid) {
                for (i = 0; i < supportedLocales.length; ++i) {
                    if (!normalizedLocale.equals(supportedLocales[i])) continue;
                    return normalizedLocale;
                }
            }
            locale = cclConfig.mapContentLocale(normalizedLocale, false);
            for (i = 0; i < supportedLocales.length; ++i) {
                if (!supportedLocales[i].equals(locale)) continue;
                return locale;
            }
            for (i = 0; i < supportedLocales.length; ++i) {
                if (!locale.equals(cclConfig.mapContentLocale(supportedLocales[i].toString(), false))) continue;
                return supportedLocales[i].toString();
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return defaultLocale;
    }

    public static String getValidProductLocale(String locale, Object[] supportedLocales, String defaultLocale) {
        try {
            int i;
            ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
            String normalizedLocale = cclConfig.normalizeLocale(locale);
            boolean isValid = cclConfig.validateProductLocale(normalizedLocale);
            if (isValid) {
                for (i = 0; i < supportedLocales.length; ++i) {
                    if (!normalizedLocale.equals(supportedLocales[i])) continue;
                    return normalizedLocale;
                }
            }
            locale = cclConfig.mapProductLocale(normalizedLocale, false);
            for (i = 0; i < supportedLocales.length; ++i) {
                if (!supportedLocales[i].equals(locale)) continue;
                return locale;
            }
            for (i = 0; i < supportedLocales.length; ++i) {
                if (!locale.equals(cclConfig.mapProductLocale(supportedLocales[i].toString(), false))) continue;
                return supportedLocales[i].toString();
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        return defaultLocale;
    }

    public static Map getLocalizedContentLocales(String locale) {
        try {
            return CCLLocaleUtils.sortDisplayNames(locale, CCLConfigurationFactory.getInstance().getContentLocaleList(locale));
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    public static Map getLocalizedTimeZones(String locale) {
        try {
            return CCLLocaleUtils.sortDisplayNames(locale, CCLConfigurationFactory.getInstance().getTimeZones(locale));
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    public static Map getLocalizedCurrencies(String locale) {
        try {
            return CCLLocaleUtils.sortDisplayNames(locale, CCLConfigurationFactory.getInstance().getCurrencies(locale));
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    public static Map getLocalizedProductLocales(String locale) {
        try {
            return CCLLocaleUtils.sortDisplayNames(locale, CCLConfigurationFactory.getInstance().getProductLocaleList(locale));
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    public static Map sortDisplayNames(String locale, Map unsortedMap) {
        Collator collator = new Collator(new Locale(locale));
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry pair : unsortedMap.entrySet()) {
            String name = (String)pair.getValue();
            CollationKey key = collator.getCollationKey(name);
            sortedMap.put(key, pair);
        }
        return sortedMap;
    }

    public static String getServerLocale() {
        try {
            return CCLConfigurationFactory.getInstance().getValue("serverLocale", false);
        }
        catch (CCLConfigurationException e) {
            return null;
        }
    }

    public static Object[] getContentLocales() {
        try {
            return CCLConfigurationFactory.getInstance().getContentLocaleList(null).keySet().toArray();
        }
        catch (CCLConfigurationException e) {
            return new Object[0];
        }
    }

    public static Object[] getProductLocales() {
        try {
            return CCLConfigurationFactory.getInstance().getProductLocaleList(null).keySet().toArray();
        }
        catch (CCLConfigurationException e) {
            return new Object[0];
        }
    }

    public static String normalizeLocale(String localeString) {
        try {
            return CCLConfigurationFactory.getInstance().normalizeLocale(localeString);
        }
        catch (CCLConfigurationException e) {
            return LocaleUtils.toNormalizedString((String)localeString);
        }
    }

    public static String getValidContentLocale(String localeName, String defaultLocale) {
        return CCLLocaleUtils.getValidContentLocale(localeName, CCLLocaleUtils.getContentLocales(), defaultLocale);
    }

    public static String getValidProductLocale(String localeName, String defaultLocale) {
        return CCLLocaleUtils.getValidProductLocale(localeName, CCLLocaleUtils.getProductLocales(), defaultLocale);
    }

    public static String getBestFitLocale(String currentContentLocaleString, String[] localeArray) {
        ArrayList<String> normalizedLocales = new ArrayList<String>();
        try {
            String mappedContentLocale;
            ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
            for (int index = 0; index < localeArray.length; ++index) {
                normalizedLocales.add(cclConfig.normalizeLocale(localeArray[index]));
            }
            String currentContentLocale = cclConfig.normalizeLocale(currentContentLocaleString);
            if (!CCLLocaleUtils.getValidContentLocale(currentContentLocaleString, "").equals("")) {
                for (int index = 0; index < normalizedLocales.size(); ++index) {
                    String currentLocale = (String)normalizedLocales.get(index);
                    if (!currentContentLocale.equals(currentLocale)) continue;
                    return localeArray[index].trim();
                }
            }
            if ((mappedContentLocale = cclConfig.normalizeLocale(cclConfig.mapContentLocale(currentContentLocaleString, false))) != null) {
                for (int j = 0; j < normalizedLocales.size(); ++j) {
                    String currentLocale = (String)normalizedLocales.get(j);
                    if (!mappedContentLocale.equals(currentLocale)) continue;
                    return localeArray[j].trim();
                }
            }
            if (mappedContentLocale != null) {
                for (int j = 0; j < normalizedLocales.size(); ++j) {
                    String locString = (String)normalizedLocales.get(j);
                    String currentMappedLocale = cclConfig.mapContentLocale(locString, false);
                    if (!mappedContentLocale.equals(currentMappedLocale)) continue;
                    return localeArray[j].trim();
                }
            }
        }
        catch (CCLConfigurationException cCLConfigurationException) {
            // empty catch block
        }
        if (localeArray.length > 0) {
            Arrays.sort(localeArray);
            return localeArray[0].trim();
        }
        return "";
    }

    public static String getBestFitLocale(String currentContentLocaleString, String localeList) {
        return CCLLocaleUtils.getBestFitLocale(currentContentLocaleString, localeList.replaceAll(" ", "").split(","));
    }

    public static String[] getContentLocalesAsStrings() {
        try {
            return CCLConfigurationFactory.getInstance().getContentLocaleList(null).keySet().toArray(new String[0]);
        }
        catch (CCLConfigurationException e) {
            return new String[0];
        }
    }

    public static String[] getProductLocalesAsStrings() {
        try {
            return CCLConfigurationFactory.getInstance().getProductLocaleList(null).keySet().toArray(new String[0]);
        }
        catch (CCLConfigurationException e) {
            return new String[0];
        }
    }
}

