/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.cps.common.utils.SmallMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Cache
implements Map {
    private Map m_map = new SmallMap();
    private ExpiryThread m_expiryThread;
    private Object m_mutex = this;
    private int maxCapacity;

    public Cache(long cleanIntervalInSec, long expiryTimeInSec, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        if (cleanIntervalInSec > 0L && expiryTimeInSec > 0L) {
            this.m_expiryThread = new ExpiryThread(cleanIntervalInSec, expiryTimeInSec);
            this.m_expiryThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object = this.m_mutex;
        synchronized (object) {
            TimeStampObject timeStampObject = (TimeStampObject)this.m_map.get(key);
            if (timeStampObject != null) {
                timeStampObject.touch();
                return timeStampObject.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object object = this.m_mutex;
        synchronized (object) {
            TimeStampObject timeStampObject;
            if (this.size() >= this.maxCapacity && this.maxCapacity > 0) {
                this.removeLastUsed();
            }
            if ((timeStampObject = this.m_map.put(key, new TimeStampObject(value))) != null) {
                return timeStampObject.getValue();
            }
            return null;
        }
    }

    private void removeLastUsed() {
        Object keyToRemove = null;
        long timeStamp = 0L;
        for (Map.Entry entry : this.entrySet()) {
            TimeStampObject timeStampObject = (TimeStampObject)this.m_map.get(entry.getKey());
            if (keyToRemove != null && timeStampObject.getTimeStamp() >= timeStamp) continue;
            keyToRemove = entry.getKey();
            timeStamp = timeStampObject.getTimeStamp();
        }
        if (keyToRemove != null) {
            this.remove(keyToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map t) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_map.putAll(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.m_mutex;
        synchronized (object) {
            TimeStampObject timeStampObject = (TimeStampObject)this.m_map.remove(key);
            if (timeStampObject != null) {
                return timeStampObject.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        ArrayList<Object> copy = new ArrayList<Object>();
        Object object = this.m_mutex;
        synchronized (object) {
            Collection values = this.m_map.values();
            for (TimeStampObject timeStampObject : values) {
                copy.add(timeStampObject.getValue());
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        HashSet copy;
        Object object = this.m_mutex;
        synchronized (object) {
            copy = new HashSet(this.m_map.keySet());
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        HashSet<CacheEntry> entrySet = new HashSet<CacheEntry>();
        Object object = this.m_mutex;
        synchronized (object) {
            for (Object key : this.m_map.keySet()) {
                if (key == null) continue;
                entrySet.add(new CacheEntry(key));
            }
        }
        return entrySet;
    }

    public void terminate() {
        this.m_expiryThread.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanExpiredItems(long expiryTime) {
        ArrayList objectsToBeRemove = new ArrayList();
        Object object = this.m_mutex;
        synchronized (object) {
            Set entries = this.m_map.entrySet();
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : entries) {
                TimeStampObject object2 = (TimeStampObject)entry.getValue();
                long temp = object2.getTimeStamp() + expiryTime;
                if (temp > currentTime) continue;
                objectsToBeRemove.add(entry.getKey());
            }
        }
        for (int i = 0; i < objectsToBeRemove.size(); ++i) {
            this.remove(objectsToBeRemove.get(i));
        }
    }

    private class ExpiryThread
    extends Thread {
        private boolean terminated;
        private long cleanInterval;
        private long expiryTime;

        public ExpiryThread(long cleanIntervalInSec, long expiryTimeInSec) {
            this.cleanInterval = cleanIntervalInSec * 1000L;
            this.expiryTime = expiryTimeInSec * 1000L;
        }

        @Override
        public void run() {
            while (!this.terminated) {
                block3: {
                    try {
                        ExpiryThread.sleep(this.cleanInterval);
                    }
                    catch (InterruptedException e) {
                        if (!this.terminated) break block3;
                        return;
                    }
                }
                Cache.this.cleanExpiredItems(this.expiryTime);
            }
        }

        public void terminate() {
            this.terminated = true;
            this.interrupt();
        }
    }

    private class CacheEntry
    implements Map.Entry {
        private Object key;

        public CacheEntry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return Cache.this.get(this.key);
        }

        public Object setValue(Object value) {
            return Cache.this.put(this.key, value);
        }

        public String toString() {
            return "(" + this.key + ", " + "" + this.getValue() + ")";
        }
    }

    private class TimeStampObject {
        private long timestamp;
        private Object object;

        public TimeStampObject(Object object) {
            this.object = object;
            this.timestamp = System.currentTimeMillis();
        }

        public void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public Object getValue() {
            return this.object;
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public String toString() {
            return "[" + this.object + "|" + this.timestamp + "]";
        }
    }
}

