/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.portal.utils.EncodingUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class JSONObject {
    private StringBuffer sb;
    private boolean more;
    private int arrayLevel;
    private int objectLevel;

    public JSONObject() {
        this.clear();
    }

    public void clear() {
        this.sb = new StringBuffer();
        this.more = false;
        this.arrayLevel = 0;
        this.objectLevel = 0;
    }

    public void addMember(String name, String value) {
        this.addMember(name);
        this.addValue(value);
    }

    public void addMember(String name, int value) {
        this.addMember(name);
        this.addValue(value);
    }

    public void addMember(String name, boolean value) {
        this.addMember(name);
        this.addValue(value);
    }

    public void addObjectMember(String name) {
        this.addMember(name);
        this.addObject();
    }

    public void addScriptMember(String name, String script) {
        this.addMember(name);
        this.addScriptValue(script);
    }

    public void addArrayMember(String name) {
        this.addMember(name);
        this.addArray();
    }

    public void addObject() {
        this.addOptionalSep();
        this.sb.append('{');
        this.sb.append(' ');
        this.more = false;
        ++this.objectLevel;
    }

    public void endObject() {
        if (this.objectLevel <= 0) {
            throw new RuntimeException("endObject() called without addObject()");
        }
        this.sb.append(' ');
        this.sb.append('}');
        this.more = true;
        --this.objectLevel;
    }

    public void addArray() {
        this.sb.append('[');
        this.sb.append(' ');
        this.more = false;
        ++this.arrayLevel;
    }

    public void endArray() {
        if (this.arrayLevel <= 0) {
            throw new RuntimeException("endArray() called without addArray()");
        }
        this.sb.append(' ');
        this.sb.append(']');
        this.more = true;
        --this.arrayLevel;
    }

    public void addValue(String value) {
        this.addOptionalSep();
        if (value != null) {
            this.sb.append('\"');
            EncodingUtils.javascriptencode(value, this.sb);
            this.sb.append('\"');
        } else {
            this.sb.append("null");
        }
        this.more = true;
    }

    public void addValue(int value) {
        this.addOptionalSep();
        this.sb.append(value);
        this.more = true;
    }

    public void addValue(boolean value) {
        this.addOptionalSep();
        this.sb.append(value);
        this.more = true;
    }

    public void addScriptValue(String script) {
        this.addOptionalSep();
        if (script != null) {
            this.sb.append(script);
        } else {
            this.sb.append("null");
        }
        this.more = true;
    }

    public void write(XMLStreamWriter out) throws XMLStreamException {
        if (this.arrayLevel > 0 || this.objectLevel > 0) {
            throw new RuntimeException("unbalanced nesting objects or arrays");
        }
        out.writeCharacters("{ ");
        out.writeCharacters(this.sb.toString());
        out.writeCharacters(" }");
    }

    public void write(StringBuffer out) {
        if (this.arrayLevel > 0 || this.objectLevel > 0) {
            throw new RuntimeException("unbalanced nesting objects or arrays");
        }
        out.append('{');
        out.append(' ');
        out.append(this.sb.toString());
        out.append(' ');
        out.append('}');
    }

    private void addMember(String name) {
        this.addOptionalSep();
        if (!this.isJavascriptIdentifier(name)) {
            this.sb.append('\"');
            EncodingUtils.javascriptencode(name, this.sb);
            this.sb.append('\"');
        } else {
            this.sb.append(name);
        }
        this.sb.append(':');
        this.sb.append(' ');
    }

    private void addOptionalSep() {
        if (this.more) {
            this.sb.append(',');
            this.sb.append(' ');
            this.more = false;
        }
    }

    private boolean isJavascriptIdentifier(String value) {
        if (!Character.isJavaIdentifierStart(value.charAt(0))) {
            return false;
        }
        for (int i = 1; i < value.length(); ++i) {
            if (Character.isJavaIdentifierPart(value.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

