/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.portal.utils.ExceptionExtension;
import com.cognos.portal.utils.MessagesManager;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;

public class LocalizableException
extends Exception
implements ExceptionExtension {
    private static final long serialVersionUID = 1L;
    private String key = null;
    private Object[] args = null;
    private Throwable m_rootCause = null;

    public LocalizableException(String key) {
        super(key);
        this.key = key;
    }

    public LocalizableException(String key, Throwable rootCause) {
        super(key);
        this.key = key;
        this.m_rootCause = rootCause;
    }

    public LocalizableException(String key, Object[] args) {
        super(key);
        this.key = key;
        this.args = args;
    }

    public LocalizableException(String key, Object[] args, Throwable rootCause) {
        super(key);
        this.key = key;
        this.args = args;
        this.m_rootCause = rootCause;
    }

    public Object[] copyArgs() {
        if (this.args != null) {
            Object[] theCopy = new Object[this.args.length];
            System.arraycopy(this.args, 0, theCopy, 0, this.args.length);
            return theCopy;
        }
        return null;
    }

    @Override
    public Throwable getRootCause() {
        return this.m_rootCause;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMsgString(Locale.getDefault());
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMsgString(Locale.getDefault());
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.m_rootCause != null) {
            this.m_rootCause.printStackTrace(s);
        }
    }

    @Override
    public String getLocalizedMsgString(Locale locale) {
        if (this.key == null) {
            return "";
        }
        if (this.args == null) {
            return MessagesManager.getInstance().getMessage(locale, this.key);
        }
        return MessagesManager.getInstance().getMessage(locale, this.key, this.args);
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

