/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.portal.utils.MultiBufferOutputStream;
import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;

public class MultiBufferByteArrayOutputStream
extends MultiBufferOutputStream {
    private static final int INITIAL_STREAMS_SIZE = 4;
    private PrivateByteArrayOutputStream[] streams = new PrivateByteArrayOutputStream[4];
    private int active = -1;
    private static int nextID = 0;

    public MultiBufferByteArrayOutputStream() {
        this.createBuffer(32);
    }

    public MultiBufferByteArrayOutputStream(int size) {
        this.createBuffer(size);
    }

    @Override
    public int createBuffer(int size) {
        return this.createBufferHelper(new RegularByteArrayOutputStream(size));
    }

    @Override
    public MultiBufferOutputStream spawnMultiBuffer() {
        MultiBufferByteArrayOutputStream multiBuffer = new MultiBufferByteArrayOutputStream();
        this.createMultiBuffer(multiBuffer);
        this.createBuffer(32);
        return multiBuffer;
    }

    @Override
    public int getActiveBuffer() {
        return this.streams[this.active].getID();
    }

    @Override
    public int setActiveBuffer(int bufferID) {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null || this.streams[i].getID() != bufferID) continue;
            int currentID = this.getActiveBuffer();
            this.active = i;
            return currentID;
        }
        throw new IllegalArgumentException("Invalid buffer identifier");
    }

    @Override
    public void discardBuffer(int bufferID) {
        this.discardBuffers(bufferID, bufferID);
    }

    @Override
    public void discardBuffers(int fromBufferID, int toBufferID) {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null || this.streams[i].getID() != fromBufferID) continue;
            for (int j = i; j < this.streams.length; ++j) {
                if (this.streams[j] == null || this.streams[j].getID() != toBufferID) continue;
                int c = j - i + 1;
                System.arraycopy(this.streams, j + 1, this.streams, i, this.streams.length - j - 1);
                Arrays.fill(this.streams, this.streams.length - c, this.streams.length, null);
                if (this.active >= i) {
                    this.active -= c;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid buffer identifiers");
    }

    @Override
    public int countBuffers() {
        int count = 0;
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void write(int b) throws IOException {
        this.streams[this.active].write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.streams[this.active].write(b, off, len);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            this.streams[i].writeTo(out);
        }
    }

    public synchronized void reset() {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            this.streams[i].reset();
        }
    }

    public synchronized byte[] toByteArray() {
        byte[] newbuf = new byte[this.size()];
        int pos = 0;
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            this.streams[i].copyTo(newbuf, pos);
            pos += this.streams[i].size();
        }
        return newbuf;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            size += this.streams[i].size();
        }
        return size;
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            this.streams[i].close();
        }
    }

    public String toString() {
        byte[] buf = this.toByteArray();
        return new String(buf, 0, buf.length);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        byte[] buf = this.toByteArray();
        return new String(buf, 0, buf.length, enc);
    }

    public InputStream toStream() {
        Object[] inputs = new InputStream[this.countBuffers()];
        int j = 0;
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            inputs[j++] = this.streams[i].toStream();
        }
        return new SequenceInputStream(new ArrayEnumeration(inputs));
    }

    private int createMultiBuffer(MultiBufferByteArrayOutputStream multiBuffer) {
        return this.createBufferHelper(new MultiBufferPrivateByteArrayOutputStream(multiBuffer));
    }

    private int createBufferHelper(PrivateByteArrayOutputStream outputStream) {
        if (this.streams[this.streams.length - 1] != null) {
            PrivateByteArrayOutputStream[] newstreams = new PrivateByteArrayOutputStream[this.streams.length * this.streams.length];
            System.arraycopy(this.streams, 0, newstreams, 0, this.streams.length);
            this.streams = newstreams;
        }
        ++this.active;
        System.arraycopy(this.streams, this.active, this.streams, this.active + 1, this.streams.length - this.active - 1);
        this.streams[this.active] = outputStream;
        return this.getActiveBuffer();
    }

    private class ArrayEnumeration
    implements Enumeration {
        int index;
        Object[] objArray;

        ArrayEnumeration(Object[] objs) {
            this.objArray = objs;
            this.index = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.index < this.objArray.length;
        }

        public Object nextElement() {
            return this.objArray[this.index++];
        }
    }

    private class MultiBufferPrivateByteArrayOutputStream
    implements PrivateByteArrayOutputStream {
        private int id;
        private MultiBufferByteArrayOutputStream out;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MultiBufferPrivateByteArrayOutputStream(MultiBufferByteArrayOutputStream out) {
            this.out = out;
            MultiBufferByteArrayOutputStream multiBufferByteArrayOutputStream2 = MultiBufferByteArrayOutputStream.this;
            synchronized (multiBufferByteArrayOutputStream2) {
                this.id = ++nextID;
            }
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public void copyTo(byte[] newbuf, int pos) {
            byte[] bytes = this.out.toByteArray();
            System.arraycopy(bytes, 0, newbuf, pos, bytes.length);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void reset() {
            this.out.reset();
        }

        @Override
        public int size() {
            return this.out.size();
        }

        @Override
        public InputStream toStream() {
            return this.out.toStream();
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.out.writeTo(out);
        }
    }

    private class RegularByteArrayOutputStream
    extends SharedByteArrayOutputStream
    implements PrivateByteArrayOutputStream {
        private int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegularByteArrayOutputStream(int size) {
            super(size);
            MultiBufferByteArrayOutputStream multiBufferByteArrayOutputStream2 = MultiBufferByteArrayOutputStream.this;
            synchronized (multiBufferByteArrayOutputStream2) {
                this.id = ++nextID;
            }
        }

        @Override
        public void copyTo(byte[] newbuf, int pos) {
            System.arraycopy(this.buf, 0, newbuf, pos, this.count);
        }

        @Override
        public int getID() {
            return this.id;
        }
    }

    private static interface PrivateByteArrayOutputStream {
        public void copyTo(byte[] var1, int var2);

        public InputStream toStream();

        public int size();

        public void close() throws IOException;

        public void reset();

        public void writeTo(OutputStream var1) throws IOException;

        public void write(byte[] var1, int var2, int var3);

        public void write(int var1) throws IOException;

        public int getID();
    }
}

