/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.portal.utils.EncodingUtils;
import com.cognos.portal.xml.stream.IXMLSerializable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Parameters
implements Collection,
IXMLSerializable {
    private List params = new ArrayList();
    private Map properties;

    public Parameters(XMLStreamReader xsr) throws XMLStreamException {
        this.read(xsr);
    }

    public Parameters() {
    }

    public NameValuePair add(String name, String value) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp == null) {
            nvp = new NameValuePair(name, value);
            this.params.add(nvp);
        } else {
            nvp.addValue(value);
        }
        return nvp;
    }

    public NameValuePair add(String name, String[] values) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp == null) {
            nvp = new NameValuePair(name, values);
            this.params.add(nvp);
        } else {
            nvp.addValues(values);
        }
        return nvp;
    }

    public boolean remove(String name) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp != null) {
            this.params.remove(nvp);
            return true;
        }
        return false;
    }

    public String getValue(String name) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp != null) {
            return nvp.getValue();
        }
        return null;
    }

    public String[] getValues(String name) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp != null) {
            return nvp.getValues();
        }
        return null;
    }

    public void setValue(String name, String value) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp != null) {
            nvp.setValue(value);
            return;
        }
        nvp = new NameValuePair(name, value);
        this.params.add(nvp);
    }

    public void setValues(String name, String[] values) {
        NameValuePair nvp = this.getNameValuePair(name);
        if (nvp != null) {
            nvp.setValues(values);
            return;
        }
        nvp = new NameValuePair(name, values);
        this.params.add(nvp);
    }

    public static Parameters parse(String params) {
        Parameters parameters = new Parameters();
        int i = params.indexOf(38);
        while (i >= 0) {
            String temp = params.substring(0, i);
            Parameters.parseNameValue(parameters, temp);
            params = params.substring(i + 1);
            i = params.indexOf(38);
        }
        Parameters.parseNameValue(parameters, params);
        return parameters;
    }

    private static void parseNameValue(Parameters parameters, String namesValues) {
        int p = namesValues.indexOf(61);
        if (p >= 0) {
            parameters.add(EncodingUtils.urldecode(namesValues.substring(0, p), "UTF-8"), EncodingUtils.urldecode(namesValues.substring(p + 1), "UTF-8"));
        } else if (!"".equals(namesValues)) {
            parameters.add(namesValues, (String)null);
        }
    }

    private NameValuePair getNameValuePair(String name) {
        for (NameValuePair nvp : this.params) {
            if (!nvp.getName().equals(name)) continue;
            return nvp;
        }
        return null;
    }

    public void writeAsFormUrlEncoded(OutputStream out) throws IOException {
        out.write(this.toString().getBytes());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] excludeArray) {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.params.iterator();
        boolean more = false;
        while (it.hasNext()) {
            NameValuePair nvp = (NameValuePair)it.next();
            String name = nvp.getName();
            if (this.containsValue(excludeArray, name)) continue;
            String[] values = nvp.getValues();
            for (int i = 0; i < values.length; ++i) {
                if (more) {
                    sb.append('&');
                }
                sb.append(name);
                sb.append('=');
                if (values[i] != null) {
                    sb.append(EncodingUtils.urlencode(values[i], "UTF-8", true));
                }
                more = true;
            }
        }
        return sb.toString();
    }

    private boolean containsValue(String[] array, String value) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public void clear() {
        this.params.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return this.params.toArray();
    }

    public boolean add(Object o) {
        if (o instanceof NameValuePair) {
            return this.params.add(o);
        }
        if (o instanceof Parameters) {
            return this.params.addAll((Parameters)o);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof NameValuePair) {
            return this.params.contains(o);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof NameValuePair) {
            return this.remove(((NameValuePair)o).name);
        }
        return false;
    }

    public boolean addAll(Collection c) {
        return this.add(c);
    }

    public boolean containsAll(Collection c) {
        return this.params.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.params.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.params.retainAll(c);
    }

    @Override
    public Iterator iterator() {
        return this.params.iterator();
    }

    public Object[] toArray(Object[] a) {
        return this.params.toArray(a);
    }

    @Override
    public void read(XMLStreamReader xsr) throws XMLStreamException {
        int level = 0;
        while (xsr.hasNext()) {
            int event = xsr.next();
            String localName = null;
            switch (event) {
                case 1: {
                    localName = xsr.getLocalName();
                    if ("param".equals(localName)) {
                        NameValuePair object = new NameValuePair(xsr);
                        this.add(object);
                        if (level != 0) break;
                        level = 1;
                        break;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (--level <= 0) {
                        return;
                    }
                    localName = xsr.getLocalName();
                }
            }
        }
    }

    @Override
    public void write(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("parameters");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            xsw.writeStartElement("param");
            ((NameValuePair)it.next()).write(xsw);
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.flush();
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public Object getProperty(String property) {
        if (this.properties != null) {
            return this.properties.get(property);
        }
        return null;
    }

    public class NameValuePair
    implements IXMLSerializable {
        private String name;
        private short flag;
        private String[] values;

        public NameValuePair(XMLStreamReader xsr) throws XMLStreamException {
            this.read(xsr);
        }

        public NameValuePair(String name, String value) {
            this.name = name;
            this.setValue(value);
        }

        public NameValuePair(String name, String[] values) {
            this.name = name;
            this.setValues(values);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            if (this.values != null) {
                return this.values[0];
            }
            return null;
        }

        public String[] getValues() {
            if (this.values != null) {
                String[] copy = new String[this.values.length];
                System.arraycopy(this.values, 0, copy, 0, this.values.length);
                return copy;
            }
            return null;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String newvalue) {
            this.values = new String[1];
            this.values[0] = newvalue;
        }

        public void setValues(String[] newvalues) {
            this.values = new String[newvalues.length];
            System.arraycopy(newvalues, 0, this.values, 0, newvalues.length);
        }

        public void addValue(String newvalue) {
            String[] copy = new String[this.values.length + 1];
            System.arraycopy(this.values, 0, copy, 0, this.values.length);
            copy[this.values.length] = newvalue;
            this.values = copy;
        }

        public void addValues(String[] newvalues) {
            String[] copy = new String[this.values.length + newvalues.length];
            System.arraycopy(this.values, 0, copy, 0, this.values.length);
            System.arraycopy(newvalues, 0, copy, this.values.length, newvalues.length);
            this.values = copy;
        }

        @Override
        public void read(XMLStreamReader xsr) throws XMLStreamException {
            this.setName(xsr.getAttributeValue("", "name"));
            while (xsr.hasNext()) {
                int event = xsr.next();
                switch (event) {
                    case 1: {
                        String localName = xsr.getLocalName();
                        if (!"values".equals(localName)) break;
                        this.setValues(this.readValues(xsr));
                        break;
                    }
                    case 2: {
                        if (!"param".equals(xsr.getLocalName())) break;
                        return;
                    }
                }
            }
        }

        private String[] readValues(XMLStreamReader xsr) throws XMLStreamException {
            String[] sa = new String[Integer.valueOf(xsr.getAttributeValue("", "size")).intValue()];
            int i = 0;
            while (xsr.hasNext()) {
                int event = xsr.next();
                switch (event) {
                    case 1: {
                        String localName = xsr.getLocalName();
                        if (!"value".equals(localName)) break;
                        sa[i] = xsr.getElementText();
                        ++i;
                        break;
                    }
                    case 2: {
                        if (!"values".equals(xsr.getLocalName())) break;
                        return sa;
                    }
                }
            }
            return null;
        }

        @Override
        public void write(XMLStreamWriter xsw) throws XMLStreamException {
            xsw.writeAttribute("name", this.name);
            String[] sa = this.getValues();
            if (sa != null) {
                xsw.writeStartElement("values");
                xsw.writeAttribute("size", String.valueOf(sa.length));
                for (int i = 0; i < sa.length; ++i) {
                    xsw.writeStartElement("value");
                    xsw.writeCharacters(sa[i]);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
            }
        }

        public void setFlag(int flag) {
            this.flag = (short)flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

