/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RecordingHelper {
    private int count = 0;

    public synchronized void writeToFile(String logData, String location, String baseFilename, ServiceLogger logger) {
        if (this.makeDirectory(logger, location)) {
            this.resetCount();
        }
        RecordingHelper.writeLogFile(logData, logger, location + "/" + this.getNumString(this.getCount()) + baseFilename);
        this.incCount();
    }

    private synchronized void resetCount() {
        this.count = 0;
    }

    private synchronized void incCount() {
        ++this.count;
    }

    private synchronized int getCount() {
        return this.count;
    }

    public static synchronized void writeLogFile(String logString, ServiceLogger logger, String filename) {
        block6: {
            try {
                FileOutputStream fos = new FileOutputStream(filename, true);
                fos.write(logString.getBytes("UTF-8"));
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException e) {
                if (logger != null && logger.isErrorEnabled()) {
                    logger.error("Pipeline output file not found", e);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (logger != null && logger.isErrorEnabled()) {
                    logger.error("Unsupported Encoding while writing pipeline output file", e);
                }
            }
            catch (IOException e) {
                if (logger == null || !logger.isErrorEnabled()) break block6;
                logger.error("Problem writing to pipeline output file", e);
            }
        }
    }

    private synchronized String getNumString(int count) {
        String zeros = "0000";
        String num = zeros + String.valueOf(count);
        num = num.substring(num.length() - 5, num.length());
        return num;
    }

    private synchronized boolean makeDirectory(ServiceLogger logger, String directory) {
        boolean isEmpty = false;
        File dir = new File(directory);
        if (dir.exists()) {
            File[] files;
            int length;
            if (!dir.isDirectory() && logger != null && logger.isErrorEnabled()) {
                logger.error("Cannot create folder, name already in use.");
            }
            if ((length = (files = dir.listFiles()).length) == 0) {
                isEmpty = true;
            } else {
                boolean noFilesInFolder = true;
                for (int i = 0; i < length; ++i) {
                    if (!files[i].isFile()) continue;
                    noFilesInFolder = false;
                    break;
                }
                if (noFilesInFolder) {
                    isEmpty = true;
                }
            }
        } else {
            isEmpty = true;
            dir.mkdirs();
        }
        return isEmpty;
    }

    public static String getCompleteDirectory(ServiceLogger logger, String directory, String busHeader) {
        String extraDir;
        block4: {
            extraDir = null;
            try {
                XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(new StringReader(busHeader));
                if (StaxUtils.moveToElement("cpsJUnitRecordLocation", xsr)) {
                    extraDir = xsr.getElementText();
                }
            }
            catch (XMLStreamException e1) {
                if (logger == null || !logger.isErrorEnabled()) break block4;
                logger.error("Record Pipeline extra directory location is not set.");
            }
        }
        if (extraDir != null) {
            directory = directory + "/" + extraDir;
        }
        return directory;
    }
}

