/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.SigningSession;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.cognos.accman.jcam.crypto.xml.GenericTrustedSession;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.utils.EncodingUtils;
import java.io.UnsupportedEncodingException;

public class TrustedSessionHelper {
    private static TrustedSessionHelper instance = new TrustedSessionHelper();
    private static final String CAM_INIT_PARAM = "<initializeDocument><serviceID>CPS</serviceID></initializeDocument>";
    private static CAMFactory camFactory;

    protected TrustedSessionHelper() {
        if (!"true".equals(System.getProperty("cps.unittest"))) {
            camFactory = new CAMFactory();
            try {
                camFactory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
            }
            catch (CAMCryptoException e) {
                camFactory = null;
            }
            catch (UnsupportedEncodingException e) {
                camFactory = null;
            }
        }
    }

    public static TrustedSessionHelper getInstance() {
        return instance;
    }

    static synchronized void setInstance(TrustedSessionHelper sessionHelper) {
        instance = sessionHelper;
    }

    public String createToken(String input, String passportID) {
        String token = null;
        if (camFactory != null && input != null) {
            try {
                GenericTrustedSession genericTrustedSession = camFactory.createGenericTrustedSession();
                byte[] tokenBytes = genericTrustedSession.createTrustToken(input.getBytes("UTF-8"), passportID);
                token = new String(tokenBytes);
            }
            catch (CAMCryptoException e) {
                token = null;
            }
            catch (UnsupportedEncodingException e) {
                token = null;
            }
        }
        return token;
    }

    public void verifyToken(String token, String input, String passportID) throws DashboardException {
        if (!(token != null && token.length() != 0 || input != null && input.length() != 0)) {
            return;
        }
        boolean valid = false;
        if (camFactory != null && token != null && input != null) {
            try {
                GenericTrustedSession genericTrustedSession = camFactory.createGenericTrustedSession();
                valid = genericTrustedSession.verifyTrustToken(token.getBytes("UTF-8"), input.getBytes("UTF-8"), passportID);
            }
            catch (CAMCryptoException e) {
                throw new DashboardException("pf.fragment.server.sessioncapabilityviolation", e);
            }
            catch (Exception e) {
                throw new DashboardException("pf.fragment.server.sessioncapabilityviolation", e);
            }
        }
        if (!valid) {
            throw new DashboardException("pf.fragment.server.sessioncapabilityviolation");
        }
    }

    public boolean verifyAuthenticityToken(String token, String userSessionId) {
        boolean valid = false;
        if (camFactory != null && token != null && userSessionId != null) {
            try {
                UserSessionIDSession userSessionIDSession = camFactory.createUserSessionIDSession();
                valid = 1 == userSessionIDSession.verifyAuthenticityToken(token.getBytes("UTF-8"), userSessionId.getBytes("UTF-8"));
            }
            catch (CAMCryptoException cAMCryptoException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valid;
    }

    public String generateAuthenticityToken(String userSessionId) {
        String token = null;
        if (camFactory != null && userSessionId != null) {
            try {
                UserSessionIDSession userSessionIDSession = camFactory.createUserSessionIDSession();
                byte[] bytes = userSessionIDSession.generateAuthenticityToken(userSessionId.getBytes("UTF-8"));
                token = new String(bytes, "UTF-8");
            }
            catch (CAMCryptoException cAMCryptoException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return token;
    }

    public String createBase64HMAC(String input) {
        byte[] tokenBytes = null;
        if (camFactory != null) {
            try {
                SigningSession signingSession = camFactory.createSigningSession();
                tokenBytes = signingSession.hmac(input.getBytes("UTF8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tokenBytes == null) {
            tokenBytes = new byte[]{};
        }
        return EncodingUtils.base64encode(tokenBytes, true);
    }

    public boolean veifyBase64HMAC(String token, String input) {
        boolean isVerified = false;
        if (camFactory != null) {
            try {
                SigningSession signingSession = camFactory.createSigningSession();
                isVerified = signingSession.hmacVerify(EncodingUtils.base64decode(token, true), input.getBytes("UTF8"));
            }
            catch (CAMCryptoException cAMCryptoException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return isVerified;
    }

    public static String staticCreateBase64HMAC(String input) {
        return TrustedSessionHelper.getInstance().createBase64HMAC(input);
    }

    public static boolean staticVeifyBase64HMAC(String token, String input) {
        return TrustedSessionHelper.getInstance().veifyBase64HMAC(token, input);
    }

    public static String staticGenerateAuthToken(String userSessionId) {
        return TrustedSessionHelper.getInstance().generateAuthenticityToken(userSessionId);
    }
}

