/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;

class BrowserBasedCapabilities {
    static String PS_SYSTEM_BROWSER_BASED_CAPABILITY_XPATH = "/system/param[@name='capabilities']/capability";
    private HashMap<String, BrowserEntry> browserBasedCapabilityEntries = new HashMap();

    BrowserBasedCapabilities() {
    }

    public void parse(Element systemElem) {
        List ps_capabilities = systemElem.selectNodes(PS_SYSTEM_BROWSER_BASED_CAPABILITY_XPATH);
        for (int i = 0; i < ps_capabilities.size(); ++i) {
            Element obj = (Element)ps_capabilities.get(i);
            BrowserEntry b = new BrowserEntry();
            b.parse(obj.attributeValue("browser"));
            this.browserBasedCapabilityEntries.put(obj.attributeValue("name"), b);
        }
    }

    public boolean hasCapabilityForBrowser(String capability, String browser) {
        ArrayList<String> browsers = new ArrayList<String>();
        browsers.add(browser);
        return this.hasCapabilityForBrowser(capability, browsers);
    }

    public boolean hasCapabilityForBrowser(String capability, List browsers) {
        BrowserEntry e = this.browserBasedCapabilityEntries.get(capability);
        if (e == null) {
            return true;
        }
        boolean isBrowserPresent = false;
        if (browsers != null) {
            for (int i = 0; i < browsers.size(); ++i) {
                String browser = (String)browsers.get(i);
                if (browser != null && !"".equals(browser)) {
                    isBrowserPresent = true;
                }
                if (!e.match(browser)) continue;
                return true;
            }
        }
        return !isBrowserPresent;
    }

    private class BrowserEntry {
        Map browsersMap = new HashMap();

        public void parse(String browsers) {
            if (browsers != null) {
                StringTokenizer t = new StringTokenizer(browsers);
                while (t.hasMoreTokens()) {
                    String v = t.nextToken();
                    this.browsersMap.put(v, new Boolean(true));
                }
            }
        }

        public boolean match(String browser) {
            return this.browsersMap.containsKey(browser);
        }
    }
}

