/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils.capability;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.common.logging.ServiceLoggerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public abstract class Expression {
    public static final String OP_AND = "and";
    public static final String OP_NOT = "not";
    public static final String OP_OR = "or";
    private static final char OP_SYMBOL_AND = '&';
    private static final char OP_SYMBOL_NOT = '!';
    private static final char OP_SYMBOL_OR = '|';
    private static final char OP_SYMBOL_UNKNOWN = 'U';
    public static final String OP_EQ = "eq";
    public static final String OP_NEQ = "neq";
    public static final String OP_LEQ = "leq";
    public static final String OP_GEQ = "geq";
    public static final String OP_LT = "lt";
    public static final String OP_GT = "gt";
    private static final char OP_SYMBOL_EQ = '=';
    private static final char OP_SYMBOL_NEQ = 'N';
    private static final char OP_SYMBOL_LEQ = 'L';
    private static final char OP_SYMBOL_GEQ = 'G';
    private static final char OP_SYMBOL_LT = '<';
    private static final char OP_SYMBOL_GT = '>';
    private static final String OPND_ENUMVALUE = "enumValue";
    protected static ServiceLogger m_logger = new ServiceLoggerImpl(Expression.class);
    private String enumValue;
    private Comparison comparison;
    private subExpression exprHead;
    private String parentExprName;
    private final int LITERAL_STRING = 0;
    private final int LITERAL_INT = 1;
    private final int LITERAL_DATE = 2;

    public Expression(Element parentExprRoot) {
        this.startParse(parentExprRoot);
    }

    public void setExpressionManually(String enumVal, String opName, String[] enumValsList) {
        this.parentExprName = "manual Expression";
        if (enumVal != null) {
            this.enumValue = enumVal;
        } else if (opName != null && enumValsList != null) {
            this.exprHead = new subExpression();
            this.exprHead.setOperator(opName);
            for (int i = 0; i < enumValsList.length; ++i) {
                this.exprHead.addOperand(enumValsList[i]);
            }
        }
    }

    public void setExpressionManually(String rpnExpr) {
        if (rpnExpr != null) {
            RPNtransform t = new RPNtransform();
            this.startParse(t.transform("manual-RPN-Expression", rpnExpr));
        }
    }

    private void startParse(Element parentExprRoot) {
        if (parentExprRoot == null) {
            return;
        }
        this.parentExprName = parentExprRoot.getName();
        this.parseExpression(parentExprRoot, null);
    }

    private void parseExpression(Element exprRoot, subExpression subExp) {
        block9: {
            try {
                int size = exprRoot.nodeCount();
                for (int i = 0; i < size; ++i) {
                    Node node = exprRoot.node(i);
                    if (!(node instanceof Element)) continue;
                    Element elem = (Element)node;
                    String name = elem.getName();
                    if (name.equals(OP_AND) || name.equals(OP_OR) || name.equals(OP_NOT)) {
                        subExpression nestedExp = new subExpression();
                        nestedExp.setOperator(name);
                        if (this.exprHead == null) {
                            this.exprHead = nestedExp;
                            subExp = nestedExp;
                            this.parseExpression(elem, nestedExp);
                            continue;
                        }
                        subExp.addOperand(nestedExp);
                        this.parseExpression(elem, nestedExp);
                        continue;
                    }
                    if (name.equals(OPND_ENUMVALUE)) {
                        if (this.exprHead == null) {
                            this.enumValue = elem.getTextTrim();
                            continue;
                        }
                        subExp.addOperand(elem.getTextTrim());
                        continue;
                    }
                    if (name.equals(OP_EQ) || name.equals(OP_NEQ) || name.equals(OP_LEQ) || name.equals(OP_GEQ) || name.equals(OP_LT) || name.equals(OP_GT)) {
                        Comparison curComp = new Comparison();
                        curComp.setOperator(name);
                        curComp.parseComparison(elem);
                        if (this.exprHead == null) {
                            this.comparison = curComp;
                            continue;
                        }
                        subExp.addOperand(curComp);
                        continue;
                    }
                    if (name.equals("property") || name.equals("string_literal") || name.equals("numeric_literal") || name.equals("date_literal") || !m_logger.isDebugEnabled()) continue;
                    m_logger.debug("Expression parse exception1  - " + this.parentExprName);
                }
            }
            catch (Exception e) {
                if (!m_logger.isDebugEnabled()) break block9;
                m_logger.debug("Expression parse exception2  - " + this.parentExprName);
            }
        }
    }

    public boolean evaluateExpression() {
        boolean answer = true;
        if (this.enumValue != null) {
            answer = this.evaluateEnumValue(this.enumValue);
        } else if (this.comparison != null) {
            answer = this.comparison.evaluate();
        } else if (this.exprHead != null) {
            answer = this.evaluateSubExpression(this.exprHead);
        }
        return answer;
    }

    private boolean evaluateSubExpression(subExpression subExp) {
        boolean answer = false;
        if (subExp != null) {
            char op = subExp.getOperator();
            boolean firstLoop = true;
            for (Object operand : subExp.getOperands()) {
                boolean subAnswer;
                if (operand instanceof String) {
                    subAnswer = this.evaluateEnumValue((String)operand);
                } else if (operand instanceof Comparison) {
                    subAnswer = ((Comparison)operand).evaluate();
                } else if (operand instanceof subExpression) {
                    subAnswer = this.evaluateSubExpression((subExpression)operand);
                } else {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug("Expression evaluation exception1  - " + this.parentExprName);
                    }
                    return false;
                }
                switch (op) {
                    case '&': {
                        if (firstLoop) {
                            answer = subAnswer;
                            firstLoop = false;
                        } else {
                            boolean bl = answer = answer && subAnswer;
                        }
                        if (answer) break;
                        return answer;
                    }
                    case '|': {
                        if (firstLoop) {
                            answer = subAnswer;
                            firstLoop = false;
                        } else {
                            boolean bl = answer = answer || subAnswer;
                        }
                        if (!answer) break;
                        return answer;
                    }
                    case '!': {
                        answer = !subAnswer;
                    }
                }
            }
        }
        return answer;
    }

    protected abstract boolean evaluateEnumValue(String var1);

    protected abstract String evaluateProperty(String var1);

    private static class RPNtransform {
        public static final int OPERAND = 1;
        public static final int OPERATOR = 2;
        private static Map operator_table = new HashMap();

        private RPNtransform() {
        }

        private int token_type(String token) {
            return operator_table.get(token) != null ? 2 : 1;
        }

        public Element transform(String rootName, String expr) {
            Element root = DocumentHelper.createElement((String)rootName);
            StringTokenizer e = new StringTokenizer(expr);
            if (!e.hasMoreTokens()) {
                return root;
            }
            Stack<Element> s = new Stack<Element>();
            while (e.hasMoreTokens()) {
                String t = e.nextToken();
                switch (this.token_type(t)) {
                    case 1: {
                        Element o = DocumentHelper.createElement((String)Expression.OPND_ENUMVALUE);
                        o.setText(t);
                        s.push(o);
                        break;
                    }
                    case 2: {
                        Element exprNode = DocumentHelper.createElement((String)t);
                        int noprnds = (Integer)operator_table.get(t);
                        for (int i = 0; i < noprnds; ++i) {
                            if (s.isEmpty()) {
                                throw new RuntimeException("missing operand(s)");
                            }
                            Element operand = (Element)s.pop();
                            operand.detach();
                            exprNode.add(operand);
                        }
                        s.push(exprNode);
                    }
                }
            }
            if (s.isEmpty()) {
                throw new RuntimeException("missing result");
            }
            root.add((Element)s.pop());
            return root;
        }

        static {
            operator_table.put(Expression.OP_AND, new Integer(2));
            operator_table.put(Expression.OP_OR, new Integer(2));
            operator_table.put(Expression.OP_NOT, new Integer(1));
        }
    }

    private class subExpression {
        private char operator;
        private List operands = new ArrayList();

        public void setOperator(String opName) {
            this.operator = opName.equals(Expression.OP_AND) ? (char)38 : (opName.equals(Expression.OP_NOT) ? (char)33 : (opName.equals(Expression.OP_OR) ? (char)124 : (char)85));
        }

        public char getOperator() {
            return this.operator;
        }

        public void addOperand(String operand) {
            this.operands.add(operand);
        }

        public void addOperand(subExpression subExpr) {
            this.operands.add(subExpr);
        }

        public void addOperand(Comparison comparison) {
            this.operands.add(comparison);
        }

        public List getOperands() {
            return this.operands;
        }
    }

    private class Comparison {
        private char operator;
        int compareType = 0;
        private List operands = new ArrayList(2);

        public void setOperator(String opName) {
            this.operator = opName.equals(Expression.OP_EQ) ? (char)61 : (opName.equals(Expression.OP_NEQ) ? (char)78 : (opName.equals(Expression.OP_GEQ) ? (char)71 : (opName.equals(Expression.OP_LEQ) ? (char)76 : (opName.equals(Expression.OP_GT) ? (char)62 : (opName.equals(Expression.OP_LT) ? (char)60 : (char)85)))));
        }

        public char getOperator() {
            return this.operator;
        }

        public void addOperand(String property) {
            this.operands.add(property);
        }

        public void addOperand(Literal literal) {
            this.operands.add(literal);
        }

        public List getOperands() {
            return this.operands;
        }

        public void parseComparison(Element comparisonRoot) {
            block7: {
                try {
                    int size = comparisonRoot.nodeCount();
                    for (int i = 0; i < size; ++i) {
                        Literal literal;
                        Node node = comparisonRoot.node(i);
                        if (!(node instanceof Element)) continue;
                        Element elem = (Element)node;
                        String name = elem.getName();
                        if (name.equals("property")) {
                            this.addOperand(elem.getTextTrim());
                            continue;
                        }
                        if (name.equals("string_literal")) {
                            literal = new Literal(0, elem.getTextTrim());
                            this.addOperand(literal);
                            this.compareType = 0;
                            continue;
                        }
                        if (name.equals("numeric_literal")) {
                            literal = new Literal(1, elem.getTextTrim());
                            this.addOperand(literal);
                            this.compareType = 1;
                            continue;
                        }
                        if (name.equals("date_literal")) {
                            literal = new Literal(2, elem.getTextTrim());
                            this.addOperand(literal);
                            this.compareType = 2;
                            continue;
                        }
                        if (!m_logger.isDebugEnabled()) continue;
                        m_logger.debug("Expression parse exception5  - " + Expression.this.parentExprName);
                    }
                }
                catch (Exception e) {
                    if (!m_logger.isDebugEnabled()) break block7;
                    m_logger.debug("Expression parse exception6  - " + Expression.this.parentExprName);
                }
            }
        }

        private String evaluateOperand(Object operand) {
            String operandValue = "";
            if (operand instanceof String) {
                operandValue = Expression.this.evaluateProperty((String)operand);
            } else if (operand instanceof Literal) {
                operandValue = ((Literal)operand).getValue();
            }
            return operandValue;
        }

        public boolean evaluate() {
            boolean answer;
            block25: {
                answer = false;
                try {
                    if (this.operands.size() == 2) {
                        Object firstOperand = this.operands.get(0);
                        Object secondOperand = this.operands.get(1);
                        String firstString = this.evaluateOperand(firstOperand);
                        String secondString = this.evaluateOperand(secondOperand);
                        if (firstString == null || secondString == null) {
                            answer = true;
                        } else {
                            block1 : switch (this.compareType) {
                                case 0: 
                                case 2: {
                                    int stCmp = firstString.compareTo(secondString);
                                    switch (this.operator) {
                                        case '=': {
                                            answer = stCmp == 0;
                                            break block1;
                                        }
                                        case 'N': {
                                            answer = stCmp != 0;
                                            break block1;
                                        }
                                        case 'L': {
                                            answer = stCmp <= 0;
                                            break block1;
                                        }
                                        case 'G': {
                                            answer = stCmp >= 0;
                                            break block1;
                                        }
                                        case '<': {
                                            answer = stCmp < 0;
                                            break block1;
                                        }
                                        case '>': {
                                            answer = stCmp > 0;
                                        }
                                    }
                                    break;
                                }
                                case 1: {
                                    int firstInt = Integer.parseInt(firstString);
                                    int secondInt = Integer.parseInt(secondString);
                                    switch (this.operator) {
                                        case '=': {
                                            answer = firstInt == secondInt;
                                            break block1;
                                        }
                                        case 'N': {
                                            answer = firstInt != secondInt;
                                            break block1;
                                        }
                                        case 'L': {
                                            answer = firstInt <= secondInt;
                                            break block1;
                                        }
                                        case 'G': {
                                            answer = firstInt >= secondInt;
                                            break block1;
                                        }
                                        case '<': {
                                            answer = firstInt < secondInt;
                                            break block1;
                                        }
                                        case '>': {
                                            answer = firstInt > secondInt;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!m_logger.isDebugEnabled()) break block25;
                    m_logger.debug("comparison evaluation exception  - " + Expression.this.parentExprName);
                }
            }
            return answer;
        }
    }

    private class Literal {
        int type;
        String value;

        public Literal(int type, String value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

