/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils.capability;

import com.cognos.portal.utils.capability.CapabilityHelpers;
import com.cognos.portal.utils.capability.Expression;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Element;

public class RequiredCapabilities
extends Expression {
    private HashSet capabilities;
    private List browsers;

    public RequiredCapabilities(Element exprRoot) {
        super(exprRoot);
    }

    public RequiredCapabilities(String cap) {
        super(null);
        if (cap != null && cap.length() > 0) {
            this.setExpressionManually(cap, null, null);
        }
    }

    public RequiredCapabilities(String expr, boolean rpnExpression) {
        super(null);
        this.setExpressionManually(expr);
    }

    public boolean hasCapabilities(HashSet capabilities, List browsers) {
        if (capabilities == null) {
            return false;
        }
        this.capabilities = capabilities;
        this.browsers = browsers;
        return this.evaluateExpression();
    }

    public boolean hasCapabilities(HashSet capabilities, String browser) {
        ArrayList<String> browserList = new ArrayList<String>();
        browserList.add(browser);
        return this.hasCapabilities(capabilities, browserList);
    }

    @Override
    protected boolean evaluateEnumValue(String capability) {
        return this.capabilities.contains(capability) && CapabilityHelpers.hasCapabilityForBrowser(capability, this.browsers);
    }

    @Override
    protected String evaluateProperty(String value) {
        return "";
    }

    public static String parseRequiredCapabilities(String requiredCapabilitiesXML) throws XMLStreamException {
        XMLStreamReader reader;
        if (requiredCapabilitiesXML != null && !"".equals(requiredCapabilitiesXML) && StaxUtils.moveToElement("requiredCapabilities", reader = XMLStreamFactory.createXMLStreamReader(new StringReader(requiredCapabilitiesXML.toString())))) {
            return reader.getElementText();
        }
        return null;
    }
}

