/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils.capability;

import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.utils.LocalizableRuntimeException;
import com.cognos.portal.utils.TrustedSessionHelper;
import com.cognos.portal.utils.capability.CapabilityHelpers;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.portal.xml.stream.XMLStreamReaderRecorder;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Element;

public class UserCapabilities {
    private static String AUGMENT_CAPABILITY_CALC_CANUSECOGNOSINSIGHT = "canUseCognosInsight";
    private HashSet<String> userCapabilities = new HashSet();
    private String signature = null;
    private String userCapabilitiesXML = null;
    private String passportID = null;
    private boolean verified = false;

    public void processUserCapabilityCache(XMLStreamReader reader, String passportID) throws XMLStreamException {
        reader = new XMLStreamReaderRecorder("userCapabilities", reader);
        XMLStreamReaderRecorder userCapabilitiesXMLRecorder = (XMLStreamReaderRecorder)reader;
        boolean inUserCapabilitiesEle = false;
        String localName = null;
        reader.next();
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                localName = reader.getLocalName();
                if ("userCapabilities".equals(localName)) {
                    inUserCapabilitiesEle = true;
                } else if (inUserCapabilitiesEle && "item".equals(localName)) {
                    String capability = this.augmentCapabilityCalculation(reader.getElementText().trim());
                    if (capability != null && !capability.equals("canUseReportStudio") && !capability.equals("canUseIndexSearch")) {
                        this.userCapabilities.add(capability);
                    }
                } else if ("signature".equals(localName)) {
                    this.signature = reader.getElementText().trim();
                }
            } else if (reader.isEndElement()) {
                localName = reader.getLocalName();
                if ("userCapabilities".equals(localName)) {
                    inUserCapabilitiesEle = false;
                } else if ("userCapabilityCache".equals(localName)) break;
            }
            reader.next();
        }
        this.userCapabilitiesXML = userCapabilitiesXMLRecorder.getRecordedString();
        this.passportID = passportID;
    }

    public String getPassportID() {
        return this.passportID;
    }

    public void setPassport(String passportID) {
        this.passportID = passportID;
    }

    public void processUserCapabilityCache(Element userCapabilityCacheEle, String passportID) {
        if (userCapabilityCacheEle != null) {
            this.userCapabilities = new HashSet();
            Element userCapabilitiesEle = userCapabilityCacheEle.element("userCapabilities");
            if (userCapabilitiesEle != null) {
                List userCapabilitiesItems = userCapabilitiesEle.elements("item");
                for (int i = 0; i < userCapabilitiesItems.size(); ++i) {
                    Element item = (Element)userCapabilitiesItems.get(i);
                    String capability = this.augmentCapabilityCalculation(item.getText());
                    if (capability == null) continue;
                    this.userCapabilities.add(capability);
                }
                this.userCapabilitiesXML = userCapabilitiesEle.asXML();
                Element signatureEle = userCapabilityCacheEle.element("signature");
                if (signatureEle != null) {
                    this.signature = signatureEle.getText();
                }
            }
        }
        this.passportID = passportID;
    }

    public void processUserCapabilityCache(String userCapabilityCacheXML, String passportID) throws XMLStreamException {
        if (userCapabilityCacheXML == null || "".equals(userCapabilityCacheXML.trim())) {
            this.passportID = passportID;
            return;
        }
        StringReader sr = new StringReader(userCapabilityCacheXML);
        XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(sr);
        this.processUserCapabilityCache(reader, passportID);
    }

    public HashSet<String> getUserCapabilities() {
        this.verifyUserCapabilities();
        return this.userCapabilities;
    }

    private void verifyUserCapabilities() {
        if (!this.verified) {
            this.verified = true;
            try {
                TrustedSessionHelper.getInstance().verifyToken(this.signature, this.userCapabilitiesXML, this.passportID);
            }
            catch (DashboardException e) {
                this.userCapabilities.clear();
                throw new LocalizableRuntimeException("pf.fragment.server.sessioncapabilityviolation", e);
            }
        }
    }

    private String augmentCapabilityCalculation(String capability) {
        if (AUGMENT_CAPABILITY_CALC_CANUSECOGNOSINSIGHT.equals(capability) && !CapabilityHelpers.isCognosInsightInstalled()) {
            capability = null;
        }
        return capability;
    }
}

