/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.utils.localization;

import com.cognos.portal.utils.CCLLocaleUtils;
import com.cognos.portal.utils.localization.ResourceValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class MessageFileHelper {
    private static Map<String, Document> messageFileDocuments = new WeakHashMap<String, Document>();

    protected abstract InputStream getInputStream(String var1) throws IOException;

    protected Set<String> getResourcePaths(String tempFileName) {
        return null;
    }

    public List getResourceValueListContentLocale(String messageFile, String titleResourceId) throws IOException, DocumentException {
        return this.getResourceValueList(messageFile, titleResourceId, CCLLocaleUtils.getContentLocalesAsStrings());
    }

    public List getResourceValueListProductLocale(String messageFile, String titleResourceId) throws IOException, DocumentException {
        return this.getResourceValueList(messageFile, titleResourceId, CCLLocaleUtils.getProductLocalesAsStrings());
    }

    public List getResourceValueList(String messageFile, String titleResourceId, String[] localeNames) throws IOException, DocumentException {
        int dotIndex;
        Object[] supportedContentLocales = CCLLocaleUtils.getContentLocales();
        Object[] supportedProductLocales = CCLLocaleUtils.getProductLocales();
        if (messageFile != null && (dotIndex = messageFile.lastIndexOf(".xml")) > 0) {
            String locale;
            int i;
            String tempFileName = messageFile.substring(0, dotIndex);
            Set<String> paths = null;
            String tempFilePath = messageFile.substring(0, messageFile.lastIndexOf("/") + 1);
            paths = this.getResourcePaths(tempFilePath);
            ArrayList<String> newLocales = new ArrayList<String>();
            for (i = 0; i < supportedContentLocales.length; ++i) {
                locale = supportedContentLocales[i].toString();
                String contentMessageFile = tempFileName + "RL_" + locale + ".xml";
                if (paths != null) {
                    if (!paths.contains(contentMessageFile)) continue;
                    newLocales.add(locale);
                    continue;
                }
                if (this.getInputStream(contentMessageFile) == null) continue;
                newLocales.add(locale);
            }
            supportedContentLocales = newLocales.toArray();
            newLocales = new ArrayList();
            for (i = 0; i < supportedProductLocales.length; ++i) {
                locale = supportedProductLocales[i].toString();
                String productMessageFile = tempFileName + "_" + locale + ".xml";
                if (paths != null) {
                    if (!paths.contains(productMessageFile)) continue;
                    newLocales.add(locale);
                    continue;
                }
                if (this.getInputStream(productMessageFile) == null) continue;
                newLocales.add(locale);
            }
            supportedProductLocales = newLocales.toArray();
        }
        return this.getResourceValueList(messageFile, titleResourceId, localeNames, supportedContentLocales, supportedProductLocales);
    }

    private List getResourceValueList(String messageFile, String resourceId, String[] locales, Object[] supportedContentLocales, Object[] supportedProductLocales) throws IOException, DocumentException {
        ArrayList<ResourceValue> result = null;
        if (resourceId != null && resourceId.length() > 0 && messageFile != null && messageFile.length() > 0) {
            result = new ArrayList<ResourceValue>();
            String defaultLocale = CCLLocaleUtils.getServerLocale();
            if (defaultLocale == null) {
                defaultLocale = "en";
            }
            if (locales == null) {
                locales = new String[]{defaultLocale};
            }
            for (int i = 0; i < locales.length; ++i) {
                String localeName = locales[i];
                ResourceValue value = this.getResource(resourceId, messageFile, localeName, defaultLocale, supportedContentLocales, supportedProductLocales);
                if (value == null || result.contains(value)) continue;
                result.add(value);
            }
        }
        return result;
    }

    private ResourceValue getResource(String resourceId, String messageFile, String localeName, String defaultLocale, Object[] supportedContentLocales, Object[] supportedProductLocales) throws IOException, DocumentException {
        int dotIndex = messageFile.lastIndexOf(".xml");
        if (dotIndex != -1) {
            String productMessageFile;
            String resource;
            String contentMessageFile;
            String resource2;
            String contentLocale = CCLLocaleUtils.getValidContentLocale(localeName, supportedContentLocales, defaultLocale);
            if (contentLocale != null && (resource2 = this.getResource(resourceId, contentMessageFile = messageFile.substring(0, dotIndex) + "RL_" + contentLocale + ".xml")) != null && !"".equals(resource2)) {
                return new ResourceValue(resource2, contentLocale);
            }
            String productLocale = CCLLocaleUtils.getValidProductLocale(localeName, supportedProductLocales, defaultLocale);
            if (productLocale != null && (resource = this.getResource(resourceId, productMessageFile = messageFile.substring(0, dotIndex) + "_" + productLocale + ".xml")) != null && !"".equals(resource)) {
                return new ResourceValue(resource, productLocale);
            }
        }
        return null;
    }

    private synchronized String getResource(String resourceId, String messageFile) throws IOException, DocumentException {
        Document doc = messageFileDocuments.get(messageFile);
        if (doc == null) {
            InputStream messageFileInputStream = this.getInputStream(messageFile);
            if (messageFileInputStream == null) {
                return null;
            }
            SAXReader reader = new SAXReader();
            doc = reader.read(messageFileInputStream);
            messageFileDocuments.put(messageFile, doc);
        }
        return doc.valueOf("/stringTable/component/section/string[@id=\"" + resourceId + "\"]");
    }
}

