/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.i18n;

import com.cognos.portal.IResourceContext;
import com.cognos.portal.utils.CCLLocaleUtils;
import com.cognos.portal.xml.i18n.LocalizedMessages;
import java.util.HashMap;
import java.util.Map;

public class LocalizationManager {
    private static LocalizationManager instance = new LocalizationManager();
    private Map files;

    private LocalizationManager() {
    }

    public static LocalizationManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        LocalizationManager localizationManager = instance;
        synchronized (localizationManager) {
            this.files = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        LocalizationManager localizationManager = instance;
        synchronized (localizationManager) {
            this.files = null;
        }
    }

    public LocalizedMessages getMessages(IResourceContext resourceContext, String messageFile, String locale) {
        String localeFile = LocalizationManager.buildFile(messageFile, locale, false);
        LocalizedMessages messages = (LocalizedMessages)this.files.get(localeFile);
        if (messages == null) {
            boolean found;
            String defaultLocale = CCLLocaleUtils.getServerLocale();
            if (defaultLocale == null) {
                defaultLocale = "en";
            }
            if (!(found = (messages = new LocalizedMessages()).load(resourceContext, localeFile)) && !defaultLocale.equals(locale)) {
                found = messages.load(resourceContext, LocalizationManager.buildFile(messageFile, defaultLocale, false));
            }
            if (!(found = messages.load(resourceContext, LocalizationManager.buildFile(messageFile, locale, true))) && !defaultLocale.equals(locale)) {
                found = messages.load(resourceContext, LocalizationManager.buildFile(messageFile, defaultLocale, true));
            }
            this.files.put(localeFile, messages);
        }
        return messages;
    }

    private static String buildFile(String messageFile, String locale, boolean isContentLocale) {
        int dotIndex = messageFile.lastIndexOf(".xml");
        if (dotIndex != -1) {
            if (isContentLocale) {
                return messageFile.substring(0, dotIndex) + "RL_" + locale + ".xml";
            }
            return messageFile.substring(0, dotIndex) + "_" + locale + ".xml";
        }
        return messageFile;
    }

    static {
        instance.initialize();
    }
}

