/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.i18n;

import com.cognos.portal.utils.EncodingUtils;
import com.ctc.wstx.evt.WCharacters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class MessagesEventReader
extends EventReaderDelegate {
    private static final QName QN_STRING = new QName("http://developer.cognos.com/schemas/xts/", "string");
    private static final QName QN_PARAM = new QName("http://developer.cognos.com/schemas/xts/", "param");
    private static final QName QN_ID = new QName("", "id");
    private static final QName QN_NAME = new QName("", "name");
    private static final QName QN_ENCODE = new QName("", "encode");
    private static final int ENCODING_NONE = 0;
    private static final int ENCODING_JAVASCRIPT = 1;
    private static final int ENCODING_XML = 2;
    private Map strings;
    private List pending = new ArrayList();

    public MessagesEventReader(XMLEventReader reader, Map strings) {
        super(reader);
        this.strings = strings;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        StartElement se;
        XMLEvent peek;
        if (this.pending.size() > 0) {
            return (XMLEvent)this.pending.remove(this.pending.size() - 1);
        }
        XMLEvent event = super.nextEvent();
        if (event.isCharacters() && event.asCharacters().isWhiteSpace() && (peek = super.peek()).isStartElement() && QN_STRING.equals(peek.asStartElement().getName())) {
            event = super.nextEvent();
        }
        if (event.isStartElement() && QN_STRING.equals((se = event.asStartElement()).getName())) {
            Attribute encode;
            Attribute id = se.getAttributeByName(QN_ID);
            String text = (String)this.strings.get(id.getValue());
            if (text == null) {
                text = id.getValue();
            }
            int encoding = (encode = se.getAttributeByName(QN_ENCODE)) != null ? this.getEncodingType(encode.getValue()) : 0;
            int startParam = text.indexOf(123);
            int endParam = text.indexOf(125, startParam + 1);
            while (startParam != -1 && endParam != -1) {
                String beforeText = this.encodeText(text.substring(0, startParam), encoding);
                this.pending.add(new WCharacters(null, beforeText, false));
                String name = text.substring(startParam + 1, endParam);
                this.pending.add(new Marker(name));
                text = text.substring(endParam + 1);
                startParam = text.indexOf(123);
                endParam = text.indexOf(125, startParam + 1);
            }
            this.pending.add(new WCharacters(null, this.encodeText(text, encoding), false));
            int level = 0;
            while (super.hasNext() && level >= 0) {
                XMLEvent evt = super.nextEvent();
                if (evt.isStartElement()) {
                    Attribute name;
                    StartElement startElement = evt.asStartElement();
                    if (QN_PARAM.equals(startElement.getName()) && (name = startElement.getAttributeByName(QN_NAME)) != null) {
                        ArrayList list = new ArrayList();
                        this.captureParamEventList(list, true);
                        int index = this.pending.indexOf((Object)new Marker(name.getValue()));
                        if (index == -1) continue;
                        this.pending.remove(index);
                        this.pending.addAll(index, list);
                        continue;
                    }
                    ++level;
                    continue;
                }
                if (!evt.isEndElement()) continue;
                --level;
            }
            XMLEvent peek2 = super.peek();
            if (peek2.isCharacters() && peek2.asCharacters().isWhiteSpace()) {
                super.nextEvent();
            }
            MessagesEventReader.reverse(this.pending);
            event = (XMLEvent)this.pending.remove(this.pending.size() - 1);
        }
        return event;
    }

    @Override
    public boolean hasNext() {
        if (this.pending.size() > 0) {
            return true;
        }
        return super.hasNext();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.pending.size() > 0) {
            return (XMLEvent)this.pending.get(this.pending.size() - 1);
        }
        return super.peek();
    }

    private void captureParamEventList(List paramList, boolean removeWhitespace) throws XMLStreamException {
        int level = 0;
        while (super.hasNext()) {
            XMLEvent evt = super.nextEvent();
            if (evt.isStartElement()) {
                ++level;
            } else if (evt.isEndElement()) {
                if (--level < 0) {
                    return;
                }
            } else if (removeWhitespace && evt.isCharacters() && evt.asCharacters().isWhiteSpace()) continue;
            paramList.add(evt);
        }
    }

    private static void reverse(List list) {
        int loops = list.size() / 2;
        int first = 0;
        int last = list.size() - 1;
        while (first < loops) {
            list.set(last, list.set(first, list.get(last)));
            ++first;
            --last;
        }
    }

    private int getEncodingType(String encoding) {
        if ("javascript".equals(encoding)) {
            return 1;
        }
        if ("xml".equals(encoding)) {
            return 2;
        }
        return 0;
    }

    private String encodeText(String text, int encoding) {
        if (1 == encoding) {
            StringBuffer sbuf = new StringBuffer(text.length());
            EncodingUtils.javascriptencode(text, sbuf);
            return sbuf.toString();
        }
        if (2 == encoding) {
            StringBuffer buffer = new StringBuffer();
            EncodingUtils.xmlEncode(text, buffer);
            return buffer.toString();
        }
        return text;
    }

    private class Marker
    extends WCharacters {
        private String name;

        Marker(String name) {
            super(null, "{" + name + "}", false);
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Marker) {
                return ((Marker)((Object)obj)).name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

