/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.utils.RecordingHelper;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.ProcessInstance;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.OutputDetails;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.IXMLSerializable;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DebugHelper {
    private static final String PRE_EXECUTION_PARAM_SNAPSHOT = "debug.param.pre.";
    private static final String POST_EXECUTION_PARAM_SNAPSHOT = "debug.param.post.";
    private static final String TAG_OUTPUTDETAILS = "details";
    private static final String ATTR_STATUS_CODE = "statusCode";
    private static final String ATTR_ETAG = "ETag";
    private static final String ATTR_ENCODING = "encoding";
    private static final String ATTR_CONTENT_TYPE = "contentType";
    private static final String ATTR_AS_DOCUMENT_ATTACHMENT = "asDocumentAttachment";
    private static RecordingHelper recordingHelper = new RecordingHelper();
    private Map preExecutionProcessParams = new HashMap();
    private Map postExecutionProcessParams = new HashMap();
    private Map traceXML = new HashMap();
    private List executionOrder = new ArrayList();
    private Map outputProducers = new HashMap();
    private Pipeline pipeline;

    public DebugHelper(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void addTraceXML(String processId, String name, XMLStreamReader xsr) {
        ArrayList<NameValue> list = (ArrayList<NameValue>)this.traceXML.get(processId);
        if (list == null) {
            list = new ArrayList<NameValue>();
            this.traceXML.put(processId, list);
        }
        NameValue entry = new NameValue();
        entry.name = name;
        entry.value = xsr;
        list.add(entry);
    }

    public void takePipelineParamPreExecutionSnapshot(PipelineDefinition pd) {
        this.preExecutionProcessParams.put("debug.param.pre.pipeline", this.getPipelineParamSnapshot(pd));
    }

    public void takePipelineParamPostExecutionSnapshot(PipelineDefinition pd) {
        this.postExecutionProcessParams.put("debug.param.post.pipeline", this.getPipelineParamSnapshot(pd));
    }

    public void takeProcessParamPostExecutionSnapshot(String processId, PipelineContext pipelineContext) {
        this.postExecutionProcessParams.put(POST_EXECUTION_PARAM_SNAPSHOT + processId, this.getProcessParamSnapshot(processId, pipelineContext));
    }

    public void takeProcessParamPreExecutionSnapshot(String processId, PipelineContext pipelineContext) {
        this.preExecutionProcessParams.put(PRE_EXECUTION_PARAM_SNAPSHOT + processId, this.getProcessParamSnapshot(processId, pipelineContext));
    }

    public void setOutputOrigin(String processId, String outputLabel) {
        this.outputProducers.put(outputLabel, processId);
    }

    public void setProcessAsExecuted(String id) {
        this.executionOrder.add(id);
    }

    public void dumpProcessXML(ProcessInstance processInstance, XMLStreamWriter xsw) throws PipelineException {
        PipelineContext context = new PipelineContext(processInstance, this.pipeline);
        try {
            xsw.writeStartElement("process");
            xsw.writeAttribute("name", processInstance.getId());
            xsw.writeStartElement("params");
            Map preValues = (Map)this.preExecutionProcessParams.get(PRE_EXECUTION_PARAM_SNAPSHOT + processInstance.getId());
            Map postValues = (Map)this.postExecutionProcessParams.get(POST_EXECUTION_PARAM_SNAPSHOT + processInstance.getId());
            Enumeration enumeration = context.getParamNamesEnumeration();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                xsw.writeStartElement("param");
                xsw.writeAttribute("name", name);
                if (preValues != null) {
                    xsw.writeStartElement("runtimeValueBeforeExecution");
                    this.writeRuntimeValue(xsw, preValues, name);
                    xsw.writeEndElement();
                }
                if (postValues != null) {
                    xsw.writeStartElement("runtimeValueAfterExecution");
                    this.writeRuntimeValue(xsw, postValues, name);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeStartElement("inputs");
            enumeration = context.getInputNamesEnumeration();
            while (enumeration.hasMoreElements()) {
                String inputName = (String)enumeration.nextElement();
                String label = processInstance.getInputLabel(inputName);
                xsw.writeStartElement("input");
                xsw.writeAttribute("name", inputName);
                if (label != null) {
                    xsw.writeAttribute("label", label);
                    String originProcess = (String)this.outputProducers.get(label);
                    if (originProcess != null) {
                        xsw.writeAttribute("originProcess", originProcess);
                    }
                }
                xsw.writeStartElement("runtimeValue");
                XMLStreamReader xsr = context.getInputAsXMLStreamReader(inputName);
                if (xsr != null) {
                    try {
                        StringWriter tempWriter = new StringWriter();
                        StaxUtils.copyCurrentElement(xsr, XMLStreamFactory.createXMLStreamWriter(tempWriter));
                        StaxUtils.copyCurrentElement(XMLStreamFactory.createXMLStreamReader(new StringReader(tempWriter.getBuffer().toString())), xsw);
                    }
                    catch (Exception e) {
                        Reader reader = context.getInputAsReader(inputName);
                        if (reader != null) {
                            int read;
                            char[] buffer = new char[1024];
                            while ((read = reader.read(buffer)) != -1) {
                                xsw.writeCharacters(buffer, 0, read);
                            }
                        }
                        xsw.writeAttribute("null", "");
                    }
                } else {
                    Reader reader = context.getInputAsReader(inputName);
                    if (reader != null) {
                        int read;
                        char[] buffer = new char[1024];
                        while ((read = reader.read(buffer)) != -1) {
                            xsw.writeCharacters(buffer, 0, read);
                        }
                    } else {
                        xsw.writeAttribute("null", "");
                    }
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            ArrayList processDebugXML = (ArrayList)this.traceXML.get(processInstance.getId());
            if (processDebugXML != null) {
                for (NameValue entry : processDebugXML) {
                    String name = entry.name;
                    XMLStreamReader extraXMLReader = (XMLStreamReader)entry.value;
                    if (extraXMLReader == null) continue;
                    xsw.writeStartElement("trace");
                    xsw.writeAttribute("name", name);
                    StaxUtils.copyCurrentElement(extraXMLReader, xsw);
                    xsw.writeEndElement();
                }
            }
            xsw.writeStartElement("outputs");
            Enumeration enumeration2 = context.getOutputNamesEnumeration();
            while (enumeration2.hasMoreElements()) {
                String outputName = (String)enumeration2.nextElement();
                String label = processInstance.getOutputLabel(outputName);
                xsw.writeStartElement("output");
                xsw.writeAttribute("name", outputName);
                if (label != null) {
                    xsw.writeAttribute("label", label);
                }
                xsw.writeStartElement("runtimeValue");
                IPipelineOutput out = this.pipeline.getOutput(label);
                if (out != null) {
                    XMLStreamReader xsr;
                    OutputDetails details = out.getOutputDetails();
                    if (details != null) {
                        String etag;
                        xsw.writeStartElement(TAG_OUTPUTDETAILS);
                        xsw.writeAttribute(ATTR_AS_DOCUMENT_ATTACHMENT, Boolean.toString(details.asDocumentAttachment()));
                        if (details.getContentType() != null) {
                            xsw.writeAttribute(ATTR_CONTENT_TYPE, details.getContentType());
                        }
                        if (details.getEncoding() != null) {
                            xsw.writeAttribute(ATTR_ENCODING, details.getEncoding());
                        }
                        if ((etag = details.getETag()) != null) {
                            xsw.writeAttribute(ATTR_ETAG, etag);
                        }
                        xsw.writeAttribute(ATTR_STATUS_CODE, Integer.toString(details.getStatusCode()));
                        xsw.writeEndElement();
                    }
                    if ((xsr = out.toXMLStreamReader()) != null) {
                        try {
                            StringWriter tempWriter = new StringWriter();
                            StaxUtils.copyCurrentElement(xsr, XMLStreamFactory.createXMLStreamWriter(tempWriter));
                            StaxUtils.copyCurrentElement(XMLStreamFactory.createXMLStreamReader(new StringReader(tempWriter.getBuffer().toString())), xsw);
                        }
                        catch (Exception e) {
                            Reader reader = out.toReader();
                            if (reader != null) {
                                int read;
                                char[] buffer = new char[1024];
                                while ((read = reader.read(buffer)) != -1) {
                                    xsw.writeCharacters(buffer, 0, read);
                                }
                            }
                            xsw.writeAttribute("null", "");
                        }
                    } else {
                        Reader reader = out.toReader();
                        if (reader != null) {
                            int read;
                            char[] buffer = new char[1024];
                            while ((read = reader.read(buffer)) != -1) {
                                xsw.writeCharacters(buffer, 0, read);
                            }
                        } else {
                            xsw.writeAttribute("null", "");
                        }
                    }
                } else {
                    xsw.writeAttribute("null", "");
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PipelineException("could not write process instance information", e);
        }
        catch (IOException e) {
            throw new PipelineException("could not write process instance information", e);
        }
    }

    private void writeRuntimeValue(XMLStreamWriter xsw, Map values, String name) throws XMLStreamException, PipelineException {
        NameValue value = (NameValue)values.get(name);
        if (value != null) {
            xsw.writeAttribute("class", value.name);
            if (value.value instanceof IPipelineOutput) {
                StaxUtils.copyCurrentElement(((IPipelineOutput)value.value).toXMLStreamReader(), xsw);
            } else {
                xsw.writeCharacters(value.value.toString());
            }
        } else {
            xsw.writeAttribute("null", "");
        }
    }

    public IPipelineOutput getPipelineDebugOutput(PipelineDefinition pd, ServiceLogger logger) throws PipelineException {
        IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
        XMLStreamWriter xsw = output.getXMLStreamWriter();
        try {
            xsw.writeStartElement("pipeline");
            xsw.writeStartElement("info");
            xsw.writeStartElement("target");
            String extra = (String)this.pipeline.getParam("extraInfo");
            String target = pd.getBasePath();
            if (extra != null) {
                target = target + extra;
            }
            xsw.writeCharacters(target);
            xsw.writeEndElement();
            xsw.writeStartElement("class");
            xsw.writeCharacters(pd.getClass().getName());
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("busHeader");
            StaxUtils.copyCurrentElement(XMLStreamFactory.createXMLStreamReader(new StringReader(this.pipeline.getEnv().getBusHeader())), xsw);
            xsw.writeEndElement();
            xsw.writeStartElement("params");
            Map preValues = (Map)this.preExecutionProcessParams.get("debug.param.pre.pipeline");
            Map postValues = (Map)this.postExecutionProcessParams.get("debug.param.post.pipeline");
            Enumeration enumeration = pd.getParamNamesEnumeration();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = pd.getParam(name);
                xsw.writeStartElement("param");
                xsw.writeAttribute("name", name);
                if (value != null) {
                    xsw.writeAttribute("select", value);
                }
                if (preValues != null) {
                    xsw.writeStartElement("runtimeValueBeforeExecution");
                    this.writeRuntimeValue(xsw, preValues, name);
                    xsw.writeEndElement();
                }
                if (postValues != null) {
                    xsw.writeStartElement("runtimeValueAfterExecution");
                    this.writeRuntimeValue(xsw, postValues, name);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeStartElement("executionOrder");
            for (int i = 0; i < this.executionOrder.size(); ++i) {
                if (i > 0) {
                    xsw.writeCharacters(", ");
                }
                xsw.writeCharacters((String)this.executionOrder.get(i));
            }
            xsw.writeEndElement();
            xsw.writeStartElement("processes");
            pd.dumpProcessXML(this.pipeline, xsw);
            xsw.writeEndElement();
            xsw.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new PipelineException("could not write process instance information", e);
        }
        try {
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new PipelineException("Could not write debug output");
        }
        if (this.pipeline.getRuntimeTrace().getDebugCommand().equals("record")) {
            this.writePipelineOutput(pd, output, logger);
            return null;
        }
        return output;
    }

    private Map getProcessParamSnapshot(String processId, PipelineContext pipelineContext) {
        HashMap<String, NameValue> paramValues = new HashMap<String, NameValue>();
        Enumeration enumeration = pipelineContext.getParamNamesEnumeration();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object param = pipelineContext.getParam(name);
            NameValue value = null;
            if (param != null) {
                value = this.creatParamSnapShot(param);
            }
            paramValues.put(name, value);
        }
        return paramValues;
    }

    private NameValue creatParamSnapShot(Object obj) {
        Object value;
        if (obj instanceof IXMLSerializable) {
            try {
                IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
                ((IXMLSerializable)obj).write(output.getXMLStreamWriter());
                value = output;
            }
            catch (Exception e) {
                value = obj.toString();
            }
        } else {
            value = obj.toString();
        }
        NameValue snapShop = new NameValue();
        snapShop.name = obj.getClass().getName();
        snapShop.value = value;
        return snapShop;
    }

    private Map getPipelineParamSnapshot(PipelineDefinition pd) {
        HashMap<String, NameValue> paramValues = new HashMap<String, NameValue>();
        Enumeration enumeration = pd.getParamNamesEnumeration();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object param = this.pipeline.getParam(name);
            NameValue value = null;
            if (param != null) {
                value = this.creatParamSnapShot(param);
            }
            paramValues.put(name, value);
        }
        return paramValues;
    }

    public synchronized void writePipelineOutput(PipelineDefinition pd, IPipelineOutput output, ServiceLogger logger) throws PipelineException {
        StringBuffer buffer;
        String directory;
        block4: {
            directory = (String)this.pipeline.getEnv().getProperty("record.pipeline.location");
            if (directory == null) {
                if (logger != null && logger.isErrorEnabled()) {
                    logger.error("Record Pipeline Location is not set.");
                }
                return;
            }
            buffer = new StringBuffer();
            try {
                StaxUtils.toString(output.toXMLStreamReader(), buffer);
            }
            catch (XMLStreamException e) {
                if (logger == null || !logger.isErrorEnabled()) break block4;
                logger.error("XMLStreamException while converting pipeline output", e);
            }
        }
        recordingHelper.writeToFile(buffer.toString(), RecordingHelper.getCompleteDirectory(logger, directory, this.pipeline.getEnv().getBusHeader()), pd.getBasePath().replace('/', '_') + ".xml", logger);
    }

    public List getExecutionOrder() {
        return this.executionOrder;
    }

    class NameValue {
        private String name;
        private Object value;

        NameValue() {
        }
    }
}

