/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.xml.pipeline.IPipelineProvider;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.PipelineFactoryImpl;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DefaultPipelineProvider
implements IPipelineProvider {
    private static final String DEFAULT_FACTORY_BASE = "com/cognos/portal/pipelinespecs";

    @Override
    public PipelineDefinition createPipelineDefinition(String path, Environment env, ServiceLogger logger) throws PipelineException {
        String fullPath = DEFAULT_FACTORY_BASE + path + ".xml";
        InputStream in = PipelineFactoryImpl.class.getClassLoader().getResourceAsStream(fullPath);
        if (in != null) {
            try {
                XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                PipelineDefinition def = new PipelineDefinition(logger);
                def.initialize(xsr, env);
                return def;
            }
            catch (XMLStreamException e) {
                throw new PipelineException("could read implementati on file for path '" + path + "'");
            }
        }
        return null;
    }

    @Override
    public void configurePipeline(Pipeline pipeline, Environment env) throws PipelineException {
    }
}

