/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.RuntimeTrace;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pipeline {
    Map params;
    Map outputMap;
    List executedProcesses;
    RuntimeTrace runtimeTrace;
    private PipelineDefinition pipelineDefintion;
    private Environment env;
    private ServiceLogger logger;

    public Pipeline(PipelineDefinition pipelineDefinition, Environment env, ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(Pipeline.class) : null;
        this.params = new HashMap();
        this.outputMap = new HashMap();
        this.executedProcesses = new ArrayList();
        this.pipelineDefintion = pipelineDefinition;
        this.env = env;
    }

    public boolean acceptsParam(String name) {
        return this.pipelineDefintion.acceptsParam(name);
    }

    public void setParam(String name, Object value) {
        if (this.acceptsParam(name)) {
            this.params.put(name, value);
        }
    }

    public Object getParam(String name) {
        if (this.params.containsKey(name)) {
            return this.params.get(name);
        }
        String param = this.pipelineDefintion.getParam(name);
        if (param != null) {
            if (param.length() > 1 && param.startsWith("'") && param.endsWith("'")) {
                return param.substring(1, param.length() - 1);
            }
            throw new RuntimeException("Invalid param value '" + param + "' for parameters '" + name + "'");
        }
        return null;
    }

    public void addOutput(String name, IPipelineOutput output) {
        this.outputMap.put(name, output);
    }

    public IPipelineOutput getOutput(String name) {
        return (IPipelineOutput)this.outputMap.get(name);
    }

    public IPipelineOutput execute() throws PipelineException {
        Object executePipelineTimer = null;
        if (this.logger.isPerfLevelEnabled(2)) {
            executePipelineTimer = this.logger.startTimer(2, "execute", this.pipelineDefintion.getBasePath(), null);
        }
        String output = this.pipelineDefintion.executePipeline(this);
        if (executePipelineTimer != null) {
            this.logger.stopTimer(executePipelineTimer);
        }
        return this.getOutput(output);
    }

    public boolean hasOutput(String outputLabel) {
        return this.outputMap.containsKey(outputLabel);
    }

    public Environment getEnv() {
        return this.env;
    }

    public void markProcessPending(String id, boolean isPending) {
        if (isPending) {
            this.executedProcesses.add(id);
        } else {
            this.executedProcesses.remove(id);
        }
    }

    public boolean isProcessPending(String id) {
        return this.executedProcesses.contains(id);
    }

    public RuntimeTrace getRuntimeTrace() {
        if (this.runtimeTrace == null) {
            this.runtimeTrace = this.pipelineDefintion.createRuntimeTrace(this);
        }
        return this.runtimeTrace;
    }
}

