/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.fragment.Environment;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.ProcessInstance;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import javax.xml.stream.XMLStreamReader;

public class PipelineContext {
    private Pipeline pipeline;
    private ProcessInstance processInstance;

    public PipelineContext(ProcessInstance processInstance, Pipeline pipeline) {
        this.processInstance = processInstance;
        this.pipeline = pipeline;
    }

    public boolean canOutput(String name) {
        return this.processInstance.getOutputLabel(name) != null;
    }

    public boolean isOutputAvailable(String outputName) {
        String label = this.processInstance.getOutputLabel(outputName);
        if (label != null) {
            return this.pipeline.getOutput(label) != null;
        }
        return false;
    }

    public void forwardInputAsOutput(String inputName, String outputName) {
        IPipelineOutput output = this.getAvailableOutput(inputName);
        if (output != null) {
            this.addOutput(inputName, output);
        }
    }

    public void addOutput(String name, IPipelineOutput output) {
        String label = this.processInstance.getOutputLabel(name);
        if (label != null) {
            this.pipeline.addOutput(label, output);
            if (this.pipeline.getRuntimeTrace().isDebugMode()) {
                this.pipeline.getRuntimeTrace().getDebugHelper().setOutputOrigin(this.processInstance.getId(), label);
            }
        }
    }

    protected IPipelineOutput getAvailableOutput(String name) {
        String label;
        IPipelineOutput output = this.processInstance.getInlineOutput(name);
        if (output == null && (label = this.processInstance.getInputLabel(name)) != null) {
            output = this.pipeline.getOutput(label);
        }
        return output;
    }

    public Reader getInputAsReader(String name) throws PipelineException {
        IPipelineOutput output = this.getAvailableOutput(name);
        if (output != null) {
            return output.toReader();
        }
        return null;
    }

    public InputStream getInputAsStream(String name) throws PipelineException {
        IPipelineOutput output = this.getAvailableOutput(name);
        if (output != null) {
            return output.toInputStream();
        }
        return null;
    }

    public XMLStreamReader getInputAsXMLStreamReader(String name) throws PipelineException {
        IPipelineOutput output = this.getAvailableOutput(name);
        if (output != null) {
            return output.toXMLStreamReader();
        }
        return null;
    }

    public Object getParam(String name) {
        String param = this.processInstance.getParamValue(name);
        if (param != null) {
            if (param.startsWith("$")) {
                return this.pipeline.getParam(param.substring(1));
            }
            if (param.length() > 1 && param.startsWith("'") && param.endsWith("'")) {
                param = param.substring(1, param.length() - 1);
            } else {
                throw new RuntimeException("Invalid param value '" + param + "' for parameters '" + name + "'");
            }
        }
        return param;
    }

    public Enumeration getParamNamesEnumeration() {
        return this.processInstance.getParamNamesEnumeration();
    }

    public Enumeration getInputNamesEnumeration() {
        return this.processInstance.getInputNamesEnumeration();
    }

    public Enumeration getOutputNamesEnumeration() {
        return this.processInstance.getOutputNamesEnumeration();
    }

    public Environment getEnv() {
        return this.pipeline.getEnv();
    }

    public boolean isDebugMode() {
        return this.pipeline.getRuntimeTrace().isDebugMode();
    }

    public void addTraceXML(String name, XMLStreamReader xsr) {
        if (this.isDebugMode()) {
            this.pipeline.getRuntimeTrace().getDebugHelper().addTraceXML(this.processInstance.getId(), name, xsr);
        }
    }
}

