/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.pogo.isolation.ParanoidClassLoader;
import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.ErrorWrapper;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.xml.pipeline.DebugHelper;
import com.cognos.portal.xml.pipeline.IProcess;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineCompileError;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.ProcessInstance;
import com.cognos.portal.xml.pipeline.RuntimeTrace;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PipelineDefinition {
    private static Cache globalProcessCache = new Cache(0L, 0L, 0);
    private static ClassLoader pipelineClassLoader = null;
    private String basePath;
    private Map processDefMap = new HashMap();
    private Map outputProcesses = new HashMap();
    private Map params = new HashMap();
    private List processInstanceList = new ArrayList();
    private ServiceLogger logger;

    public PipelineDefinition(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(PipelineDefinition.class) : null;
    }

    private void setupClassLoader(Environment env) {
        if ("true".equals(env.getProperty("producer.debug"))) {
            String stageDir = (String)env.getProperty("producer.debug.stages.dir");
            try {
                pipelineClassLoader = new ParanoidClassLoader(new URL[]{new URL("file:" + stageDir)}, PipelineDefinition.class.getClassLoader());
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pipelineClassLoader = PipelineDefinition.class.getClassLoader();
    }

    private void resetClassLoader(Environment env) {
        pipelineClassLoader = null;
        globalProcessCache.clear();
        this.setupClassLoader(env);
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getParam(String name) {
        return (String)this.params.get(name);
    }

    public Enumeration getParamNamesEnumeration() {
        return new Enumeration(){
            Iterator it;
            {
                this.it = PipelineDefinition.this.params.entrySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                Map.Entry entry = (Map.Entry)this.it.next();
                return entry.getKey();
            }
        };
    }

    public boolean acceptsParam(String name) {
        return this.params.containsKey(name);
    }

    public void initialize(XMLStreamReader reader, Environment env) throws PipelineException {
        this.readPipeline(reader, env);
    }

    private void readProcess(XMLStreamReader reader, Environment env) throws PipelineException {
        int level = 0;
        try {
            ProcessInstance processInstance = null;
            boolean isInput = false;
            String inputName = null;
            String inputLabel = null;
            IPipelineOutput inline = null;
            int event = reader.getEventType();
            while (true) {
                switch (event) {
                    case 1: {
                        if (isInput) {
                            inline = PipelineOutputFactory.getInstance().createOutput();
                            XMLStreamWriter xsw = inline.getXMLStreamWriter();
                            StaxUtils.copyCurrentElement(reader, xsw);
                            xsw.flush();
                            xsw.close();
                            break;
                        }
                        if ("process".equals(reader.getLocalName())) {
                            String id = reader.getAttributeValue("", "id");
                            this.checkProcessSyntaxError("id", id, "process", "");
                            String type = reader.getAttributeValue("", "type");
                            this.checkProcessSyntaxError("type", type, "process", id);
                            IProcess process = this.createClassInstance(type, id);
                            if (process != null) {
                                processInstance = new ProcessInstance(id, process, this, this.logger);
                                this.processInstanceList.add(processInstance);
                            }
                        } else if (processInstance != null) {
                            String name;
                            if ("input".equals(reader.getLocalName())) {
                                isInput = true;
                                inputName = reader.getAttributeValue("", "name");
                                inputLabel = reader.getAttributeValue("", "label");
                            } else if ("output".equals(reader.getLocalName())) {
                                name = reader.getAttributeValue("", "name");
                                String label = reader.getAttributeValue("", "label");
                                this.checkProcessSyntaxError("label", label, "output", processInstance.getId());
                                processInstance.addOutput(name, label);
                                if (this.outputProcesses.containsKey(label)) {
                                    ProcessInstance pi = (ProcessInstance)this.outputProcesses.get(label);
                                    throw new PipelineException("process '" + processInstance.getId() + "' cannot use output label '" + label + "'. This label is already in use by process '" + pi.getId() + "'");
                                }
                                this.outputProcesses.put(label, processInstance);
                            } else if ("param".equals(reader.getLocalName())) {
                                name = reader.getAttributeValue("", "name");
                                String value = reader.getAttributeValue("", "select");
                                if (processInstance != null) {
                                    this.checkProcessSyntaxError("name", name, "param", processInstance.getId());
                                    processInstance.addParameter(name, value);
                                }
                            } else if ("error".equals(reader.getLocalName())) {
                                String label = reader.getAttributeValue("", "label");
                                if (processInstance != null) {
                                    processInstance.setErrorOutputLabel(label);
                                }
                            }
                        }
                        ++level;
                        break;
                    }
                    case 2: {
                        if ("input".equals(reader.getLocalName())) {
                            if (inline != null) {
                                processInstance.addInlineOutput(inputName, inline);
                            } else {
                                this.checkProcessSyntaxError("label", inputLabel, "input", processInstance.getId());
                                processInstance.addInput(inputName, inputLabel);
                            }
                            isInput = false;
                            inline = null;
                        }
                        --level;
                        break;
                    }
                    case 7: {
                        ++level;
                        break;
                    }
                    case 8: {
                        --level;
                    }
                }
                if (reader.hasNext() && level > 0) {
                    event = reader.next();
                    continue;
                }
                break;
            }
        }
        catch (RuntimeException e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("failed creating pipeline process", e);
            }
            StringBuffer msg = new StringBuffer();
            msg.append(" Failed creating pipeline process. ");
            msg.append(e.getMessage());
            throw new PipelineException(msg.toString(), e);
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("failed creating process", e);
            }
            throw new PipelineException("Failed creating process ", e);
        }
    }

    private void checkProcessSyntaxError(String requiredAttributeName, String requiredAttributeValue, String elementName, String processId) throws PipelineException {
        if (requiredAttributeValue == null || requiredAttributeValue.length() == 0) {
            String error = "Missing '" + requiredAttributeName + "' attribute for '" + elementName + "' element. Process: " + processId;
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("Missing '" + requiredAttributeName + "' attribute for '" + elementName + "' element. Process: " + processId);
            }
            throw new PipelineException("Pipline bad syntax: " + error);
        }
    }

    protected void readPipeline(XMLStreamReader reader, Environment env) throws PipelineException {
        if (pipelineClassLoader == null) {
            this.setupClassLoader(env);
        } else if ("restart".equals(env.getParameter("frag-debug"))) {
            this.resetClassLoader(env);
        }
        int level = 0;
        try {
            int event = reader.getEventType();
            while (true) {
                switch (event) {
                    case 1: {
                        if ("processdef".equals(reader.getLocalName())) {
                            String definition = reader.getAttributeValue("", "definition");
                            if (definition != null && definition.length() > 0) {
                                String name = reader.getAttributeValue("", "name");
                                this.processDefMap.put(name, definition);
                            }
                        } else {
                            if ("process".equals(reader.getLocalName())) {
                                this.readProcess(reader, env);
                                break;
                            }
                            if ("param".equals(reader.getLocalName())) {
                                String name = reader.getAttributeValue("", "name");
                                String value = reader.getAttributeValue("", "select");
                                this.params.put(name, value);
                            }
                        }
                        ++level;
                        break;
                    }
                    case 2: {
                        --level;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 7: {
                        ++level;
                        break;
                    }
                    case 8: {
                        --level;
                    }
                }
                if (!reader.hasNext() || level <= 0) break;
                event = reader.next();
            }
            this.resolveDependencies(env);
        }
        catch (PipelineException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("failed creating pipeline", e);
            }
            throw new PipelineException("Failed creating pipeline ", e);
        }
    }

    private void resolveDependencies(Environment env) throws PipelineException {
        for (ProcessInstance pd : this.processInstanceList) {
            pd.init();
            pd.resolveDependencies(env, this.logger);
        }
    }

    public String executePipeline(Pipeline pipeline) throws PipelineException {
        String outputId;
        block9: {
            String target = (String)pipeline.getParam("target");
            if (target == null || target.length() == 0) {
                throw new PipelineException("The pipeline target is not defined");
            }
            ProcessInstance processInstance = this.getProcessInstanceForOutput(target);
            if (processInstance == null) {
                throw new PipelineException("Cannot find process that produces output '" + target + "'");
            }
            outputId = target;
            try {
                if (pipeline.getRuntimeTrace().isDebugMode()) {
                    pipeline.getRuntimeTrace().getDebugHelper().takePipelineParamPreExecutionSnapshot(this);
                }
                processInstance.process(pipeline);
                if (pipeline.getRuntimeTrace().isDebugMode()) {
                    pipeline.getRuntimeTrace().getDebugHelper().takePipelineParamPostExecutionSnapshot(this);
                }
            }
            catch (Throwable e) {
                ProcessInstance errorProcess;
                String errorOutput;
                boolean errorProcessed = false;
                ProcessInstance errorOriginProcess = pipeline.getRuntimeTrace().getErrorOriginProcess();
                if (errorOriginProcess != null && (errorOutput = errorOriginProcess.getErrorOutputLabel()) != null && (errorProcess = this.getProcessInstanceForOutput(errorOutput)) != null) {
                    pipeline.setParam("error", new ErrorWrapper(e, errorOriginProcess.getId()));
                    errorProcess.process(pipeline);
                    outputId = errorOutput;
                    errorProcessed = true;
                }
                if (errorProcessed) break block9;
                if (e instanceof PipelineException) {
                    throw (PipelineException)e;
                }
                throw new PipelineException("unexcpected error while executing xml pipeline", e);
            }
        }
        if (pipeline.getRuntimeTrace().isDebugMode()) {
            outputId = pipeline.getRuntimeTrace().updateOutputForDebug(outputId);
        }
        return outputId;
    }

    private ProcessInstance getProcessInstance(String id) {
        for (int index = 0; index < this.processInstanceList.size(); ++index) {
            ProcessInstance pi = (ProcessInstance)this.processInstanceList.get(index);
            if (!pi.getId().equals(id)) continue;
            return pi;
        }
        return null;
    }

    public void dumpProcessXML(Pipeline pipeline, XMLStreamWriter xsw) throws PipelineException {
        DebugHelper aDebugHelper = pipeline.getRuntimeTrace().getDebugHelper();
        List executionOrder = aDebugHelper.getExecutionOrder();
        for (int index = 0; index < executionOrder.size(); ++index) {
            ProcessInstance pi = this.getProcessInstance((String)executionOrder.get(index));
            pipeline.getRuntimeTrace().getDebugHelper().dumpProcessXML(pi, xsw);
        }
    }

    public ProcessInstance getProcessInstanceForOutput(String outputLabel) {
        return (ProcessInstance)this.outputProcesses.get(outputLabel);
    }

    protected RuntimeTrace createRuntimeTrace(Pipeline pipeline) {
        return new RuntimeTrace(pipeline, this, this.logger);
    }

    protected boolean hasOutputProcess(String outputLabel) {
        return this.outputProcesses.get(outputLabel) != null;
    }

    private IProcess createClassInstance(String type, String id) {
        String className = (String)this.processDefMap.get(type);
        if (className == null) {
            return new PipelineCompileError(new Exception("Could not create an instance of process '" + type + "'. The type is not be defined."));
        }
        IProcess process = (IProcess)globalProcessCache.get(className);
        if (process != null) {
            return process;
        }
        try {
            Class<?> foundClass = pipelineClassLoader.loadClass(className);
            if (foundClass != null) {
                Object obj;
                Constructor<?>[] constructors = foundClass.getConstructors();
                int constructorIndex = -1;
                boolean hasLoggerConstructor = false;
                boolean hasDefaultConstructor = false;
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] paramTypes = constructors[i].getParameterTypes();
                    if (paramTypes.length == 1 && paramTypes[0] == ServiceLogger.class) {
                        hasLoggerConstructor = true;
                        constructorIndex = i;
                        continue;
                    }
                    if (paramTypes.length != 0) continue;
                    hasDefaultConstructor = true;
                    constructorIndex = i;
                }
                if (hasLoggerConstructor) {
                    Object obj2 = constructors[constructorIndex].newInstance(this.logger);
                    if (obj2 instanceof IProcess) {
                        process = (IProcess)obj2;
                    }
                } else if (hasDefaultConstructor && (obj = constructors[constructorIndex].newInstance(new Object[0])) instanceof IProcess) {
                    process = (IProcess)obj;
                }
                if (process != null) {
                    if (process.canShare()) {
                        process.setName(type);
                        process.initialize(new HashMap());
                        globalProcessCache.put(className, process);
                    } else {
                        process.setName(id);
                    }
                    return process;
                }
            }
        }
        catch (Throwable e) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("could not create class instance for class name: " + className, e);
            }
            return new PipelineCompileError(e);
        }
        return new PipelineCompileError(new Exception("Could not create an instance of process '" + type + "'. The process class is incompatible."));
    }
}

