/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.meta.NamedList;
import com.cognos.portal.fragment.producer.ProducerPipelineProvider;
import com.cognos.portal.utils.Cache;
import com.cognos.portal.utils.XMLString;
import com.cognos.portal.xml.pipeline.DefaultPipelineProvider;
import com.cognos.portal.xml.pipeline.IPipelineProvider;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.PipelineFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PipelineFactoryImpl
extends PipelineFactory {
    protected static String DEFAULT_FACTORY = "pipeline";
    private static String PRODUCER_FACTORY = "producer";
    private ServiceLogger logger;
    private Map providers = new HashMap();
    private Map pipelineDefinitionCache;

    public PipelineFactoryImpl(ServiceLogger logger) {
        this.logger = logger != null ? logger.cloneForClass(PipelineFactoryImpl.class) : null;
    }

    @Override
    public void initialize() {
        this.pipelineDefinitionCache = new Cache(0L, 0L, 100);
        this.providers = new HashMap();
        this.registerProvider(DEFAULT_FACTORY, new DefaultPipelineProvider());
        this.registerProvider(PRODUCER_FACTORY, new ProducerPipelineProvider());
    }

    @Override
    public void terminate() {
    }

    private IPipelineProvider getProvider(String target) {
        IPipelineProvider provider;
        int index = target.indexOf("://");
        if (index != -1) {
            target = target.substring(0, index);
        }
        if ((provider = (IPipelineProvider)this.providers.get(target)) == null) {
            provider = (IPipelineProvider)this.providers.get(DEFAULT_FACTORY);
        }
        return provider;
    }

    @Override
    public void registerProvider(String name, IPipelineProvider provider) {
        this.providers.put(name, provider);
    }

    private final String removeProtocol(String target) {
        int index = target.indexOf("://");
        if (index != -1) {
            target = target.substring(index + 2);
        }
        return target;
    }

    private final List getPath(String target) {
        ArrayList<String> paths = new ArrayList<String>();
        if (target.length() > 0) {
            int index = target.indexOf(47, 1);
            while (index != -1) {
                paths.add(target.substring(0, index));
                index = target.indexOf(47, index + 1);
            }
            paths.add(target);
        }
        return paths;
    }

    private void configurePipeline(Pipeline pipeline, Environment env) throws PipelineException {
        if (pipeline.acceptsParam("requestCookies")) {
            NamedList cookies = new NamedList("cookies");
            env.createCookieList(cookies);
            pipeline.setParam("requestCookies", cookies);
        }
        if (pipeline.acceptsParam("busHeader")) {
            pipeline.setParam("busHeader", new XMLString(env.getBusHeader()));
        }
        if (pipeline.acceptsParam("passport")) {
            pipeline.setParam("passport", env.getPassportID());
        }
    }

    @Override
    public final Pipeline createPipeline(String target, Environment env) throws PipelineException {
        Object createPipelineTimer = null;
        if (this.logger.isPerfLevelEnabled(4)) {
            createPipelineTimer = this.logger.startTimer(4, "createPipeline", target, null);
        }
        IPipelineProvider provider = this.getProvider(target);
        target = this.removeProtocol(target);
        CacheKey key = new CacheKey(target, provider.getClass().getName());
        PipelineDefinition def = (PipelineDefinition)this.pipelineDefinitionCache.get(key);
        String path2 = null;
        if (def == null) {
            List paths = this.getPath(target);
            for (String path2 : paths) {
                def = provider.createPipelineDefinition(path2, env, this.logger);
                if (def == null) continue;
                def.setBasePath(path2);
                break;
            }
            if (def == null) {
                throw new PipelineException("could not find implementation for path '" + target + "'");
            }
            this.pipelineDefinitionCache.put(new CacheKey(path2, provider.getClass().getName()), def);
        }
        Pipeline p = new Pipeline(def, env, this.logger);
        if ("true".equals(env.getProperty("record.pipeline"))) {
            p.getRuntimeTrace().setDebugMode("record");
        }
        if (path2 == null) {
            path2 = def.getBasePath();
        }
        String extraInfo = target.substring(path2.length());
        p.setParam("extraInfo", extraInfo);
        this.configurePipeline(p, env);
        provider.configurePipeline(p, env);
        if (createPipelineTimer != null) {
            this.logger.stopTimer(createPipelineTimer);
        }
        return p;
    }

    class CacheKey {
        private String id;
        private String path;

        public CacheKey(String path, String id) {
            this.path = path;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey c = (CacheKey)obj;
                return this.id.equals(c.id) && (this.path.equals(c.path) || this.path.startsWith(c.path + "/") || c.path.startsWith(this.path + "/"));
            }
            return false;
        }

        public int hashCode() {
            int index;
            String firstToken = null;
            if (this.path.length() > 0 && (index = this.path.indexOf(47, 1)) != -1) {
                firstToken = this.path.substring(0, index);
            }
            if (firstToken == null) {
                firstToken = this.path;
            }
            return firstToken.hashCode();
        }
    }
}

