/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.fragment.server.DashboardException;
import com.cognos.portal.soap.SOAPConnectionProperties;
import com.cognos.portal.utils.Parameters;
import com.cognos.portal.utils.ThreadLocalPropertyManager;
import com.cognos.portal.xml.pipeline.IProcess;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineContext;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.PipelineOutputFactory;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ProcessInstance {
    private IProcess process;
    private List dependencies;
    private Map params;
    private Map inlineOutputs;
    private Map inputLabels;
    private Map outputLabels;
    private String id;
    private String errorOutput;
    private PipelineDefinition pipelineDefinition;
    private ServiceLogger logger;

    public ProcessInstance(String id, IProcess process, PipelineDefinition pipelineDefinition, ServiceLogger logger) {
        if (id == null) {
            throw new NullPointerException("the id must not be null");
        }
        this.logger = logger != null ? logger.cloneForClass(ProcessInstance.class) : null;
        this.pipelineDefinition = pipelineDefinition;
        this.process = process;
        this.id = id;
        this.dependencies = new ArrayList();
        this.params = new HashMap();
        this.inputLabels = new LinkedHashMap();
        this.outputLabels = new LinkedHashMap();
        this.inlineOutputs = new HashMap();
    }

    public void init() throws PipelineException {
        HashMap inlineInputs = new HashMap();
        for (Map.Entry entry : this.inlineOutputs.entrySet()) {
            inlineInputs.put(entry.getKey(), ((IPipelineOutput)entry.getValue()).toXMLStreamReader());
        }
        if (!this.process.canShare()) {
            this.process.initialize(inlineInputs);
        }
    }

    public String getId() {
        return this.id;
    }

    public void addParameter(String name, String value) {
        this.params.put(name, value);
    }

    public void addInput(String name, String label) {
        if (name == null || name.length() == 0) {
            name = label;
        }
        this.inputLabels.put(name, label);
    }

    public void addOutput(String name, String label) {
        if (name == null || name.length() == 0) {
            name = label;
        }
        this.outputLabels.put(name, label);
    }

    public String getParamValue(String paramName) {
        return (String)this.params.get(paramName);
    }

    public Enumeration getParamNamesEnumeration() {
        return new Enumeration(){
            Iterator it;
            {
                this.it = ProcessInstance.this.params.entrySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                Map.Entry entry = (Map.Entry)this.it.next();
                return entry.getKey();
            }
        };
    }

    public String getInputLabel(String inputName) {
        return (String)this.inputLabels.get(inputName);
    }

    public Enumeration getInputNamesEnumeration() {
        return new Enumeration(){
            Iterator it;
            boolean hasMore;
            {
                this.it = ProcessInstance.this.inputLabels.entrySet().iterator();
                this.hasMore = true;
            }

            @Override
            public boolean hasMoreElements() {
                boolean hasNext = this.it.hasNext();
                if (!hasNext && this.hasMore) {
                    this.it = ProcessInstance.this.inlineOutputs.entrySet().iterator();
                    this.hasMore = false;
                    hasNext = this.it.hasNext();
                }
                return hasNext;
            }

            public Object nextElement() {
                Map.Entry entry = (Map.Entry)this.it.next();
                return entry.getKey();
            }
        };
    }

    public String getOutputLabel(String outputName) {
        return (String)this.outputLabels.get(outputName);
    }

    public Enumeration getOutputNamesEnumeration() {
        return new Enumeration(){
            Iterator it;
            {
                this.it = ProcessInstance.this.outputLabels.entrySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                Map.Entry entry = (Map.Entry)this.it.next();
                return entry.getKey();
            }
        };
    }

    public IPipelineOutput getInlineOutput(String name) {
        return (IPipelineOutput)this.inlineOutputs.get(name);
    }

    public void process(Pipeline pipeline) throws PipelineException {
        if (pipeline.isProcessPending(this.getId())) {
            throw new PipelineException("Circular dependency detected for process id=" + this.getId());
        }
        pipeline.markProcessPending(this.getId(), true);
        for (ProcessInstance processInstance : this.dependencies) {
            if (pipeline.getRuntimeTrace().isProcessExecuted(processInstance.getId())) continue;
            processInstance.process(pipeline);
        }
        pipeline.markProcessPending(this.getId(), false);
        this.processImpl(pipeline);
    }

    protected void processImpl(Pipeline pipeline) throws PipelineException {
        pipeline.getRuntimeTrace().markProcessAsExecuted(this.getId());
        PipelineContext pipelineContext = new PipelineContext(this, pipeline);
        try {
            if (pipeline.getRuntimeTrace().isDebugMode()) {
                ThreadLocalPropertyManager.set(SOAPConnectionProperties.PROP_PIPELINE_CONTEXT, pipelineContext);
                pipeline.getRuntimeTrace().getDebugHelper().takeProcessParamPreExecutionSnapshot(this.getId(), pipelineContext);
            }
            Object executeTimer = null;
            if (this.logger.isPerfLevelEnabled(3)) {
                executeTimer = this.logger.startTimer(3, "process", this.process.getClass().getName(), null);
            }
            this.process.execute(pipelineContext);
            if (executeTimer != null) {
                this.logger.stopTimer(executeTimer);
            }
            if (pipeline.getRuntimeTrace().isDebugMode()) {
                pipeline.getRuntimeTrace().getDebugHelper().takeProcessParamPostExecutionSnapshot(this.getId(), pipelineContext);
                ThreadLocalPropertyManager.set(SOAPConnectionProperties.PROP_PIPELINE_CONTEXT, null);
            }
        }
        catch (Throwable e) {
            pipeline.getRuntimeTrace().addErrorOriginProcess(this);
            if (e instanceof PipelineException) {
                throw (PipelineException)e;
            }
            throw new PipelineException("Unexpected exception while executing the xml pipeline process '" + this.getId() + "'", e);
        }
    }

    public void resolveDependencies(Environment env, ServiceLogger logger) throws PipelineException {
        Iterator it = this.inputLabels.values().iterator();
        while (it.hasNext()) {
            String inputLabel = (String)it.next();
            ProcessInstance processToDependOn = this.pipelineDefinition.getProcessInstanceForOutput(inputLabel);
            if (processToDependOn == null) {
                if (this.inlineOutputs.containsKey(inputLabel) || !inputLabel.endsWith(".xml")) continue;
                try {
                    InputStream in = env.getTargetStream(inputLabel, new Parameters());
                    XMLStreamReader xsr = XMLStreamFactory.createXMLStreamReader(in);
                    IPipelineOutput output = PipelineOutputFactory.getInstance().createOutput();
                    XMLStreamWriter xsw = output.getXMLStreamWriter();
                    StaxUtils.copyCurrentElement(xsr, xsw);
                    it.remove();
                    this.addInlineOutput(this.findInputName(inputLabel), output);
                }
                catch (DashboardException e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("encountered an error when processing a dashboard funciton", e);
                }
                catch (XMLStreamException e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("encountered an XML stream exception", e);
                }
                continue;
            }
            if (processToDependOn == this) {
                throw new PipelineException("input and output are for the same process: " + this.getId() + " - " + inputLabel);
            }
            this.dependencies.add(processToDependOn);
        }
    }

    private String findInputName(String inputLabel) {
        for (Map.Entry entry : this.inputLabels.entrySet()) {
            if (!inputLabel.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public void addInlineOutput(String inputName, IPipelineOutput output) {
        this.inlineOutputs.put(inputName, output);
    }

    public void setErrorOutputLabel(String label) {
        this.errorOutput = label;
    }

    public String getErrorOutputLabel() {
        return this.errorOutput;
    }
}

