/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline;

import com.cognos.portal.common.logging.ServiceLogger;
import com.cognos.portal.xml.pipeline.DebugHelper;
import com.cognos.portal.xml.pipeline.Pipeline;
import com.cognos.portal.xml.pipeline.PipelineDefinition;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.ProcessInstance;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class RuntimeTrace {
    private static final String XML_DUMP_OUTPUT_LABEL = "debug.xmldump";
    private List executedProcesses;
    private ProcessInstance errorOriginProcess;
    private String debugCommand;
    private DebugHelper debugHelper;
    private Pipeline pipeline;
    private PipelineDefinition pipelineDefinition;
    protected ServiceLogger logger;
    private boolean isDebugMode = false;
    static HashSet VALID_DEBUG_MODE = new HashSet();

    public RuntimeTrace(Pipeline pipeline, PipelineDefinition pipelineDefinition, ServiceLogger logger) {
        this.logger = logger;
        this.pipelineDefinition = pipelineDefinition;
        this.executedProcesses = new ArrayList();
        this.pipeline = pipeline;
    }

    public void markProcessAsExecuted(String id) {
        this.executedProcesses.add(id);
        if (this.isDebugMode()) {
            this.debugHelper.setProcessAsExecuted(id);
        }
    }

    public boolean isProcessExecuted(String id) {
        return this.executedProcesses.contains(id);
    }

    public void addErrorOriginProcess(ProcessInstance processInstance) {
        this.errorOriginProcess = processInstance;
    }

    public ProcessInstance getErrorOriginProcess() {
        return this.errorOriginProcess;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public String getDebugCommand() {
        return this.debugCommand;
    }

    public void setDebugMode(String debug) {
        this.debugCommand = debug;
        if (VALID_DEBUG_MODE.contains(this.debugCommand)) {
            this.enableDebugMode();
        } else {
            this.isDebugMode = false;
        }
    }

    protected void enableDebugMode() {
        this.isDebugMode = true;
        if (this.debugHelper == null) {
            this.debugHelper = new DebugHelper(this.pipeline);
        }
    }

    public String updateOutputForDebug(String outputName) throws PipelineException {
        IPipelineOutput output;
        if (this.debugHelper != null && (output = this.debugHelper.getPipelineDebugOutput(this.pipelineDefinition, this.logger)) != null) {
            this.pipeline.addOutput(XML_DUMP_OUTPUT_LABEL, output);
            return XML_DUMP_OUTPUT_LABEL;
        }
        return outputName;
    }

    public DebugHelper getDebugHelper() {
        return this.debugHelper;
    }

    static {
        VALID_DEBUG_MODE.add("pipeline");
        VALID_DEBUG_MODE.add("record");
    }
}

