/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.pipeline.io;

import com.cognos.portal.utils.io.SharedByteArrayOutputStream;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.pipeline.io.IDelayedOutput;
import com.cognos.portal.xml.pipeline.io.IPipelineOutput;
import com.cognos.portal.xml.pipeline.io.OutputDetails;
import com.cognos.portal.xml.stream.StaxUtils;
import com.cognos.portal.xml.stream.XMLRecorderStreamWriter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PipelineOutputImpl
implements IPipelineOutput {
    private static final short OUTPUT_NONE = 0;
    private static final short OUTPUT_XML_STREAM_WRITER = 1;
    private static final short OUTPUT_WRITER = 2;
    private static final short OUTPUT_OUTPUT_STREAM = 3;
    private StringWriter writer;
    private SharedByteArrayOutputStream outputStream;
    private XMLRecorderStreamWriter xsw;
    private IDelayedOutput delayedOutput;
    private short outputMode = 0;
    private boolean isDelayedOutputExecuted;
    private OutputDetails details;

    private void executeDelayedOuputIfAvailable() {
        if (this.delayedOutput != null && !this.isDelayedOutputExecuted) {
            this.isDelayedOutputExecuted = true;
            this.delayedOutput.writeOutput(this);
        }
    }

    @Override
    public InputStream toInputStream() throws PipelineException {
        this.executeDelayedOuputIfAvailable();
        if (this.outputStream == null) {
            try {
                this.outputStream = this.createOutputStreamHelper();
                if (this.xsw != null) {
                    XMLStreamWriter xmlwriter = XMLStreamFactory.createXMLStreamWriter(this.outputStream);
                    StaxUtils.copyCurrentElement(this.toXMLStreamReader(), xmlwriter);
                    xmlwriter.flush();
                    xmlwriter.close();
                } else if (this.writer != null) {
                    this.outputStream.write(this.writer.getBuffer().toString().getBytes("UTF-8"));
                    this.outputStream.close();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new PipelineException("failed to create input stream ", e);
            }
            catch (IOException e) {
                throw new PipelineException("failed to create input stream ", e);
            }
            catch (XMLStreamException e) {
                throw new PipelineException("failed to create input stream ", e);
            }
        }
        if (this.outputStream != null) {
            return this.outputStream.toStream();
        }
        return null;
    }

    @Override
    public Reader toReader() throws PipelineException {
        this.executeDelayedOuputIfAvailable();
        if (this.writer == null) {
            if (this.xsw != null) {
                try {
                    this.writer = this.createWriterHelper();
                    XMLStreamWriter xmlwriter = XMLStreamFactory.createXMLStreamWriter(this.writer);
                    StaxUtils.copyCurrentElement(this.toXMLStreamReader(), xmlwriter);
                    this.writer.close();
                }
                catch (XMLStreamException e) {
                    throw new PipelineException("Cannot write to xml stream", e);
                }
                catch (IOException e) {
                    throw new PipelineException("Cannot close writer", e);
                }
            } else if (this.outputStream != null) {
                return new InputStreamReader(this.toInputStream());
            }
        }
        if (this.writer != null) {
            return new StringReader(this.writer.getBuffer().toString());
        }
        return null;
    }

    @Override
    public XMLStreamReader toXMLStreamReader() throws PipelineException {
        this.executeDelayedOuputIfAvailable();
        if (this.xsw == null) {
            if (this.writer != null) {
                try {
                    return XMLStreamFactory.createXMLStreamReader(this.toReader());
                }
                catch (XMLStreamException e) {
                    throw new PipelineException("failed to create xml stream reader", e);
                }
            }
            if (this.outputStream != null) {
                try {
                    return XMLStreamFactory.createXMLStreamReader(this.toInputStream());
                }
                catch (XMLStreamException e) {
                    throw new PipelineException("failed to create xml stream reader", e);
                }
            }
        }
        if (this.xsw != null) {
            return this.xsw.toXMLStreamReader();
        }
        return null;
    }

    @Override
    public XMLStreamWriter getXMLStreamWriter() throws PipelineException {
        if (this.outputMode == 0) {
            this.outputMode = 1;
            this.xsw = this.createXMLStreamWriterHelper();
        }
        if (this.outputMode != 1) {
            throw new PipelineException("Cannot create 'XMLStreamWriter' object. Another output was already created");
        }
        return this.xsw;
    }

    @Override
    public Writer getWriter() throws PipelineException {
        if (this.outputMode == 0) {
            this.outputMode = (short)2;
            this.writer = this.createWriterHelper();
        }
        if (this.outputMode != 2) {
            throw new PipelineException("Cannot create 'Writer' object. Another output was already created");
        }
        return this.writer;
    }

    @Override
    public OutputStream getOutputStream() throws PipelineException {
        if (this.outputMode == 0) {
            this.outputMode = (short)3;
            this.outputStream = this.createOutputStreamHelper();
        }
        if (this.outputMode != 3) {
            throw new PipelineException("Cannot create 'OutputStream' object. Another output was already created");
        }
        return this.outputStream;
    }

    @Override
    public void setDelayedOutput(IDelayedOutput delayedOutput) {
        this.delayedOutput = delayedOutput;
    }

    @Override
    public OutputDetails getOutputDetails() {
        return this.details;
    }

    @Override
    public void setOutputDetails(OutputDetails details) {
        this.details = details;
    }

    private SharedByteArrayOutputStream createOutputStreamHelper() {
        return new SharedByteArrayOutputStream(4096);
    }

    private StringWriter createWriterHelper() {
        return new StringWriter();
    }

    private XMLRecorderStreamWriter createXMLStreamWriterHelper() {
        return XMLStreamFactory.createXMLRecorderStreamWriter();
    }
}

