/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class CopyStreamFilter
implements StreamFilter {
    private XMLStreamWriter writer;
    boolean isError;

    public CopyStreamFilter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public boolean accept(XMLStreamReader reader) {
        try {
            int event = reader.getEventType();
            switch (event) {
                case 7: {
                    this.writer.writeStartDocument();
                    break;
                }
                case 8: {
                    this.writer.writeEndDocument();
                    this.writer.flush();
                    break;
                }
                case 1: {
                    String prefix = reader.getPrefix();
                    String namespace = reader.getNamespaceURI();
                    this.writer.writeStartElement(prefix, reader.getLocalName(), namespace);
                    int namspaceCount = reader.getNamespaceCount();
                    for (int i = 0; i < namspaceCount; ++i) {
                        String nsPrefix = reader.getNamespacePrefix(i);
                        String nsURI = reader.getNamespaceURI(i);
                        if (nsPrefix != null) {
                            this.writer.setPrefix(nsPrefix, nsURI);
                        }
                        this.writer.writeNamespace(nsPrefix, nsURI);
                    }
                    if (prefix != null && namespace != null && this.writer.getNamespaceContext().getNamespaceURI(prefix) == null) {
                        this.writer.setPrefix(prefix, namespace);
                        this.writer.writeNamespace(prefix, namespace);
                    }
                    int attrCount = reader.getAttributeCount();
                    for (int i = 0; i < attrCount; ++i) {
                        String attPrefix = reader.getAttributePrefix(i);
                        String attNamespace = reader.getAttributeNamespace(i);
                        if (attPrefix != null && this.writer.getNamespaceContext().getNamespaceURI(attPrefix) == null) {
                            this.writer.setPrefix(attPrefix, attNamespace);
                            this.writer.writeNamespace(attPrefix, attNamespace);
                        }
                        this.writer.writeAttribute(attPrefix, attNamespace, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    break;
                }
                case 2: {
                    this.writer.writeEndElement();
                    break;
                }
                case 4: {
                    this.writer.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    this.writer.writeCData(reader.getText());
                }
            }
        }
        catch (XMLStreamException e) {
            this.isError = true;
        }
        return true;
    }

    public boolean isError() {
        return this.isError;
    }
}

