/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.IResourceContext;
import com.cognos.portal.IUserContext;
import com.cognos.portal.fragment.Environment;
import com.cognos.portal.xml.i18n.LocalizationManager;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class LocalizedXMLStreamReader
extends StreamReaderDelegate {
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    private static QName XML_LANG = new QName("http://www.w3.org/XML/1998/namespace", "lang", "xml");
    private String currentResourceId;
    private String locale;
    private String messageFile;
    private Environment env;
    private boolean isTextCommited;
    private char[] tempChars;
    boolean isFakeTextEvent;
    private IResourceContext arc;
    private IUserContext auc;

    public LocalizedXMLStreamReader(XMLStreamReader reader, Environment env, String messageFile, String locale) {
        super(reader);
        this.locale = locale;
        this.messageFile = messageFile;
        this.env = env;
        final Environment aEnv = env;
        this.arc = new IResourceContext(){

            @Override
            public URL getResource(String path) throws MalformedURLException {
                return LocalizedXMLStreamReader.class.getClassLoader().getResource(path);
            }

            @Override
            public InputStream getResourceAsStream(String path) {
                try {
                    return aEnv.getTargetStream(path, null);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            @Override
            public String resolve(String uri) {
                return null;
            }

            @Override
            public Object getProperty(String name) {
                return null;
            }
        };
        this.auc = new IUserContext(){

            @Override
            public String getUserName() {
                return null;
            }

            @Override
            public String getProductLocale() {
                return aEnv.getProductLocale();
            }

            @Override
            public String getContentLocale() {
                return aEnv.getContentLocale();
            }

            @Override
            public String getPassport() {
                return null;
            }

            @Override
            public String getSkin() {
                return null;
            }
        };
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.isFakeTextEvent) {
            this.isFakeTextEvent = false;
            return 2;
        }
        return this.handleEvent(super.next());
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (this.isFakeTextEvent) {
            this.isFakeTextEvent = false;
            return 2;
        }
        return this.handleEvent(super.nextTag());
    }

    @Override
    public String getElementText() throws XMLStreamException {
        int type;
        if (!this.isStartElement()) {
            return null;
        }
        StringBuffer characters = null;
        String text = null;
        while ((type = this.next()) != 2) {
            if (type == 5 || type == 3) continue;
            if ((1 << type & 0x1250) == 0) {
                return null;
            }
            if (text != null) {
                characters = new StringBuffer(text.length());
                characters.append(text);
                text = null;
            }
            if (characters != null) {
                characters.append(this.getText());
                continue;
            }
            text = this.getText();
        }
        if (text != null) {
            return text;
        }
        return characters != null ? characters.toString() : "";
    }

    private int handleEvent(int event) {
        switch (event) {
            case 1: {
                this.isTextCommited = false;
                this.currentResourceId = this.getAttributeValue("", "resourceName");
                break;
            }
            case 2: {
                if (!this.isTextCommited && this.currentResourceId != null) {
                    this.isFakeTextEvent = true;
                    return 4;
                }
                this.isTextCommited = false;
                this.tempChars = null;
                this.currentResourceId = null;
            }
        }
        return event;
    }

    @Override
    public int getAttributeCount() {
        String lang = super.getAttributeValue(XML_LANG.getNamespaceURI(), XML_LANG.getLocalPart());
        if (lang == null && this.currentResourceId != null) {
            return super.getAttributeCount() + 1;
        }
        return super.getAttributeCount();
    }

    @Override
    public String getAttributeValue(int index) {
        if (index == super.getAttributeCount()) {
            return this.getAttributeValue(XML_LANG.getNamespaceURI(), XML_LANG.getLocalPart());
        }
        return this.getAttributeValue(super.getAttributeNamespace(index), super.getAttributeLocalName(index));
    }

    @Override
    public String getAttributeValue(String namespace, String name) {
        if (XML_LANG.getLocalPart().equals(name) && XML_LANG.getNamespaceURI().equals(namespace) && this.currentResourceId != null) {
            return this.locale;
        }
        return super.getAttributeValue(namespace, name);
    }

    @Override
    public String getText() {
        if (this.isTextCommited) {
            return "";
        }
        String value = this.getLocalizedString();
        if (value != null) {
            this.isTextCommited = true;
            return value;
        }
        return super.getText();
    }

    @Override
    public char[] getTextCharacters() {
        if (this.isTextCommited) {
            return this.tempChars;
        }
        String value = this.getLocalizedString();
        if (value != null) {
            this.isTextCommited = true;
            this.tempChars = value.toCharArray();
            return this.tempChars;
        }
        return super.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextLength() {
        if (this.isTextCommited) {
            return 0;
        }
        if (this.tempChars != null) {
            return this.tempChars.length;
        }
        String value = this.getLocalizedString();
        if (value != null) {
            this.isTextCommited = true;
            this.tempChars = value.toCharArray();
            return this.tempChars.length;
        }
        return super.getTextLength();
    }

    @Override
    public int getTextStart() {
        if (this.isTextCommited) {
            return 0;
        }
        if (this.tempChars != null) {
            return 0;
        }
        String value = this.getLocalizedString();
        if (value != null) {
            this.isTextCommited = true;
            this.tempChars = value.toCharArray();
            return 0;
        }
        return super.getTextStart();
    }

    private String getLocalizedString() {
        if (this.messageFile != null && this.currentResourceId != null) {
            try {
                return LocalizationManager.getInstance().getMessages(this.arc, this.messageFile, this.auc.getProductLocale()).getMessage(this.currentResourceId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (index == super.getAttributeCount()) {
            return XML_LANG.getLocalPart();
        }
        return super.getAttributeLocalName(index);
    }

    @Override
    public QName getAttributeName(int index) {
        if (index == super.getAttributeCount()) {
            return XML_LANG;
        }
        return super.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (index == super.getAttributeCount()) {
            return XML_LANG.getNamespaceURI();
        }
        return super.getAttributeNamespace(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        if (index == super.getAttributeCount()) {
            return XML_LANG.getPrefix();
        }
        return super.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        if (index == super.getAttributeCount()) {
            return "";
        }
        return super.getAttributeType(index);
    }
}

