/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.eventstore.BasicNamespace;
import com.cognos.portal.eventstore.NameImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

class NamespaceContextImpl
implements NamespaceContext {
    private int startScope;
    private int endScope;
    private boolean readOnly;
    private List nsList;
    private NamespaceContextImpl parent;
    private NameImpl elementName;

    public NamespaceContextImpl() {
        this.nsList = new ArrayList();
        this.nsList.add(new BasicNamespace("", ""));
        this.startScope = this.endScope = this.nsList.size();
        this.parent = null;
    }

    public NamespaceContextImpl(NamespaceContextImpl parent) {
        this.nsList = parent.nsList;
        this.startScope = this.endScope = this.nsList.size();
        this.parent = parent;
    }

    public void setElementName(NameImpl elementName) {
        this.elementName = elementName;
    }

    public NameImpl getElementName() {
        return this.elementName;
    }

    public NamespaceContextImpl createChildContext() {
        this.endScope = this.nsList.size();
        this.readOnly = true;
        return new NamespaceContextImpl(this);
    }

    public boolean canWrite() {
        return !this.readOnly;
    }

    public void addNamespace(BasicNamespace namespace) {
        if (this.canWrite()) {
            for (int i = this.startScope; i < this.nsList.size(); ++i) {
                BasicNamespace n = (BasicNamespace)this.nsList.get(i);
                if (!n.getPrefix().equals(namespace.getPrefix())) continue;
                this.nsList.remove(i);
                this.nsList.add(namespace);
                return;
            }
            this.nsList.add(namespace);
            ++this.endScope;
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i = this.endScope - 1; i >= 0; --i) {
            BasicNamespace n = (BasicNamespace)this.nsList.get(i);
            if (!n.getPrefix().equals(prefix)) continue;
            return n.getUri();
        }
        return null;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        for (int i = this.endScope - 1; i >= 0; --i) {
            BasicNamespace n = (BasicNamespace)this.nsList.get(i);
            if (!n.getUri().equals(uri)) continue;
            return n.getPrefix();
        }
        return null;
    }

    public BasicNamespace getBasicNamespace(String prefix, String uri) {
        for (int i = this.endScope - 1; i >= 0; --i) {
            BasicNamespace n = (BasicNamespace)this.nsList.get(i);
            if (!n.getUri().equals(uri) || !n.getPrefix().equals(prefix)) continue;
            return n;
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        ArrayList<String> list = new ArrayList<String>();
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            list.add("xml");
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            list.add("xmlns");
        } else {
            for (int i = this.endScope - 1; i >= 0; --i) {
                BasicNamespace n = (BasicNamespace)this.nsList.get(i);
                if (!n.getUri().equals(uri)) continue;
                list.add(n.getPrefix());
            }
        }
        return list.iterator();
    }

    public BasicNamespace getLocalNamespace(int index) {
        int i = this.startScope + index;
        if (this.nsList.size() > i) {
            return (BasicNamespace)this.nsList.get(i);
        }
        return null;
    }

    public NamespaceContextImpl getParentContext() {
        return this.parent;
    }

    public int getLocalNamespaceCount() {
        return this.endScope - this.startScope;
    }

    public NamespaceContext getReadOnlyContext() {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String arg0) {
                return NamespaceContextImpl.this.getNamespaceURI(arg0);
            }

            @Override
            public String getPrefix(String arg0) {
                return NamespaceContextImpl.this.getPrefix(arg0);
            }

            public Iterator getPrefixes(String arg0) {
                return NamespaceContextImpl.this.getPrefixes(arg0);
            }
        };
    }

    public BasicNamespace createBasicNamespace(String prefix, String namespaceURI) {
        for (int i = this.nsList.size() - 1; i >= 0; --i) {
            BasicNamespace n = (BasicNamespace)this.nsList.get(i);
            if (!n.getUri().equals(namespaceURI) || !n.getPrefix().equals(prefix)) continue;
            return n;
        }
        return new BasicNamespace(prefix, namespaceURI);
    }

    public boolean isRoot() {
        return this.parent == null;
    }
}

