/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class PathIterator
extends StreamReaderDelegate {
    private static String[] EMPTY_PATH_ARRAY = new String[0];
    private String[] pathArray;
    private StringBuffer currentPath;

    public PathIterator(XMLStreamReader reader) {
        this(reader, EMPTY_PATH_ARRAY);
    }

    public PathIterator(XMLStreamReader reader, String[] pathArray) {
        super(reader);
        this.pathArray = pathArray;
        this.currentPath = new StringBuffer();
        if (reader.getEventType() == 1) {
            this.handleEvent(1);
        }
    }

    public void setPathArray(String[] pathArray) {
        this.pathArray = pathArray;
    }

    public int moveToNextPath() throws XMLStreamException {
        return this.moveToNextPath(this.pathArray);
    }

    public int moveToNextPath(String[] pathArray) throws XMLStreamException {
        while (this.hasNext()) {
            int _event = this.next();
            switch (_event) {
                case 1: {
                    for (int _i = 0; _i < pathArray.length; ++_i) {
                        if (!pathArray[_i].contentEquals(this.currentPath)) continue;
                        return _i;
                    }
                    break;
                }
            }
        }
        return -1;
    }

    public boolean moveToNextPath(String path) throws XMLStreamException {
        String absolutePath = this.currentPath.toString() + path;
        while (this.hasNext()) {
            if (1 != this.next() || !absolutePath.contentEquals(this.currentPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int next() throws XMLStreamException {
        return this.handleEvent(super.next());
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String text = super.getElementText();
        this.currentPath.setLength(this.currentPath.length() - this.getLocalName().length() - 1);
        return text;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        return this.handleEvent(super.nextTag());
    }

    private int handleEvent(int event) {
        switch (event) {
            case 1: {
                this.currentPath.append('/');
                this.currentPath.append(this.getLocalName());
                break;
            }
            case 2: {
                this.currentPath.setLength(this.currentPath.length() - this.getLocalName().length() - 1);
            }
        }
        return event;
    }
}

