/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.xml.stream.StaxUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class XMLInsert
extends StreamReaderDelegate {
    private List xmlFragmentsInsertBefore;
    private List xmlFragmentsInsertAfter;
    private XMLFragment activeXMLFragment;
    private Stack readersStack = new Stack();

    public XMLInsert(XMLStreamReader reader) {
        super(reader);
        this.activeXMLFragment = new XMLFragment(reader, "", false, false, 0);
        this.readersStack = new Stack();
        this.xmlFragmentsInsertBefore = new ArrayList();
        this.xmlFragmentsInsertAfter = new ArrayList();
    }

    public void insertXMLAfter(String tagName, XMLStreamReader xsr) {
        this.insert(tagName, false, false, 2, this.xmlFragmentsInsertAfter, xsr);
    }

    public void insertXMLUnder(String tagName, XMLStreamReader xsr) {
        this.insert(tagName, false, false, 1, this.xmlFragmentsInsertAfter, xsr);
    }

    public void insertXMLBefore(String tagName, XMLStreamReader xsr) {
        this.insert(tagName, false, false, 1, this.xmlFragmentsInsertBefore, xsr);
    }

    public void insertXMLAfterIfNotExists(String tagName, XMLStreamReader xsr) {
        this.insert(tagName, true, false, 2, this.xmlFragmentsInsertAfter, xsr);
    }

    public void insertXMLUnderIfNotExists(String tagName, XMLStreamReader xsr) {
        this.insert(tagName, true, false, 1, this.xmlFragmentsInsertAfter, xsr);
    }

    public void replaceXML(String tagName, XMLStreamReader xsr) {
        this.insert(tagName, false, true, 1, this.xmlFragmentsInsertBefore, xsr);
    }

    private void insert(String tagName, boolean insertIfNotExists, boolean isReplace, int event, List list, XMLStreamReader xsr) {
        list.add(new XMLFragment(xsr, tagName, insertIfNotExists, isReplace, event));
    }

    private XMLFragment getXMLFragmentToInsertBeforeEvent(String tagName, int event) {
        return this.getXMLFragmentToInsert(tagName, event, this.xmlFragmentsInsertBefore);
    }

    private XMLFragment getXMLFragmentToInsertAfterEvent(String tagName, int event) {
        return this.getXMLFragmentToInsert(tagName, event, this.xmlFragmentsInsertAfter);
    }

    private XMLFragment getXMLFragmentToInsert(String tagName, int event, List list) {
        for (int i = 0; i < list.size(); ++i) {
            XMLFragment insert = (XMLFragment)list.get(i);
            if (!tagName.equals(insert.insertTag) || event != insert.event || insert.isInserted) continue;
            insert.isInserted = true;
            return insert;
        }
        return null;
    }

    @Override
    public int next() throws XMLStreamException {
        this.insertXMLAfterCurrentEvent();
        int nextEvent = this.getNextEvent();
        return this.insertXMLBeforeNextEvent(nextEvent);
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        boolean hasNext = super.hasNext();
        if (!hasNext && this.readersStack.size() > 0) {
            this.restorePreviousReader();
            return this.hasNext();
        }
        return hasNext;
    }

    private int getNextEvent() throws XMLStreamException {
        if (this.activeXMLFragment.isPeek) {
            this.activeXMLFragment.isPeek = false;
            return this.getEventType();
        }
        int event = super.next();
        switch (event) {
            case 7: {
                if (this.readersStack.size() <= 0) break;
                return this.nextTag();
            }
            case 8: {
                if (this.readersStack.size() <= 0) break;
                this.restorePreviousReader();
                return this.getNextEvent();
            }
        }
        return event;
    }

    private void insertXMLAfterCurrentEvent() throws XMLStreamException {
        String localName;
        XMLFragment xmlInsert;
        if (!(!this.isStartElement() && !this.isEndElement() || (xmlInsert = this.getXMLFragmentToInsertAfterEvent(localName = this.getLocalName(), this.getEventType())) == null || xmlInsert.insertIfNotExists && xmlInsert.peek().equals(this.activeXMLFragment.peek()))) {
            this.readersStack.push(this.activeXMLFragment);
            this.activeXMLFragment = xmlInsert;
            this.setParent(this.activeXMLFragment.xsr);
        }
    }

    private int insertXMLBeforeNextEvent(int event) throws XMLStreamException {
        switch (event) {
            case 1: 
            case 2: {
                String localName = this.getLocalName();
                XMLFragment xmlInsert = this.getXMLFragmentToInsertBeforeEvent(localName, event);
                if (xmlInsert == null) break;
                if (!xmlInsert.isReplace) {
                    this.activeXMLFragment.isPeek = true;
                } else {
                    StaxUtils.moveToNextSibling(this.activeXMLFragment.xsr);
                }
                this.readersStack.push(this.activeXMLFragment);
                this.activeXMLFragment = xmlInsert;
                this.setParent(this.activeXMLFragment.xsr);
                return this.next();
            }
        }
        return event;
    }

    private void restorePreviousReader() {
        this.activeXMLFragment = (XMLFragment)this.readersStack.pop();
        this.setParent(this.activeXMLFragment.xsr);
    }

    class XMLFragment {
        XMLStreamReader xsr;
        boolean isPeek;
        String insertTag;
        boolean insertIfNotExists;
        boolean isInserted;
        boolean isReplace;
        int event;

        XMLFragment(XMLStreamReader xsr, String insertTag, boolean insertIfNotExists, boolean isReplace, int event) {
            this.xsr = xsr;
            this.insertTag = insertTag;
            this.insertIfNotExists = insertIfNotExists;
            this.isReplace = isReplace;
            this.event = event;
        }

        String peek() throws XMLStreamException {
            if (this.xsr.isStartElement() && this.isPeek) {
                return this.xsr.getLocalName();
            }
            if (this.xsr.hasNext()) {
                this.isPeek = true;
                do {
                    this.xsr.next();
                } while (this.xsr.isWhiteSpace() && this.xsr.hasNext());
                if (this.xsr.isStartElement()) {
                    return this.xsr.getLocalName();
                }
            }
            return "";
        }
    }
}

