/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.xml.stream.IsolatedXMLStreamReader;
import com.cognos.portal.xml.stream.PathIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLObjectReader {
    public static XMLType MAP_TYPE = new MapObject();
    PathIterator pathIterator;
    String[] pathArray;
    Map values;
    Map xmlTypes;
    boolean isParsed;

    public XMLObjectReader(XMLStreamReader xsr, String[] pathArray) {
        this.pathArray = pathArray;
        this.pathIterator = new PathIterator(xsr, pathArray);
        this.values = new HashMap();
    }

    public void setXMLTypeForPath(String path, XMLType xmlTypeHandler) {
        if (this.xmlTypes == null) {
            this.xmlTypes = new HashMap();
        }
        this.xmlTypes.put(path, xmlTypeHandler);
    }

    public Object getObject(String path) throws XMLStreamException {
        Object value;
        if (!this.isParsed) {
            this.parse();
        }
        if ((value = this.values.get(path)) instanceof InternalList) {
            return ((List)value).get(0);
        }
        return value;
    }

    public List getObjects(String path) throws XMLStreamException {
        Object value;
        if (!this.isParsed) {
            this.parse();
        }
        if ((value = this.values.get(path)) instanceof InternalList) {
            return (List)value;
        }
        return this.addAsList(value, path);
    }

    private List addAsList(Object object, String path) {
        InternalList list = new InternalList();
        list.add(object);
        this.values.put(path, list);
        return list;
    }

    private void parse() throws XMLStreamException {
        int index;
        this.isParsed = true;
        while ((index = this.pathIterator.moveToNextPath()) != -1) {
            Object previousValue;
            Object value;
            String path = this.pathArray[index];
            XMLType handler = this.getHandler(path);
            if (handler != null) {
                IsolatedXMLStreamReader xsr = new IsolatedXMLStreamReader(this.pathIterator);
                value = handler.read(xsr);
                while (xsr.hasNext()) {
                    xsr.next();
                }
            } else {
                value = this.pathIterator.getElementText();
            }
            if ((previousValue = this.values.get(path)) == null) {
                this.values.put(path, value);
                continue;
            }
            if (previousValue instanceof InternalList) {
                ((InternalList)previousValue).add(value);
                continue;
            }
            this.addAsList(previousValue, path).add(value);
        }
    }

    private XMLType getHandler(String path) {
        if (this.xmlTypes != null) {
            return (XMLType)this.xmlTypes.get(path);
        }
        return null;
    }

    public static class MapObject
    implements XMLType {
        String nameTag;
        String valueTag;

        public MapObject() {
            this("name", "value");
        }

        public MapObject(String nameTag, String valueTag) {
            this.nameTag = nameTag;
            this.valueTag = valueTag;
        }

        @Override
        public Object read(XMLStreamReader xsr) throws XMLStreamException {
            HashMap<String, String> map = new HashMap<String, String>();
            String name = null;
            String value = null;
            int level = 0;
            while (xsr.hasNext()) {
                xsr.next();
                if (xsr.isStartElement()) {
                    if (level > 1) {
                        String localName = xsr.getLocalName();
                        if (this.nameTag.equals(localName)) {
                            name = xsr.getElementText();
                            continue;
                        }
                        if (!this.valueTag.equals(localName)) continue;
                        value = xsr.getElementText();
                        continue;
                    }
                    ++level;
                    continue;
                }
                if (!xsr.isEndElement() || --level != 1) continue;
                map.put(name, value);
                name = null;
                value = null;
            }
            return map;
        }
    }

    public static interface XMLType {
        public Object read(XMLStreamReader var1) throws XMLStreamException;
    }

    private class InternalList
    extends ArrayList {
        private static final long serialVersionUID = 1L;

        private InternalList() {
        }
    }
}

