/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.eventstore.BasicNamespace;
import com.cognos.portal.eventstore.EventStore;
import com.cognos.portal.eventstore.NameImpl;
import com.cognos.portal.eventstore.SAXReader;
import com.cognos.portal.xml.pipeline.PipelineException;
import com.cognos.portal.xml.stream.NamespaceContextImpl;
import com.cognos.portal.xml.stream.StaxUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLRecorderStreamReader
implements XMLStreamReader {
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    private static final int DEFAULT_ATTRIBUTE_COUNT = 10;
    NamespaceContextImpl namespaceContext;
    EventStore.StoreReader storeReader;
    EventStore es;
    private AttributesHolder attributes;
    private List namespaces;
    private NameImpl currentName;
    int currentEvent = -1;
    int charlength;
    int charOffset;
    String encoding;
    String version;
    private boolean fixContext;

    public XMLRecorderStreamReader(EventStore es, String version, String encoding) {
        this.es = es;
        this.storeReader = es.createReader();
        this.attributes = new AttributesHolder();
        this.namespaces = new ArrayList();
        this.version = version;
        this.encoding = encoding;
        this.namespaceContext = new NamespaceContextImpl();
        this.fixContext = false;
        this.checkCurrent();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    private void checkCurrent() {
        if (this.currentEvent == -1 && this.storeReader.hasNext()) {
            this.getEventFromStoreReader();
        }
    }

    private void readStartElement() {
        this.namespaceContext = this.namespaceContext.createChildContext();
        for (BasicNamespace ns : this.namespaces) {
            this.namespaceContext.addNamespace(ns);
        }
        this.namespaces.clear();
        this.attributes.clear();
        this.currentName = this.storeReader.readQName();
        this.namespaceContext.setElementName(this.currentName);
        int count = this.storeReader.readEvent();
        for (int i = 0; i < count; ++i) {
            NameImpl aname = this.storeReader.readQName();
            String avalue = this.storeReader.readString();
            this.attributes.addAttribute(aname, avalue);
        }
    }

    private int getEventFromStoreReader() {
        if (this.fixContext) {
            this.namespaceContext = this.namespaceContext.getParentContext();
            this.fixContext = false;
        }
        int storeEvent = this.storeReader.readEvent();
        switch (storeEvent) {
            case 2: {
                this.currentEvent = 1;
                this.readStartElement();
                return this.currentEvent;
            }
            case 3: {
                this.currentEvent = 2;
                if (this.namespaceContext != null) {
                    this.currentName = this.namespaceContext.getElementName();
                    this.fixContext = true;
                }
                return this.currentEvent;
            }
            case 0: {
                this.currentEvent = 7;
                return this.currentEvent;
            }
            case 1: {
                this.currentEvent = 8;
                return this.currentEvent;
            }
            case 9: {
                this.currentEvent = 5;
                return this.currentEvent;
            }
            case 11: {
                BasicNamespace ns = this.storeReader.getNamespace(this.storeReader.readEvent());
                this.namespaces.add(ns);
                this.currentEvent = 13;
                return this.currentEvent;
            }
            case 4: {
                this.currentEvent = 4;
                this.charOffset = this.storeReader.getCharOffset();
                this.charlength = this.storeReader.readChars();
                return this.currentEvent;
            }
            case 8: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 10: {
                this.currentEvent = 14;
                return this.currentEvent;
            }
            case 5: {
                this.currentEvent = 12;
                this.charOffset = this.storeReader.getCharOffset();
                this.charlength = this.storeReader.readChars();
                return this.currentEvent;
            }
            case 6: {
                this.currentEvent = 9;
                return this.currentEvent;
            }
            case 7: {
                this.currentEvent = 6;
                return this.currentEvent;
            }
        }
        return 0;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.hasNext()) {
            return this.getEventFromStoreReader();
        }
        throw new XMLStreamException("no more events");
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        int type;
        if (!this.isStartElement()) {
            return null;
        }
        StringBuffer characters = null;
        String text = null;
        while ((type = this.next()) != 2) {
            if (type == 5 || type == 3) continue;
            if ((1 << type & 0x1250) == 0) {
                return null;
            }
            if (text != null) {
                characters = new StringBuffer(text.length() + this.charlength);
                characters.append(text);
                text = null;
            }
            if (characters != null) {
                characters.append(this.getText());
                continue;
            }
            text = this.getText();
        }
        if (text != null) {
            return text;
        }
        return characters != null ? characters.toString() : "";
    }

    @Override
    public int nextTag() throws XMLStreamException {
        this.checkCurrent();
        do {
            this.next();
        } while (!this.isStartElement() && !this.isEndElement() && this.hasNext());
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.storeReader.hasNext();
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaceContext.getNamespaceURI(prefix);
    }

    @Override
    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.currentEvent == 4 || this.currentEvent == 12;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.currentEvent == 6;
    }

    @Override
    public String getAttributeValue(String NamespaceURI, String localName) {
        if (this.isStartElement()) {
            return this.attributes.getValue(NamespaceURI, localName);
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.getLength();
    }

    @Override
    public QName getAttributeName(int index) {
        if (this.isStartElement()) {
            QName qName = new QName(this.getAttributeNamespace(index), this.getAttributeLocalName(index), this.getAttributePrefix(index));
            return qName;
        }
        return null;
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.isStartElement()) {
            return this.attributes.getURI(index);
        }
        return null;
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.isStartElement()) {
            return this.attributes.getLocalName(index);
        }
        return null;
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.isStartElement()) {
            return this.attributes.getPrefix(index);
        }
        return null;
    }

    @Override
    public String getAttributeType(int index) {
        if (this.isStartElement()) {
            return this.attributes.getType(index);
        }
        return null;
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.isStartElement()) {
            return this.attributes.getValue(index);
        }
        return null;
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return index < this.attributes.getLength();
    }

    @Override
    public int getNamespaceCount() {
        return this.namespaceContext.getLocalNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        BasicNamespace ns;
        if (this.isStartElement() && (ns = this.namespaceContext.getLocalNamespace(index)) != null) {
            return ns.getPrefix();
        }
        return null;
    }

    @Override
    public String getNamespaceURI(int index) {
        BasicNamespace ns;
        if (this.isStartElement() && (ns = this.namespaceContext.getLocalNamespace(index)) != null) {
            return ns.getUri();
        }
        return null;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext.getReadOnlyContext();
    }

    @Override
    public int getEventType() {
        this.checkCurrent();
        return this.currentEvent;
    }

    @Override
    public String getText() {
        if (this.isCharacters()) {
            return new String(this.storeReader.getChars(), this.charOffset, this.charlength);
        }
        return null;
    }

    @Override
    public char[] getTextCharacters() {
        if (this.isCharacters()) {
            return this.storeReader.getChars();
        }
        return null;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.isCharacters()) {
            System.arraycopy(this.getTextCharacters(), this.getTextStart(), target, targetStart, length);
            if (length + sourceStart < this.getTextLength()) {
                return length;
            }
            return this.getTextLength() - sourceStart;
        }
        return 0;
    }

    @Override
    public int getTextStart() {
        if (this.isCharacters()) {
            return this.charOffset;
        }
        return -1;
    }

    @Override
    public int getTextLength() {
        if (this.isCharacters()) {
            return this.charlength;
        }
        return -1;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    @Override
    public QName getName() {
        if (this.isStartElement()) {
            return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
        }
        return null;
    }

    @Override
    public String getLocalName() {
        if (this.hasName()) {
            return this.currentName.getName();
        }
        return null;
    }

    @Override
    public boolean hasName() {
        return this.isStartElement() || this.isEndElement();
    }

    @Override
    public String getNamespaceURI() {
        if (this.isStartElement()) {
            return this.currentName.getNamespace().getUri();
        }
        return null;
    }

    @Override
    public String getPrefix() {
        if (this.isStartElement()) {
            return this.currentName.getNamespace().getPrefix();
        }
        return null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.encoding;
    }

    @Override
    public String getPITarget() {
        return null;
    }

    @Override
    public String getPIData() {
        return null;
    }

    public void push(ContentHandler contentHandler) throws PipelineException {
        try {
            SAXReader saxReader = new SAXReader(this.es);
            saxReader.setContentHandler(contentHandler);
            saxReader.read();
        }
        catch (SAXException e) {
            throw new PipelineException("error while reading event store", e);
        }
    }

    public void toXML(XMLStreamWriter xsw) throws PipelineException {
        try {
            StaxUtils.copyCurrentElement(this, xsw);
        }
        catch (XMLStreamException e) {
            throw new PipelineException("error :", e);
        }
    }

    private class AttributesHolder
    implements Attributes {
        private int m_attributeCount;
        private NameImpl[] m_names = new NameImpl[10];
        private String[] m_values = new String[10];

        private AttributesHolder() {
        }

        @Override
        public int getLength() {
            return this.m_attributeCount;
        }

        @Override
        public String getLocalName(int index) {
            return this.m_names[index].getName();
        }

        @Override
        public String getQName(int index) {
            return this.m_names[index].getQName();
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getURI(int index) {
            return this.m_names[index].getNamespace().getUri();
        }

        public String getPrefix(int index) {
            return this.m_names[index].getNamespace().getPrefix();
        }

        @Override
        public String getValue(int index) {
            return this.m_values[index];
        }

        @Override
        public int getIndex(String qname) {
            int split = qname.indexOf(58);
            String prefix = "";
            String lname = qname;
            if (split >= 0) {
                prefix = qname.substring(0, split);
                lname = qname.substring(split + 1);
            }
            for (int i = 0; i < this.m_attributeCount; ++i) {
                NameImpl name = this.m_names[i];
                if (!lname.equals(name.getName()) || !prefix.equals(name.getNamespace().getPrefix())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String qname) {
            int index = this.getIndex(qname);
            if (index >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getValue(String qname) {
            int index = this.getIndex(qname);
            if (index >= 0) {
                return this.m_values[index];
            }
            return null;
        }

        @Override
        public int getIndex(String uri, String lname) {
            for (int i = 0; i < this.m_attributeCount; ++i) {
                NameImpl name = this.m_names[i];
                if (!lname.equals(name.getName()) || !uri.equals(name.getNamespace().getUri())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getType(String uri, String lname) {
            int index = this.getIndex(uri, lname);
            if (index >= 0) {
                return "CDATA";
            }
            return null;
        }

        @Override
        public String getValue(String uri, String lname) {
            int index = this.getIndex(uri, lname);
            if (index >= 0) {
                return this.m_values[index];
            }
            return null;
        }

        public void clear() {
            this.m_attributeCount = 0;
        }

        public void addAttribute(NameImpl name, String value) {
            if (this.m_attributeCount >= this.m_names.length) {
                NameImpl[] copy = new NameImpl[this.m_names.length * 2];
                System.arraycopy(this.m_names, 0, copy, 0, this.m_names.length);
                this.m_names = copy;
                String[] valuesCopy = new String[this.m_values.length * 2];
                System.arraycopy(this.m_values, 0, valuesCopy, 0, this.m_values.length);
                this.m_values = valuesCopy;
            }
            this.m_names[this.m_attributeCount] = name;
            this.m_values[this.m_attributeCount++] = value;
        }
    }
}

