/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.eventstore.BasicNamespace;
import com.cognos.portal.eventstore.EventStore;
import com.cognos.portal.eventstore.SAXReader;
import com.cognos.portal.xml.stream.NamespaceContextImpl;
import com.cognos.portal.xml.stream.XMLRecorderStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLRecorderStreamWriter
implements XMLStreamWriter {
    private static final String EMPTY_NAMESPACE_URI = "";
    private static final String EMPTY_NAMESPACE_PREFIX = "";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_VERSION = "1.0";
    private EventStore es;
    private ElementHolder currentElement;
    private NamespaceContextImpl nsContext;
    private String encoding;
    private String version;
    private String defaultNamespace;
    private boolean documentStarted;

    public XMLRecorderStreamWriter() {
        this.init();
    }

    private void init() {
        this.es = new EventStore();
        this.nsContext = new NamespaceContextImpl();
        this.nsContext.addNamespace(new BasicNamespace("", ""));
    }

    private BasicNamespace createEventStoreNamespace(String prefix, String namespaceURI) {
        return this.nsContext.createBasicNamespace(prefix, namespaceURI);
    }

    private void flushStartElement() {
        if (this.currentElement != null) {
            this.currentElement.flush();
        } else {
            this.currentElement = new ElementHolder();
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement("", localName, "");
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        String prefix;
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if ((prefix = this.getPrefix(namespaceURI)) == null) {
            throw new XMLStreamException("Namespace '" + namespaceURI + "' is not defined");
        }
        this.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (localName == null) {
            throw new XMLStreamException("localName should not be null");
        }
        if (!this.documentStarted) {
            this.writeStartDocument();
        }
        this.flushStartElement();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (prefix == null && (prefix = this.getPrefix(namespaceURI)) == null) {
            prefix = "";
        }
        this.nsContext = this.nsContext.createChildContext();
        this.currentElement.clear();
        this.currentElement.localName = localName;
        this.currentElement.namespace = this.createEventStoreNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeEndElement();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (!this.nsContext.isRoot()) {
            this.flushStartElement();
            this.nsContext = this.nsContext.getParentContext();
            this.es.appendEvent((short)3);
        }
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.documentStarted = false;
        this.es.appendEvent((short)1);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute("", "", localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        String prefix;
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if ((prefix = this.getPrefix(namespaceURI)) == null) {
            throw new XMLStreamException("The namespace '" + namespaceURI + "' is not defined");
        }
        this.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.currentElement == null || this.currentElement.isFlushed) {
            throw new XMLStreamException("Cannot add attribute at this position");
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (prefix == null) {
            prefix = this.getPrefix(namespaceURI);
        }
        if (value == null) {
            value = "";
        }
        this.currentElement.addAttribute(prefix, localName, namespaceURI, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (prefix == null || prefix.length() == 0 || prefix.equals("xmlns")) {
            this.writeDefaultNamespace(namespaceURI);
        } else {
            this.currentElement.addNamespace(this.createEventStoreNamespace(prefix, namespaceURI));
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        this.currentElement.addNamespace(this.createEventStoreNamespace("", namespaceURI));
    }

    @Override
    public void writeComment(String comment) throws XMLStreamException {
        this.es.appendEvent((short)9);
        this.es.appendEvent((short)comment.length());
        this.es.appendChars(comment.toCharArray(), 0, comment.length());
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writeProcessingInstruction(target, null);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.es.appendEvent((short)8);
        this.es.appendString(target);
        this.es.appendString(data);
    }

    @Override
    public void writeCData(String text) throws XMLStreamException {
        this.flushStartElement();
        this.addTextEvent((short)5, text.toCharArray(), 0, text.length());
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(DEFAULT_ENCODING);
    }

    @Override
    public void writeStartDocument(String encoding) throws XMLStreamException {
        this.writeStartDocument(DEFAULT_VERSION, encoding);
    }

    @Override
    public void writeStartDocument(String version, String encoding) throws XMLStreamException {
        this.documentStarted = true;
        this.version = version;
        this.encoding = encoding;
        this.es.appendEvent((short)0);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writeCharacters(text.toCharArray(), 0, text.length());
    }

    @Override
    public void writeCharacters(char[] ch, int start, int length) throws XMLStreamException {
        this.flushStartElement();
        this.addTextEvent((short)4, ch, start, length);
    }

    private void addTextEvent(short event, char[] ch, int start, int length) {
        int tmpLength = length;
        while (tmpLength > 0) {
            this.es.appendEvent(event);
            if (Short.MAX_VALUE > tmpLength) {
                this.es.appendEvent((short)tmpLength);
                tmpLength = 0;
                continue;
            }
            this.es.appendEvent((short)Short.MAX_VALUE);
            tmpLength -= Short.MAX_VALUE;
        }
        this.es.appendChars(ch, start, length);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.nsContext.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.nsContext.addNamespace(this.createEventStoreNamespace(prefix, uri));
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.defaultNamespace = uri;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.nsContext.getReadOnlyContext();
    }

    @Override
    public void close() throws XMLStreamException {
        this.flush();
        while (!this.nsContext.isRoot()) {
            this.writeEndElement();
        }
        if (this.documentStarted) {
            this.writeEndDocument();
        }
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    public XMLStreamReader toXMLStreamReader() {
        return new XMLRecorderStreamReader(this.es, this.version, this.encoding);
    }

    public SAXReader toSAXReader() {
        return new SAXReader(this.es);
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
    }

    class ElementHolder {
        boolean isFlushed;
        String localName;
        BasicNamespace namespace;
        int attCount;
        int[] attHandles = new int[2];
        String[] attValues = new String[2];
        List namespaces;

        public void flush() {
            if (!this.isFlushed) {
                this.isFlushed = true;
                if (this.namespaces != null) {
                    Iterator it = this.namespaces.iterator();
                    while (it.hasNext()) {
                        int handle = XMLRecorderStreamWriter.this.es.appendNs((BasicNamespace)it.next());
                        XMLRecorderStreamWriter.this.es.appendEvent((short)11);
                        XMLRecorderStreamWriter.this.es.appendEvent((short)handle);
                    }
                }
                XMLRecorderStreamWriter.this.es.appendElementStart(this.namespace, this.localName, this.attCount);
                for (int i = 0; i < this.attCount; ++i) {
                    XMLRecorderStreamWriter.this.es.appendEvent((short)this.attHandles[i]);
                    XMLRecorderStreamWriter.this.es.appendString(this.attValues[i]);
                }
            }
        }

        public void addNamespace(BasicNamespace namespace) {
            if (this.namespaces == null) {
                this.namespaces = new ArrayList();
            }
            this.namespaces.add(namespace);
        }

        public void addAttribute(String prefix, String localName, String namespaceURI, String value) {
            BasicNamespace n = XMLRecorderStreamWriter.this.createEventStoreNamespace(prefix, namespaceURI);
            int handle = XMLRecorderStreamWriter.this.es.getNameImpl(n, localName).getHandle();
            if (this.attCount >= this.attHandles.length) {
                int[] copy = new int[this.attHandles.length * 2];
                System.arraycopy(this.attHandles, 0, copy, 0, this.attHandles.length);
                this.attHandles = copy;
                String[] valuesCopy = new String[this.attValues.length * 2];
                System.arraycopy(this.attValues, 0, valuesCopy, 0, this.attValues.length);
                this.attValues = valuesCopy;
            }
            if (this.attCount < this.attHandles.length) {
                this.attHandles[this.attCount] = handle;
                this.attValues[this.attCount] = value;
            }
            ++this.attCount;
        }

        public void clear() {
            this.isFlushed = false;
            this.localName = null;
            this.namespace = null;
            this.attCount = 0;
            if (this.namespaces != null) {
                this.namespaces.clear();
            }
        }
    }
}

