/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.StreamReaderDelegate;

public class XMLStreamReaderRecorder
extends StreamReaderDelegate {
    private static final int HEADER_SIZE = 16384;
    private XMLStreamWriter writer;
    private StringWriter recordStream;
    private boolean isStartRecording = false;
    private boolean isInit = false;
    private String _prefix;
    private String _namespace;
    private String _nsPrefix;
    private String _nsURI;
    private String _attPrefix;
    private String _attNamespace;
    private int _attrCount;
    private int level = 0;
    private String recordedElement;

    public XMLStreamReaderRecorder(String recordedElement, XMLStreamReader reader) {
        super(reader);
        this.recordedElement = recordedElement;
    }

    @Override
    public int next() throws XMLStreamException {
        int event = super.next();
        this.save(event);
        return event;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int event = super.nextTag();
        this.save(event);
        return event;
    }

    private void save(int event) throws XMLStreamException {
        if (this.isStartRecording) {
            switch (event) {
                case 1: {
                    int i;
                    this._prefix = this.getPrefix();
                    this._namespace = this.getNamespaceURI();
                    this.writer.writeStartElement(this._prefix, this.getLocalName(), this._namespace);
                    int namspaceCount = this.getNamespaceCount();
                    for (i = 0; i < namspaceCount; ++i) {
                        this._nsPrefix = this.getNamespacePrefix(i);
                        this._nsURI = this.getNamespaceURI(i);
                        if (this._nsPrefix != null) {
                            this.writer.setPrefix(this._nsPrefix, this._nsURI);
                        }
                        this.writer.writeNamespace(this._nsPrefix, this._nsURI);
                    }
                    if (this._prefix != null && this._namespace != null && this.writer.getNamespaceContext().getNamespaceURI(this._prefix) == null) {
                        this.writer.setPrefix(this._prefix, this._namespace);
                        this.writer.writeNamespace(this._prefix, this._namespace);
                    }
                    this._attrCount = this.getAttributeCount();
                    for (i = 0; i < this._attrCount; ++i) {
                        this._attPrefix = this.getAttributePrefix(i);
                        this._attNamespace = this.getAttributeNamespace(i);
                        if (this._attPrefix != null && this.writer.getNamespaceContext().getNamespaceURI(this._attPrefix) == null) {
                            this.writer.setPrefix(this._attPrefix, this._attNamespace);
                            this.writer.writeNamespace(this._attPrefix, this._attNamespace);
                        }
                        this.writer.writeAttribute(this._attPrefix, this._attNamespace, this.getAttributeLocalName(i), this.getAttributeValue(i));
                    }
                    ++this.level;
                    break;
                }
                case 2: {
                    this.writer.writeEndElement();
                    if (--this.level != 0) break;
                    this.stopRecording();
                    this.writer.flush();
                    return;
                }
                case 4: {
                    this.writer.writeCharacters(this.getText());
                    break;
                }
                case 12: {
                    this.writer.writeCData(this.getText());
                }
            }
        } else if (event == 1 && !this.isInit && this.recordedElement.equals(this.getLocalName())) {
            this.startRecording();
        }
    }

    private void initialize() throws XMLStreamException {
        this.recordStream = new StringWriter(16384);
        this.writer = XMLStreamFactory.createXMLStreamWriter(this.recordStream);
        this.isInit = true;
    }

    private void startRecording() throws XMLStreamException {
        if (!this.isInit) {
            this.initialize();
        }
        this.isStartRecording = true;
        this.save(this.getEventType());
    }

    private void stopRecording() {
        this.isStartRecording = false;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        String text = super.getElementText();
        if (this.isStartRecording) {
            this.writer.writeCharacters(text);
            this.writer.writeEndElement();
            --this.level;
        }
        return text;
    }

    public String getRecordedString() {
        return this.recordStream != null ? this.recordStream.toString() : "";
    }
}

