/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.PrintStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.ResultBuilder;

public class XMLStreamResultBuilder
extends ResultBuilder {
    private XMLStreamWriter xmlsw;
    private boolean cdata;
    private Declaration namespaces;

    public XMLStreamResultBuilder(String uri, PrintStream stream) throws XMLStreamException, FactoryConfigurationError {
        super(uri);
        this.xmlsw = XMLStreamFactory.createXMLStreamWriter(stream);
    }

    public void startDocument(OutputFormat outputFormat) throws XsltException {
        try {
            this.namespaces = null;
            this.xmlsw.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void endDocument() throws XsltException {
        try {
            this.xmlsw.writeEndDocument();
            this.xmlsw.flush();
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void startElement(String namespaceUri, String name, NamespaceContext namespaceContext, boolean isCDataSectionElement) throws XsltException {
        try {
            if (namespaceUri != null) {
                int sep = name.indexOf(58);
                if (sep > 0) {
                    String localName = name.substring(sep + 1);
                    String prefix = name.substring(0, sep);
                    this.xmlsw.writeStartElement(prefix, localName, namespaceUri);
                } else {
                    this.xmlsw.writeStartElement(namespaceUri, name);
                }
            } else {
                this.xmlsw.writeStartElement(name);
            }
            this.namespaces = new Declaration(this.namespaces);
            for (NamespaceContext nsc = namespaceContext; nsc != null; nsc = nsc.next()) {
                Declaration scan = this.namespaces;
                while (!(scan == null || nsc.getPrefix().equals(scan.prefix) && nsc.getUri().equals(scan.uri))) {
                    if (scan.next != null) {
                        scan = scan.next;
                        continue;
                    }
                    scan = scan.parent;
                }
                if (scan != null) continue;
                if (this.namespaces.uri == null) {
                    this.namespaces.prefix = nsc.getPrefix();
                    this.namespaces.uri = nsc.getUri();
                } else {
                    this.namespaces = new Declaration(nsc.getPrefix(), nsc.getUri(), this.namespaces);
                }
                this.xmlsw.writeNamespace(nsc.getPrefix(), nsc.getUri());
            }
            this.cdata = isCDataSectionElement;
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void endElement() throws XsltException {
        try {
            this.xmlsw.writeEndElement();
            Declaration scan = this.namespaces;
            while (scan != null) {
                if (scan.parent != null) {
                    this.namespaces = scan.parent;
                    break;
                }
                scan = scan.next;
            }
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void addNamespace(String prefix, String uri, boolean test) throws XsltException {
        try {
            this.xmlsw.writeNamespace(prefix, uri);
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public String getNamespacePrefix(String uri) {
        try {
            return this.xmlsw.getPrefix(uri);
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void addAttribute(String name, String prefix, String uri, String value) throws XsltException {
        try {
            String localName;
            int sep = name.indexOf(58);
            String string = localName = sep > 0 ? name.substring(sep + 1) : name;
            if (value == null) {
                value = "";
            }
            if (prefix != null && !"".equals(prefix)) {
                this.xmlsw.writeAttribute(prefix, uri, localName, value);
            } else if (uri != null) {
                this.xmlsw.writeAttribute(uri, localName, value);
            } else {
                this.xmlsw.writeAttribute(localName, value);
            }
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void addText(String text) throws XsltException {
        try {
            if (this.cdata) {
                this.xmlsw.writeCData(text);
            } else {
                this.xmlsw.writeCharacters(text);
            }
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void addTextUnescaped(String text) throws XsltException {
        try {
            this.xmlsw.writeCData(text);
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void addComment(String value) throws XsltException {
        try {
            this.xmlsw.writeComment(value);
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    public void addProcessingInstruction(String target, String data) throws XsltException {
        try {
            this.xmlsw.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new XsltException(e.getMessage(), (Throwable)e);
        }
    }

    private static class Declaration {
        String prefix;
        String uri;
        Declaration next;
        Declaration parent;

        Declaration(Declaration parent) {
            this.parent = parent;
        }

        Declaration(String prefix, String uri, Declaration next) {
            this.prefix = prefix;
            this.uri = uri;
            this.next = next;
        }
    }
}

