/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLStreamWriterToSAX
implements XMLStreamWriter {
    private ContentHandler contentHandler;
    Context currentContext;
    NamespaceContext namespaceContext;

    private void flushStartElement() throws XMLStreamException {
        if (!this.currentContext.startEventFlushed) {
            this.startElement();
            this.currentContext.startEventFlushed = true;
        }
    }

    private void startElement() throws XMLStreamException {
        if (this.currentContext != null) {
            try {
                for (String[] a : this.currentContext.namespaces) {
                    this.contentHandler.startPrefixMapping(a[0], a[1]);
                }
                String qName = this.currentContext.localName;
                if (this.currentContext.prefix != null) {
                    qName = this.currentContext.prefix + ":" + this.currentContext.localName;
                }
                this.contentHandler.startElement(this.currentContext.nameSpaceURI, this.currentContext.localName, qName, this.currentContext.attributes);
            }
            catch (SAXException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    private void endElement() throws XMLStreamException {
        if (this.currentContext != null) {
            try {
                String qName = this.currentContext.localName;
                if (this.currentContext.prefix != null) {
                    qName = this.currentContext.prefix + ":" + this.currentContext.localName;
                }
                this.contentHandler.endElement(this.currentContext.nameSpaceURI, this.currentContext.localName, qName);
                for (String[] a : this.currentContext.namespaces) {
                    this.contentHandler.endPrefixMapping(a[0]);
                }
                this.currentContext = this.currentContext.parentContext;
            }
            catch (SAXException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public XMLStreamWriterToSAX(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.currentContext = new Context(null);
        this.currentContext.startEventFlushed = true;
        this.namespaceContext = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return null;
            }

            @Override
            public String getPrefix(String uri) {
                return null;
            }

            public Iterator getPrefixes(String uri) {
                return null;
            }
        };
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, null);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(null, localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.flushStartElement();
        this.currentContext = new Context(this.currentContext);
        this.currentContext.prefix = prefix;
        this.currentContext.localName = localName;
        this.currentContext.nameSpaceURI = namespaceURI;
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, null);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(null, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.currentContext = new Context(this.currentContext);
        this.currentContext.prefix = prefix;
        this.currentContext.localName = localName;
        this.currentContext.nameSpaceURI = namespaceURI;
        this.startElement();
        this.endElement();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.flushStartElement();
        this.endElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.flush();
    }

    @Override
    public void flush() throws XMLStreamException {
        while (this.currentContext.parentContext != null) {
            this.endElement();
        }
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, null, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(null, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (this.currentContext.startEventFlushed) {
            throw new XMLStreamException("attribute cannot be added at this point");
        }
        String attQName = localName;
        if (prefix != null) {
            attQName = prefix + ":" + localName;
        }
        this.currentContext.attributes.addAttribute(namespaceURI, localName, attQName, "CDATA", value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.currentContext.addNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String prefix) throws XMLStreamException {
        this.writeNamespace(prefix, this.currentContext.nameSpaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writeStartDocument(null, null);
    }

    @Override
    public void writeStartDocument(String encoding) throws XMLStreamException {
        this.writeStartDocument(null, encoding);
    }

    @Override
    public void writeStartDocument(String version, String encoding) throws XMLStreamException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writeCharacters(text.toCharArray(), 0, text.length());
    }

    @Override
    public void writeCharacters(char[] arg0, int arg1, int arg2) throws XMLStreamException {
        this.flushStartElement();
        try {
            this.contentHandler.characters(arg0, arg1, arg2);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.currentContext.prefix;
    }

    @Override
    public void setPrefix(String prefix, String namespaceURI) throws XMLStreamException {
        this.currentContext.prefix = prefix;
        this.currentContext.nameSpaceURI = namespaceURI;
    }

    @Override
    public void setDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.currentContext.nameSpaceURI = namespaceURI;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    class Context {
        String localName;
        String prefix;
        String nameSpaceURI;
        AttributesImpl attributes = new AttributesImpl();
        Context parentContext;
        ArrayList namespaces;
        boolean startEventFlushed;

        public Context(Context parentContext) {
            this.parentContext = parentContext;
            this.namespaces = new ArrayList();
        }

        public void addNamespace(String prefix, String namespaceURI) {
            this.namespaces.add(new String[]{prefix, namespaceURI});
        }
    }
}

