/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.utils.IMultiBuffer;
import com.cognos.portal.utils.MultiBufferOutputStream;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import com.cognos.portal.xml.stream.XMLTransactionalStreamWriter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLTransactionalStreamWriterImpl
implements XMLTransactionalStreamWriter {
    private static final int INITIAL_STREAMS_SIZE = 4;
    private XMLStreamWriter[] writers;
    private int[] bufferIDs;
    private MultiBufferOutputStream out;
    private int active;

    public XMLTransactionalStreamWriterImpl(MultiBufferOutputStream out) throws XMLStreamException {
        this.out = out;
        this.begin();
    }

    public MultiBufferOutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void begin() throws XMLStreamException {
        if (this.writers == null) {
            this.writers = new XMLStreamWriter[4];
            this.bufferIDs = new int[4];
            this.active = 0;
            this.writers[this.active] = XMLStreamFactory.createXMLStreamWriter(this.out);
            this.bufferIDs[this.active] = this.out.getActiveBuffer();
        } else {
            this.writers[this.active].writeCharacters("");
            this.flush();
            ++this.active;
            if (this.writers.length == this.active) {
                XMLStreamWriter[] newwriters = new XMLStreamWriter[this.writers.length * this.writers.length];
                System.arraycopy(this.writers, 0, newwriters, 0, this.writers.length);
                this.writers = newwriters;
                int[] newbuffersIDs = new int[this.bufferIDs.length * this.bufferIDs.length];
                System.arraycopy(this.bufferIDs, 0, newbuffersIDs, 0, this.bufferIDs.length);
                this.bufferIDs = newbuffersIDs;
            }
            this.bufferIDs[this.active] = this.out.createBuffer(32);
            this.writers[this.active] = XMLStreamFactory.createXMLStreamWriter(this.out);
            this.writers[this.active].setNamespaceContext(this.writers[this.active - 1].getNamespaceContext());
        }
    }

    @Override
    public void commit() throws XMLStreamException {
        if (this.active > 0) {
            this.writers[this.active].flush();
            this.writers[this.active].close();
            this.writers[this.active] = null;
            this.bufferIDs[this.active] = 0;
            this.out.createBuffer(32);
            --this.active;
        }
    }

    @Override
    public void rollback() throws XMLStreamException {
        this.writers[this.active] = null;
        this.out.discardBuffers(this.bufferIDs[this.active], this.out.getActiveBuffer());
        --this.active;
    }

    @Override
    public IMultiBuffer getInternalBuffers() {
        return this.out;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writers[this.active].writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName) throws XMLStreamException {
        this.writers[this.active].writeStartElement(prefix, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writers[this.active].writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writers[this.active].writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writers[this.active].writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String namespaceURI, String localName) throws XMLStreamException {
        this.writers[this.active].writeEmptyElement(prefix, namespaceURI, localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writers[this.active].writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writers[this.active].writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writers[this.active].close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writers[this.active].flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writers[this.active].writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writers[this.active].writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writers[this.active].writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writers[this.active].writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writers[this.active].writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writers[this.active].writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writers[this.active].writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writers[this.active].writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writers[this.active].writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writers[this.active].writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writers[this.active].writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writers[this.active].writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writers[this.active].writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writers[this.active].writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writers[this.active].writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writers[this.active].writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writers[this.active].getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writers[this.active].setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writers[this.active].setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writers[this.active].setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writers[this.active].getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writers[this.active].getProperty(name);
    }

    @Override
    public XMLTransactionalStreamWriter spawnNewWriter() throws XMLStreamException {
        return new XMLTransactionalStreamWriterImpl(this.out.spawnMultiBuffer());
    }
}

