/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.portal.xml.stream;

import com.cognos.portal.xml.stream.IXmlFilter;
import com.cognos.portal.xml.stream.XMLStreamFactory;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XmlCopyFilter
implements IXmlFilter,
StreamFilter {
    protected StringWriter sw = new StringWriter();
    protected XMLStreamWriter writer = XMLStreamFactory.createXMLStreamWriter(this.sw);
    protected XMLStreamReader filteredReader = null;
    protected boolean isError = false;

    public XmlCopyFilter(String xml) throws XMLStreamException {
        XMLStreamReader reader = XMLStreamFactory.createXMLStreamReader(new StringReader(xml));
        this.filteredReader = XMLStreamFactory.createFilteredReader(reader, this);
    }

    public void process() throws XMLStreamException {
        while (this.filteredReader.hasNext()) {
            this.filteredReader.next();
        }
    }

    public String getResult() throws XMLStreamException {
        this.writer.flush();
        this.writer.close();
        return this.sw.getBuffer().toString();
    }

    public boolean isError() {
        return this.isError;
    }

    @Override
    public boolean accept(XMLStreamReader reader) {
        switch (reader.getEventType()) {
            case 7: {
                this.handleStartDocument(reader);
                break;
            }
            case 8: {
                this.handleEndDocument(reader);
                break;
            }
            case 1: {
                this.handleStartElement(reader);
                break;
            }
            case 2: {
                this.handleEndElement(reader);
                break;
            }
            case 4: {
                this.handleCharacters(reader);
                break;
            }
            case 12: {
                this.handleCdata(reader);
                break;
            }
            case 6: {
                this.handleSpace(reader);
                break;
            }
            case 10: {
                this.handleAttribute(reader);
                break;
            }
            case 13: {
                this.handleNamespace(reader);
                break;
            }
            case 5: {
                this.handleComment(reader);
                break;
            }
            case 3: {
                this.handleProcessingInstruction(reader);
                break;
            }
            case 9: {
                this.handleEntityReference(reader);
                break;
            }
            case 11: {
                this.handleDtd(reader);
                break;
            }
        }
        return true;
    }

    @Override
    public void handleStartDocument(XMLStreamReader reader) {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleEndDocument(XMLStreamReader reader) {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleStartElement(XMLStreamReader reader) {
        try {
            this.copyElementStartTag(reader);
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleEndElement(XMLStreamReader reader) {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleCharacters(XMLStreamReader reader) {
        try {
            this.writer.writeCharacters(reader.getText());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleCdata(XMLStreamReader reader) {
        try {
            this.writer.writeCData(reader.getText());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleSpace(XMLStreamReader reader) {
        try {
            this.writer.writeCharacters(reader.getText());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleAttribute(XMLStreamReader reader) {
    }

    @Override
    public void handleNamespace(XMLStreamReader reader) {
    }

    @Override
    public void handleComment(XMLStreamReader reader) {
        try {
            this.writer.writeComment(reader.getText());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleProcessingInstruction(XMLStreamReader reader) {
        try {
            this.writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleEntityReference(XMLStreamReader reader) {
        try {
            this.writer.writeEntityRef(reader.getText());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    @Override
    public void handleDtd(XMLStreamReader reader) {
        try {
            this.writer.writeDTD(reader.getText());
        }
        catch (XMLStreamException e) {
            this.isError = true;
            e.printStackTrace();
        }
    }

    protected void copyElementStartTag(XMLStreamReader reader) throws XMLStreamException {
        String prefix = reader.getPrefix();
        String namespace = reader.getNamespaceURI();
        this.writer.writeStartElement(prefix, reader.getLocalName(), namespace);
        int namspaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namspaceCount; ++i) {
            String nsPrefix = reader.getNamespacePrefix(i);
            String nsURI = reader.getNamespaceURI(i);
            if (nsPrefix != null) {
                this.writer.setPrefix(nsPrefix, nsURI);
            }
            this.writer.writeNamespace(nsPrefix, nsURI);
        }
        if (prefix != null && namespace != null && this.writer.getNamespaceContext().getNamespaceURI(prefix) == null) {
            this.writer.setPrefix(prefix, namespace);
            this.writer.writeNamespace(prefix, namespace);
        }
        int attrCount = reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String attPrefix = reader.getAttributePrefix(i);
            String attNamespace = reader.getAttributeNamespace(i);
            if (attPrefix != null && this.writer.getNamespaceContext().getNamespaceURI(attPrefix) == null) {
                this.writer.setPrefix(attPrefix, attNamespace);
                this.writer.writeNamespace(attPrefix, attNamespace);
            }
            this.writer.writeAttribute(attPrefix, attNamespace, reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }
}

