<?xml version="1.0" encoding="UTF-8"?>
<!--
    IBM Confidential

    OCO Source Materials

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.
-->
<!--
/*
 * $Header: //cps4/blacksea/main/src/java/src/com/cognos/portal/fragment/producer/xslt/fragment.xslt#3 $
 * $Change: 14470 $
 * $DateTime: 2006/06/13 10:43:22 $
 *
 * Copyright (C) 2008 Cognos ULC, an IBM Company.
 * 3755 Riverside Drive, Ottawa, Ontario, K1G 4K9, Canada
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of Cognos
 * Incorporated ("Confidential Information").  You shall not disclose such
 * Confidential Information and shall use it only in accordance with the
 * terms of the license agreement you entered into with Cognos.
 */
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:impl="http://developer.cognos.com/fragments/implementation/1/" xmlns:frag="http://developer.cognos.com/fragments/1/" xmlns:p="http://www.w3.org/2002/02/xml-pipeline" xmlns:data="urn:data" exclude-result-prefixes="data frag impl">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="no"/>
	<!--
	decision rules
	-->
	<data:data>
		<pipeline-params>
			<p:param name="fragment"/>
			<p:param name="params"/>
			<p:param name="controllerParams"/>
			<p:param name="customs"/>
			<p:param name="transients"/>
			<p:param name="interactions"/>
			<p:param name="events"/>
			<p:param name="state"/>
			<p:param name="target" select="'fragmentResponse'"/>
		</pipeline-params>
		<!--
			This is a list of outputs that can be initially added to the pipeline before it is executed.
			In normal circumstances, this stylesheet will filter out all inputs that are not defined as output in some other process.
			But if the output is here, a process can define an input without having the output, assuming that before running the pipeline, the caller will set the initial output.
		-->
		<pipeline-initial-outputs>

		</pipeline-initial-outputs>
		<!--
			This is a list of outputs that can be overriden by the implementation file.  
			This mean if a process P generate an output A, and in the implementation file we define that stage S generates the same output A, 
			the final pipeline will have output A associated with process S and not P.
		-->
		<pipeline-override-outputs>
			<p:output label="markupValidate"/>
		</pipeline-override-outputs>
		<!--
			This is a list of all common paramteres that are used by all processes.
		-->
		<common-process-params>
			<p:param name="fragment" select="$fragment"/>
			<p:param name="customs" select="$customs"/>
			<p:param name="transients" select="$transients"/>
			<p:param name="controllerParams" select="$controllerParams"/>
			<p:param name="state" select="$state"/>
		</common-process-params>
		<!--
			This is a list of input/output that are passed throughout all stages. 
			This stylsheet will make sure to resolve the proper input in case a stage is not defined.
		-->
		<pass-through-inputs>
			<input name="dep">
				<p:output label="initdep"/>
				<p:output label="interactiondep"/>
				<p:output label="eventdep"/>
				<p:output label="logicdep"/>
				<p:output label="renderdep"/>
			</input>
		</pass-through-inputs>
		<processor name="xts" definition="com.cognos.portal.fragment.producer.process.XTSProcess">
		</processor>
		<processor name="xslt" definition="com.cognos.portal.fragment.producer.process.XSLTStageProcess">
			<!-- we need the message to do localization -->
			<p:param name="message" select="$message"/>
		</processor>
		<stage name="init" definition="com.cognos.portal.fragment.producer.process.SimpleXMLProcess">
			<p:param name="interactions" select="$interactions"/>
			<p:output name="init" label="initResponse"/>
			<p:output name="dep" label="initdep"/>
			<p:error label="errorOutput"/>
		</stage>
		<stage name="stage" definition="com.cognos.portal.fragment.producer.process.SimpleXMLProcess">
			<p:error label="errorOutput"/>
		</stage>
		<stage name="interaction" definition="com.cognos.portal.fragment.producer.process.SimpleXMLProcess">
			<p:param name="interactions" select="$interactions"/>
			<p:input name="init" label="initResponse"/>
			<p:input name="dep" label="initdep"/>
			<p:output name="dep" label="interactiondep"/>
			<p:error label="errorOutput"/>
		</stage>
		<stage name="event" definition="com.cognos.portal.fragment.producer.process.SimpleXMLProcess">
			<p:param name="events" select="$events"/>
			<p:input name="init" label="initResponse"/>
			<p:input name="dep" label="interactiondep"/>
			<p:output name="dep" label="eventdep"/>
			<p:error label="errorOutput"/>
		</stage>
		<stage name="logic" definition="com.cognos.portal.fragment.producer.process.SimpleXMLProcess">
			<p:input name="init" label="initResponse"/>
			<p:input name="dep" label="eventdep"/>
			<p:output name="dep" label="logicdep"/>
			<p:output name="logic" label="logicResponse"/>
			<p:error label="errorOutput"/>
		</stage>
		<stage name="render" definition="com.cognos.portal.fragment.producer.process.DefaultRenderProcess">
			<p:param name="message" select="$message"/>
			<p:input name="init" label="initResponse"/>
			<p:input name="logic" label="logicResponse"/>
			<p:input name="dep" label="logicdep"/>
			<p:output name="dep" label="renderdep"/>
			<p:error label="errorOutput"/>
		</stage>
		<!-- additional processes -->
		<stage name="fragment" definition="com.cognos.portal.fragment.producer.process.FragmentXMLProcess">
			<p:param name="customs" select="$customs"/>
			<p:input name="dep" label="renderdep"/>
			<p:output name="fragmentXML" label="fragmentResponse"/>
			<p:error label="errorOutput"/>
		</stage>
		<!-- handle frag-directive=meta-only -->
		<stage name="fragment_metaonly" definition="com.cognos.portal.fragment.producer.process.FragmentXMLProcess">
			<p:output name="fragmentXML" label="fragmentResponse_metaonly"/>
			<p:error label="errorOutput"/>
		</stage>
		<stage name="error" definition="com.cognos.portal.fragment.producer.process.XSLTProcess">
			<p:output name="output" label="errorOutput"/>
		</stage>
		<impl:fragment/>
		<impl:fragment_metaonly/>
		<impl:error>
			<impl:param name="stylesheet" select="'/error/error.xslt'"/>
			<impl:param name="error"/>
		</impl:error>
	</data:data>
	<!-- data variable holds decision rules -->
	<xsl:variable name="data" select="document('')/xsl:stylesheet/data:data"/>
	<xsl:variable name="impl" select="/impl:implementation/impl:* | $data/impl:*"/>
	<xsl:variable name="complex-meta-data" select="/impl:implementation/@complex-meta-data='true'"/>
	<!-- let's go! -->
	<xsl:template match="/">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="impl:implementation">
		<xsl:element name="{local-name()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates select="impl:*"/>
			<p:pipeline>
				<xsl:choose>
					<xsl:when test="not(p:pipeline)">
						<p:param name="message">
							<xsl:if test="/impl:implementation/impl:message/@source">
								<xsl:attribute name="select">'<xsl:value-of select="/impl:implementation/impl:message/@source"/>'</xsl:attribute>
							</xsl:if>
						</p:param>
						<xsl:apply-templates select="$data/pipeline-params/p:param"/>
						<xsl:apply-templates select="$impl/impl:param" mode="pipeline"/>
						<xsl:apply-templates select="$impl[local-name() != 'fragment_metaonly' or (local-name() = 'fragment_metaonly' and not($complex-meta-data))]" mode="processdef"/>
						<xsl:apply-templates select="$impl[local-name() != 'fragment_metaonly' or (local-name() = 'fragment_metaonly' and not($complex-meta-data))]" mode="process"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:copy-of select="p:pipeline/*"/>
						<xsl:apply-templates select="$impl[local-name() = 'fragment_metaonly' and not($complex-meta-data)]" mode="processdef"/>
						<xsl:apply-templates select="$impl[local-name() = 'fragment_metaonly' and not($complex-meta-data)]" mode="process"/>
					</xsl:otherwise>
				</xsl:choose>
			</p:pipeline>
		</xsl:element>
	</xsl:template>
	<!--
	processdef mode
	-->
	<xsl:template match="impl:init|impl:interaction|impl:logic|impl:event|impl:render|impl:fragment|impl:fragment_metaonly|impl:error|impl:stage" mode="processdef">
		<xsl:variable name="name">
			<xsl:choose>
				<xsl:when test="local-name() = 'stage'">
					<xsl:value-of select="local-name()"/>_<xsl:value-of select="generate-id()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="local-name()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<p:processdef name="{$name}.def">
			<xsl:choose>
				<xsl:when test="current()/@processor = $data/processor/@name">
					<xsl:attribute name="definition"><xsl:value-of select="$data/processor[@name=current()/@processor]/@definition"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@source">
							<xsl:attribute name="definition"><xsl:value-of select="@source"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="definition"><xsl:value-of select="$data/stage[@name=$name]/@definition"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</p:processdef>
	</xsl:template>
	<xsl:template match="text()" mode="processdef"/>
	<!--
	process mode
	-->
	<xsl:template match="impl:init|impl:interaction|impl:logic|impl:event|impl:render|impl:fragment|impl:fragment_metaonly|impl:error|impl:stage" mode="process">
		<xsl:variable name="stage" select="$data/stage[@name=local-name(current())]"/>
		<xsl:variable name="stageType">
			<xsl:choose>
				<xsl:when test="local-name() = 'stage'">
					<xsl:value-of select="$stage/@name"/>_<xsl:value-of select="generate-id()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$stage/@name"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>.def</xsl:text>
		</xsl:variable>
		<xsl:variable name="stageId">
			<xsl:choose>
				<xsl:when test="local-name() = 'stage'">
					<xsl:value-of select="$stage/@name"/>_<xsl:value-of select="generate-id()"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$stage/@name"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<p:process id="{$stageId}" type="{$stageType}">
			<xsl:apply-templates select="$data/common-process-params/p:param[not(@name= current()/impl:param/@name)]"/>
			<xsl:apply-templates select="impl:param" mode="process"/>
			<xsl:choose>
				<xsl:when test="@processor='xts'">
					<p:param name="m" select="'{@source}'"/>
				</xsl:when>
				<xsl:when test="@processor='xslt'">
					<p:param name="stylesheet" select="'{@source}'"/>
				</xsl:when>
			</xsl:choose>
			<xsl:apply-templates select="$data/processor[@name=current()/@processor]/p:param[not(@name= current()/impl:param/@name)]"/>
			<xsl:apply-templates select="$stage/p:param[not(@name= current()/impl:param/@name)]"/>
			<!-- Add inline xml as a config input -->
			<xsl:if test="impl:*[not(self::impl:param | self::impl:input | self::impl:output)]">
				<p:input name="{$stage/@name}.config">
					<config>
						<xsl:apply-templates select="impl:*[not(self::impl:param | self::impl:input | self::impl:output)]"/>
					</config>
				</p:input>
			</xsl:if>
			<!-- add inputs defined in the data section that have an output with the same label-->
			<xsl:for-each select="$impl">
				<xsl:variable name="outputs" select="$data/stage[@name=local-name(current())]/p:output"/>
				<xsl:apply-templates select="$stage/p:input[@label=$outputs/@label]"/>
			</xsl:for-each>
			<!-- Add inputs defined in the data section that are using an initial output -->
			<xsl:apply-templates select="$stage/p:input[(@label = $data/pipeline-initial-outputs/p:output/@label)]"/>
			<!-- Check the pass-through inputs, if we don't have the proper output, try to figure out the closest match-->
			<xsl:apply-templates select="$stage/p:input[(@name = $data/pass-through-inputs/input/@name)]" mode="pass-through"/>
			<!-- Add additional inputs defined in the stage itself -->
			<xsl:apply-templates select="impl:input" mode="process"/>
			<!-- Add outputs defined in the data section, and filter out all outputs that are marked as override outputs and are explicitly defined in the implementation file-->
			<xsl:variable name="override-implementation-defined-outputs" select="/impl:implementation/impl:*/impl:output[@name = $data/pipeline-override-outputs/p:output/@label]"/>
			<xsl:apply-templates select="$stage/p:output[not(@label = $override-implementation-defined-outputs/@name)]"/>
			<!-- Add additional outputs defined in the stage itself -->
			<xsl:apply-templates select="impl:output" mode="process"/>
			<xsl:apply-templates select="$stage/p:error"/>
		</p:process>
	</xsl:template>
	<xsl:template match="impl:input" mode="process">
		<p:input name="{@name}">
			<xsl:choose>
				<xsl:when test="child::node()">
					<xsl:apply-templates select="child::node()"/>
				</xsl:when>
				<xsl:when test="@label">
					<xsl:attribute name="label"><xsl:value-of select="@label"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="label"><xsl:value-of select="@name"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</p:input>
	</xsl:template>
	<xsl:template match="impl:output" mode="process">
		<p:output name="{@name}">
			<xsl:choose>
				<xsl:when test="@label">
					<xsl:attribute name="label"><xsl:value-of select="@label"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="label"><xsl:value-of select="@name"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</p:output>
	</xsl:template>
	<xsl:template match="impl:param" mode="process">
		<p:param name="{@name}">
			<xsl:attribute name="select"><xsl:choose><xsl:when test="@select"><xsl:value-of select="@select"/></xsl:when><xsl:otherwise>$<xsl:value-of select="@name"/></xsl:otherwise></xsl:choose></xsl:attribute>
		</p:param>
	</xsl:template>
	<!--
		Make sure all params that are declared at the process level are also declared at the pipeline level. 
		If a process declares a new param that is not defined in the pipeline we will add it to the pipeline
	-->
	<xsl:template match="impl:param" mode="pipeline">
		<xsl:variable name="name">
			<xsl:call-template name="get-pipeline-param-name">
				<xsl:with-param name="param" select="."/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="is-declared">
			<xsl:if test="$name != '' ">
				<xsl:choose>
					<xsl:when test="$data/pipeline-params/p:param[@name=$name]">true</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="preceding::impl:param">
							<xsl:variable name="preceding-name">
								<xsl:call-template name="get-pipeline-param-name">
									<xsl:with-param name="param" select="."/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="$name = $preceding-name">true</xsl:if>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:variable>
		<xsl:if test="$name != '' and not (contains($is-declared,'true')) ">
			<p:param name="{$name}"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="get-pipeline-param-name">
		<xsl:param name="param"/>
		<xsl:choose>
			<xsl:when test="not($param/@select)">
				<xsl:value-of select="$param/@name"/>
			</xsl:when>
			<xsl:when test="starts-with($param/@select,'$')">
				<xsl:value-of select="substring-after($param/@select,'$')"/>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="text()" mode="process"/>
	<!--
	standard copy, removing any extra namespaces
	-->
	<xsl:template match="*">
		<xsl:element name="{name()}" namespace="{namespace-uri()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!--
	translate impl:* to empty namespace
	-->
	<xsl:template match="impl:*">
		<xsl:element name="{local-name()}">
			<xsl:copy-of select="@*|namespace::*[. != 'http://developer.cognos.com/fragments/implementation/1/']"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!-- exclude these tags b/c they are processed in two stages -->
	<xsl:template match="impl:init|impl:interaction|impl:logic|impl:event|impl:render|impl:fragment|impl:fragment_metaonly|impl:error|impl:stage"/>
	<!--
	translate frag:* to empty namespace
	-->
	<xsl:template match="frag:*">
		<xsl:element name="{local-name()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="p:input" mode="pass-through">
		<!-- Get a list of all available outputs -->
		<xsl:variable name="outputs">
			<xsl:copy-of select="$data/pipeline-initial-outputs/p:output"/>
			<xsl:for-each select="$impl">
				<xsl:copy-of select="$data/stage[@name=local-name(current())]/p:output"/>
				<xsl:apply-templates select="impl:output" mode="process"/>
			</xsl:for-each>
		</xsl:variable>
		<!-- 
			If the current input does not have an output, we need to find the next available output
			This is driven by the list of output in $data.pass-through-inputs
		-->
		<xsl:if test="not($outputs/p:output[@label = current()/@label])">
			<xsl:variable name="label" select="$data/pass-through-inputs/input[@name=current()/@name]/p:output[@label=current()/@label]/preceding-sibling::p:output[@label=$outputs/p:output/@label][position()=1]/@label"/>
			<xsl:if test="$label">
				<xsl:element name="p:input" namespace="http://www.w3.org/2002/02/xml-pipeline">
					<xsl:copy-of select="@name"/>
					<xsl:attribute name="label"><xsl:value-of select="$label"/></xsl:attribute>
				</xsl:element>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!--
	copy p:* as is, removing any extra namespaces
	-->
	<xsl:template match="p:*">
		<xsl:element name="p:{local-name()}" namespace="http://www.w3.org/2002/02/xml-pipeline">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
