<?xml version="1.0" encoding="UTF-8"?>
<!--
    Licensed Materials - Property of IBM

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!--
Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt" exclude-result-prefixes="xtsext">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="no"/>
	
	<xsl:param name="skinfile"/>
	<xsl:param name="overrides_path"/>
	<xsl:param name="comments" select="true()"/>
	<xsl:param name="debug" select="false()"/>
	<xsl:param name="webcontent"/>
	<xsl:param name="cgi"/>
	<xsl:param name="skin"/>
	
	<xsl:preserve-space elements="set"/>

	<xsl:variable name="skindoc">
		<xsl:if test="string($skinfile) != ''">
			<xsl:copy-of select="document($skinfile)"/>
		</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="overrides_doc">
		<xsl:if test="string($overrides_path) !=''">
			<xsl:copy-of select="document($overrides_path)"/>
		</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="colors" select="$skindoc/skin/colors/color"/>
	<xsl:variable name="values" select="$skindoc/skin/values/value"/>
	<xsl:variable name="classes" select="$overrides_doc/cssskin/class"/>
	<xsl:variable name="palette" select="$skindoc/skin/palette/color"/>
	<xsl:variable name="images" select="$skindoc/skin/images/image"/>

	<xsl:template match="/">
		<xsl:text>/*&#10;   (C) Copyright IBM Corp. 2005, 2011.&#10;   Licensed Material - Property of IBM Corp. IBM, the IBM logo, and Cognos are trademarks of IBM Corp., registered in many jurisdictions worldwide.&#10;*/&#10;</xsl:text>
		<xsl:text>&#10;/*****************************************************************************************&#10;</xsl:text>
		<xsl:text>  This is a generated file. Any changes you make to it will not be upgraded.</xsl:text>
		<xsl:text>&#10;/*****************************************************************************************/&#10;</xsl:text>            
		<xsl:if test="$debug='true'">
			<xsl:text>/*&#10;Parameters:</xsl:text>
			<xsl:text>&#10; skin:       </xsl:text>
			<xsl:value-of select="$skin"/>
			<xsl:text>&#10; debug:      </xsl:text>
			<xsl:value-of select="$debug"/>
			<xsl:text>&#10; comments:   </xsl:text>
			<xsl:value-of select="$comments"/>
			<xsl:text>&#10; webcontent: </xsl:text>
			<xsl:value-of select="$webcontent"/>
			<xsl:text>&#10; cgi:        </xsl:text>
			<xsl:value-of select="$cgi"/>
			<xsl:text>&#10;*/&#10;</xsl:text>
		</xsl:if>
		<xsl:variable name="excludes" select="/css/class/@name"/>
		<xsl:apply-templates select="/css/import | /css/class | /css/comment"/>	
		<xsl:if test="$debug='true'">
			<xsl:text>/* new skin-specific classes */&#10;</xsl:text>
		</xsl:if>
		<xsl:apply-templates select="$classes[not(@name=$excludes)]"/>
	</xsl:template>

	<xsl:template match="comment">
		<xsl:if test="$comments='true'">
			<xsl:text>&#10;/* </xsl:text>
			<xsl:value-of select="."/>
			<xsl:text> */&#10;</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="import">
		<xsl:text>@import url(</xsl:text>
		<xsl:value-of select="."/>
		<xsl:text>);&#10;</xsl:text>
	</xsl:template>

	<xsl:template match="class">
		<xsl:if test="$debug='true'">
			<xsl:call-template name="xpath"/>
			<xsl:text>&#10;</xsl:text>
		</xsl:if>
		<xsl:value-of select="@name"/>
		<xsl:if test="@comment and $comments='true'">
			<xsl:text> /* </xsl:text>
			<xsl:value-of select="@comment"/>
			<xsl:text> */</xsl:text>
		</xsl:if>
		<xsl:text> {&#10;</xsl:text>
		<xsl:variable name="redefines" select="$classes[@name=current()/@name]"/>
		<xsl:choose>
			<xsl:when test="$redefines">
				<xsl:call-template name="gen-attributes">
					<xsl:with-param name="adds" select="$redefines/set"/>
					<xsl:with-param name="removes" select="$redefines/remove"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="gen-attributes"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>}&#10;</xsl:text>
	</xsl:template>

	<xsl:template name="gen-attributes">
		<xsl:param name="tag" select="."/>
		<xsl:param name="adds" select=".[false()]"/>
		<xsl:param name="removes" select=".[false()]"/>

		<xsl:variable name="uses" select="concat(' ', @uses, ' ')"/>
		<xsl:variable name="sets" select="/css/type[contains($uses, concat(' ',@name,' '))]/set | $tag/set"/>
		<xsl:variable name="list" select="$sets[not(@name=$adds/@name or @name=$removes/@name)]"/>
		<xsl:apply-templates select="$list"/>
		<xsl:apply-templates select="$adds"/>
	</xsl:template>

	<xsl:template match="set">
		<xsl:text>&#9;</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>: </xsl:text>
		<xsl:apply-templates mode="attribute"/>
		<xsl:text>;</xsl:text>
		<xsl:if test="$debug='true'">
			<xsl:text>&#32;</xsl:text>
			<xsl:call-template name="xpath"/>
		</xsl:if>
		<xsl:text>&#10;</xsl:text>
	</xsl:template>

	<xsl:template match="remove"/>
	
	<xsl:template match="color" mode="attribute">
		<xsl:variable name="color" select="$colors[@name=current()/@name]"/>
		<xsl:choose>
			<xsl:when test="not($color)">
				<xsl:text>/* MISSING: </xsl:text>
				<xsl:value-of select="@name"/>
				<xsl:text> */ red</xsl:text>
			</xsl:when>
			<xsl:when test="$color/@paletteColor">
				<xsl:value-of select="$palette[@name=$color/@paletteColor]"/>
			</xsl:when>
			<xsl:when test="$color/@baseColor">
				<xsl:apply-templates select="$colors[@name=$color/@baseColor]" mode="attribute"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$color"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="value" mode="attribute">
		<xsl:variable name="value" select="$values[@name=current()/@name]"/>
		<xsl:choose>
			<xsl:when test="not($value)">
				<xsl:text>/* MISSING VALUE: </xsl:text>
				<xsl:value-of select="@name"/>
				<xsl:text> */</xsl:text>
			</xsl:when>
			<xsl:when test="$value/@baseValue">
				<xsl:apply-templates select="$values[@name=$value/@baseValue]" mode="attribute"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
		<xsl:template match="image" mode="attribute">
		<xsl:variable name="image" select="$images[@name=current()/@name]"/>
		<xsl:choose>
			<xsl:when test="not($image)">
				<xsl:text>/* MISSING: </xsl:text>
				<xsl:value-of select="@name"/>
				<xsl:text> */ none</xsl:text>
			</xsl:when>
			<xsl:when test="$image=''">
				<xsl:text>none</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="imagePath" select="$images[@name=current()/@name]"/>
				<xsl:variable name="webmacro" select="'$WEB$'"/>
				<xsl:variable name="webdir" select="'../../..'"/>	
				<xsl:variable name="skinmacro" select="'$WEB$/skins/$SKIN$'"/>
				<xsl:variable name="skindir" select="'..'"/>
				<xsl:variable name="updatedText" select="xtsext:replace(string($imagePath), string($skinmacro), string($skindir))"/>
				<xsl:value-of select="xtsext:replace(string($updatedText), string($webmacro), string($webdir))"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="gen-text" match="text()" mode="attribute">
		<xsl:param name="text" select="."/>
		<xsl:variable name="webmacro" select="'$WEB$'"/>
		<xsl:variable name="webdir" select="'../../..'"/>	
		<xsl:variable name="skinmacro" select="'$WEB$/skins/$SKIN$'"/>
		<xsl:variable name="skindir" select="'..'"/>
		<xsl:variable name="updatedText" select="xtsext:replace(string($text), string($skinmacro), string($skindir))"/>
		<xsl:value-of select="xtsext:replace(string($updatedText), string($webmacro), string($webdir))"/> 

	</xsl:template>
	
	<xsl:template name="xpath">
		<xsl:text>/* xpath: </xsl:text>
		<xsl:for-each select="ancestor-or-self::node()[name()!='']">
			<xsl:text>/</xsl:text>
			<xsl:value-of select="name()"/>
			<xsl:text>[</xsl:text>
			<xsl:value-of select="count(preceding-sibling::*[name()=name(current())]) + 1"/>
			<xsl:text>]</xsl:text>
		</xsl:for-each>
		<xsl:text> */</xsl:text>
	</xsl:template>

</xsl:stylesheet>
