<?xml version="1.0" encoding="UTF-8"?>
<!--
    Licensed Materials - Property of IBM

    IBM Cognos Products: cpscrn


    (C) Copyright IBM Corp. 2005, 2011

    US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->
<!--
Copyright (C) 2008 Cognos ULC, an IBM Company. All rights reserved.
Cognos (R) is a trademark of Cognos ULC, (formerly Cognos Incorporated).
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xtsext="xalan://com.cognos.xts.ext.XTSExt" exclude-result-prefixes="xtsext">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="no"/>
	
	<xsl:param name="skinfile"/>
	<xsl:param name="overrides_path"/>
	<xsl:param name="comments" select="true()"/>
	<xsl:param name="debug" select="false()"/>
	<xsl:param name="webcontent"/>
	<xsl:param name="cgi"/>
	<xsl:param name="skin"/>
	
	<xsl:preserve-space elements="set"/>

	<xsl:variable name="skindoc">
		<xsl:if test="string($skinfile) != ''">
			<xsl:copy-of select="document($skinfile)"/>
		</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="classWithVariable">
		<xsl:copy-of select="/css/class[.//color] | /css/class[.//value] | /css/class[.//image]"/>
	</xsl:variable>
	
	
	<xsl:variable name="overrides_doc">
		<xsl:if test="string($overrides_path) !=''">
			<xsl:copy-of select="document($overrides_path)"/>
		</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="classes" select="$overrides_doc/cssskin/class"/>
	
	<xsl:variable name="images" select="$skindoc/skin/images/image"/>

	<xsl:template match="/">
		<xsl:text>/*&#10;   (C) Copyright IBM Corp. 2005, 2011.&#10;   Licensed Material - Property of IBM Corp. IBM, the IBM logo, and Cognos are trademarks of IBM Corp., registered in many jurisdictions worldwide.&#10;*/&#10;</xsl:text>
		<xsl:text>&#10;/*****************************************************************************************&#10;</xsl:text>
		<xsl:text>  This is a generated file. Any changes you make to it will not be upgraded.</xsl:text>
		<xsl:text>&#10;/*****************************************************************************************/&#10;</xsl:text>
		<xsl:variable name="excludes" select="/css/class/@name"/>
		<xsl:text>[</xsl:text>
		<xsl:apply-templates select="$classWithVariable" mode="top"/>
		<xsl:text>&#10;]</xsl:text>
	</xsl:template>

	<xsl:template match="comment"/>
	<xsl:template match="import"/>

	<xsl:template match="class" mode="top">
		<xsl:if test="position()&gt;1">
			<xsl:text>,</xsl:text>
		</xsl:if>
		<xsl:text>&#10;&#9;{&#10;</xsl:text>
		<xsl:text>&#9;&#9;"selector": "</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>",&#10;</xsl:text>

		<xsl:variable name="redefines" select="$classes[@name=current()/@name]"/>
		<xsl:text>&#9;&#9;"styles": [</xsl:text>
		<xsl:choose>
			<xsl:when test="$redefines">
				<xsl:call-template name="gen-attributes">
					<xsl:with-param name="adds" select="$redefines/set"/>
					<xsl:with-param name="removes" select="$redefines/remove"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="gen-attributes"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>&#10;&#9;&#9;]&#10;&#9;}</xsl:text>
	</xsl:template>
	
	<xsl:template name="gen-attributes">
		<xsl:param name="tag" select="."/>
		<xsl:param name="adds" select=".[false()]"/>
		<xsl:param name="removes" select=".[false()]"/>		
		<xsl:variable name="uses" select="concat(' ', @uses, ' ')"/>
		<xsl:variable name="sets" select="/css/type[contains($uses, concat(' ',@name,' '))]/set | $tag/set"/>
		<xsl:variable name="list" select="$sets[not(@name=$adds/@name or @name=$removes/@name)]"/>
		<xsl:apply-templates select="$list | $adds"/>
	</xsl:template>

	<xsl:template match="set">
		<xsl:if test="position()&gt;1">
			<xsl:text>,</xsl:text>
		</xsl:if>

		<xsl:text>&#10;&#9;&#9;&#9;{</xsl:text>
		<xsl:text>"attribute": "</xsl:text>
		<xsl:value-of select="@name"/>
		<xsl:text>", value:"</xsl:text>		
		<xsl:apply-templates mode="attribute"/>
		<xsl:text>"</xsl:text>
		<xsl:text>, variables:{</xsl:text>
		<xsl:for-each select="color|image|value">
			<xsl:if test="position()&gt;1">
				<xsl:text>,</xsl:text>
			</xsl:if>
			<xsl:text>"</xsl:text>
			<xsl:value-of select="@name"/>
			<xsl:text>":{</xsl:text>
			<xsl:text>parameters:{</xsl:text>
			<xsl:text>path:"</xsl:text>
				<xsl:choose>
					<xsl:when test="local-name() = 'color'">
						<xsl:text>/skin/colors/color[@name='</xsl:text>
						<xsl:value-of select="@name"/>
						<xsl:text>']</xsl:text>
					</xsl:when>
					<xsl:when test="local-name() = 'image'">
						<xsl:text>/skin/images/image[@name='</xsl:text>
						<xsl:value-of select="@name"/>
						<xsl:text>']</xsl:text>
					</xsl:when>
					<xsl:when test="local-name() = 'value'">
						<xsl:text>/skin/values/value[@name='</xsl:text>
						<xsl:value-of select="@name"/>
						<xsl:text>']</xsl:text>
					</xsl:when>
				</xsl:choose>
			<xsl:text>"</xsl:text>
			<xsl:text>}</xsl:text>
			<xsl:text>}</xsl:text>
		</xsl:for-each>
		<xsl:text>}</xsl:text>
		
				
		<xsl:text>}</xsl:text>
		
	</xsl:template>

	<xsl:template match="remove"/>
	
	<xsl:template match="color|value|image" mode="attribute">		
		<xsl:text>#</xsl:text>
		<xsl:value-of select="@name"/>	
		<!--xsl:text>$</xsl:text-->
	</xsl:template>	
	
	<xsl:template name="gen-text" match="text()" mode="attribute">
		<xsl:param name="text" select="."/>
		<xsl:value-of select="."/>
	</xsl:template>

</xsl:stylesheet>