/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobilefirstplatform.serversdk.java.push;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public final class FCM {
    public static final Logger logger = Logger.getLogger(FCM.class.getName());
    private Boolean delayWhileIdle;
    private Integer timeToLive;
    private String collapseKey;
    private JsonNode payload;
    private Boolean sync;
    private String sound;
    private String interactiveCategory;
    private Builder.FCMPriority priority;
    private FCMStyle style;
    private Builder.Visibility visibility;
    private String icon;
    private FCMLights lights;
    private Builder.FCMNotificationType type;
    private String androidTitle;
    private String groupId;

    public final Boolean getDelayWhileIdle() {
        return this.delayWhileIdle;
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final Integer getTimeToLive() {
        return this.timeToLive;
    }

    public final String getCollapseKey() {
        return this.collapseKey;
    }

    @JsonRawValue
    public final JsonNode getPayload() {
        return this.payload;
    }

    public final Boolean getSync() {
        return this.sync;
    }

    public final String getSound() {
        return this.sound;
    }

    public final String getInteractiveCategory() {
        return this.interactiveCategory;
    }

    public final Builder.FCMPriority getPriority() {
        return this.priority;
    }

    public final FCMStyle getStyle() {
        return this.style;
    }

    public final Builder.Visibility getVisibility() {
        return this.visibility;
    }

    public final String getIcon() {
        return this.icon;
    }

    public final FCMLights getLights() {
        return this.lights;
    }

    public final Builder.FCMNotificationType getType() {
        return this.type;
    }

    public final String getAndroidTitle() {
        return this.androidTitle;
    }

    private FCM(Builder builder) {
        this.delayWhileIdle = builder.delayWhileIdle;
        this.timeToLive = builder.timeToLive;
        this.collapseKey = builder.collapseKey;
        this.payload = builder.payload;
        this.sync = builder.sync;
        this.sound = builder.sound;
        this.interactiveCategory = builder.interactiveCategory;
        this.priority = builder.priority;
        this.style = builder.style;
        this.visibility = builder.visibility;
        this.icon = builder.icon;
        this.lights = builder.lights;
        this.type = builder.type;
        this.androidTitle = builder.androidTitle;
        this.groupId = builder.groupId;
    }

    /* synthetic */ FCM(Builder builder, FCM fCM) {
        this(builder);
    }

    public static class Builder {
        private Boolean delayWhileIdle;
        private Integer timeToLive;
        private String collapseKey;
        private JsonNode payload;
        private Boolean sync;
        private String sound;
        private String interactiveCategory;
        private FCMPriority priority;
        private FCMStyle style;
        private Visibility visibility;
        private String icon;
        private FCMLights lights;
        private FCMNotificationType type;
        private String androidTitle;
        private String groupId;

        public final Builder androidTitle(String androidTitle) {
            this.androidTitle = androidTitle;
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Builder delayWhileIdle(Boolean delayWhileIdle) {
            this.delayWhileIdle = delayWhileIdle;
            return this;
        }

        public final Builder timeToLive(Integer timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public final Builder collapseKey(String collapseKey) {
            this.collapseKey = collapseKey;
            return this;
        }

        public final Builder payload(JSONObject payload) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNodePayload = null;
            try {
                if (payload != null) {
                    jsonNodePayload = mapper.readTree(payload.toString());
                }
            }
            catch (JsonProcessingException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.toString(), e);
            }
            this.payload = jsonNodePayload;
            return this;
        }

        public final Builder sync(Boolean sync) {
            this.sync = sync;
            return this;
        }

        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final Builder interactiveCategory(String interactiveCategory) {
            this.interactiveCategory = interactiveCategory;
            return this;
        }

        public final Builder priority(FCMPriority priority) {
            this.priority = priority;
            return this;
        }

        public final Builder style(FCMStyle style) {
            this.style = style;
            return this;
        }

        public final Builder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public final Builder lights(FCMLights lights) {
            this.lights = lights;
            return this;
        }

        public final Builder type(FCMNotificationType type) {
            this.type = type;
            return this;
        }

        public FCM build() {
            return new FCM(this, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum FCMNotificationType {
            DEFAULT,
            SILENT;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum FCMPriority {
            DEFAULT,
            MIN,
            LOW,
            HIGH,
            MAX;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Visibility {
            PUBLIC,
            PRIVATE,
            SECRET;

        }
    }

    public static final class FCMLights {
        private Builder.FCMLED ledArgb;
        private Integer ledOnMs;
        private Integer ledOffMs;

        public Builder.FCMLED getLedArgb() {
            return this.ledArgb;
        }

        public Integer getLedOnMs() {
            return this.ledOnMs;
        }

        public Integer getLedOffMs() {
            return this.ledOffMs;
        }

        private FCMLights(Builder builder) {
            this.ledArgb = builder.ledArgb;
            this.ledOnMs = builder.ledOnMs;
            this.ledOffMs = builder.ledOffMs;
        }

        public static class Builder {
            private FCMLED ledArgb;
            private Integer ledOnMs;
            private Integer ledOffMs;

            public Builder ledArgb(FCMLED ledArgb) {
                this.ledArgb = ledArgb;
                return this;
            }

            public Builder ledOnMs(Integer ledOnMs) {
                this.ledOnMs = ledOnMs;
                return this;
            }

            public Builder ledOffMs(Integer ledOffMs) {
                this.ledOffMs = ledOffMs;
                return this;
            }

            public FCMLights build() {
                return new FCMLights(this);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum FCMLED {
                BLACK,
                DARKGRAY,
                GRAY,
                LIGHTGRAY,
                WHITE,
                RED,
                GREEN,
                BLUE,
                YELLOW,
                CYAN,
                MAGENTA,
                TRANSPARENT;

            }
        }
    }

    public static final class FCMStyle {
        private Builder.FCMStyleTypes type;
        private String url;
        private String title;
        private String text;
        private String[] lines;

        public final Builder.FCMStyleTypes getType() {
            return this.type;
        }

        public final String getUrl() {
            return this.url;
        }

        public final String getTitle() {
            return this.title;
        }

        public final String getText() {
            return this.text;
        }

        public final String[] getLines() {
            return this.lines;
        }

        private FCMStyle(Builder builder) {
            this.type = builder.type;
            this.url = builder.url;
            this.title = builder.title;
            this.text = builder.text;
            this.lines = builder.lines;
        }

        public static class Builder {
            private FCMStyleTypes type;
            private String url;
            private String title;
            private String text;
            private String[] lines;

            public final Builder type(FCMStyleTypes type) {
                this.type = type;
                return this;
            }

            public final Builder url(String url) {
                this.url = url;
                return this;
            }

            public final Builder title(String title) {
                this.title = title;
                return this;
            }

            public final Builder text(String text) {
                this.text = text;
                return this;
            }

            public final Builder lines(String[] lines) {
                this.lines = lines;
                return this;
            }

            public FCMStyle build() {
                return new FCMStyle(this);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum FCMStyleTypes {
                BIGTEXT_NOTIFICATION,
                INBOX_NOTIFICATION,
                PICTURE_NOTIFICATION;

            }
        }
    }
}

