/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.cache;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.cache.IAssociativeModelCache;
import com.ibm.cognos.aurora.api.model.cache.IAssociativeModelFactory;
import com.ibm.cognos.aurora.api.model.cache.IAssociativeModelReservation;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.physical.event.IPhysicalModelWatcher;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.util.IAssociativeGetOrCreateContainer;
import com.ibm.cognos.aurora.core.util.IFactory;
import com.ibm.cognos.aurora.core.util.SafeScheduledThreadPoolExecutor;
import com.ibm.cognos.aurora.core.util.ValueContendedCache;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.cache.AssociativeModelReservation;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AssociativeModelCache
implements IAssociativeModelCache {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls.model.cache");
    public static final long DEFAULT_MAINTENANCE_PERIOD = 5000L;
    public static final long DEFAULT_LINGER_TIME = 300000L;
    private long mLingerTime = 300000L;
    private long mMaintenancePeriod = 5000L;
    private volatile boolean mDisposed = false;
    private final IAssociativeGetOrCreateContainer<Object, AssociativeModelReservation> mReservations = new ValueContendedCache();
    private final List<AssociativeModelReservation> mStaleList = new LinkedList<AssociativeModelReservation>();
    private final Lock mLock = new ReentrantLock();
    private final SafeScheduledThreadPoolExecutor mSafeScheduledThreadPoolExecutor;
    private final boolean mShutdownExecutor;
    private final ScheduledFuture<?> mMaintenanceScheduledFuture;

    public AssociativeModelCache() {
        this(AssociativeModelCache.createSafeScheduledThreadPoolExecutor(), true, 300000L, 5000L);
    }

    public AssociativeModelCache(long lingerTime, long maintenancePeriod) {
        this(AssociativeModelCache.createSafeScheduledThreadPoolExecutor(), true, lingerTime, maintenancePeriod);
    }

    public AssociativeModelCache(SafeScheduledThreadPoolExecutor safeScheduledThreadPoolExecutor, long lingerTime, long maintenancePeriod) {
        this(safeScheduledThreadPoolExecutor, false, lingerTime, maintenancePeriod);
    }

    private AssociativeModelCache(SafeScheduledThreadPoolExecutor safeScheduledThreadPoolExecutor, boolean shutdownExecutor, long lingerTime, long maintenancePeriod) {
        this.mSafeScheduledThreadPoolExecutor = safeScheduledThreadPoolExecutor;
        this.mShutdownExecutor = shutdownExecutor;
        this.mLingerTime = lingerTime;
        long initialDelay = this.mMaintenancePeriod = maintenancePeriod;
        this.mMaintenanceScheduledFuture = this.mSafeScheduledThreadPoolExecutor.scheduleAtFixedRate((Runnable)new MaintenanceTask(), initialDelay, maintenancePeriod, TimeUnit.MILLISECONDS, new SafeScheduledThreadPoolExecutor.IErrorHandler(){

            public void onPreviousRunStillRunning() {
                AssociativeModelCache.this.onMaintenanceTaskTimeOut();
            }
        });
    }

    public long getReservationLingerTime() {
        return this.mLingerTime;
    }

    public void setReservationLingerTime(long lingerTime) {
        this.mLingerTime = lingerTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAssociativeModelReservation reserveModel(final Object key, final IAssociativeModelFactory factory) {
        AssociativeModelReservation reservation;
        PerfLogEvent event;
        block26: {
            block25: {
                if (this.mDisposed) {
                    throw new IllegalStateException("Cache was disposed");
                }
                event = null;
                if (logger.isPerfDebugEnabled()) {
                    event = logger.startPerfDebug(this.getClass().getName(), "reserveModel", "Starting reserve model");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Reserving model for key " + String.valueOf(key), this.getClass().getName() + "::reserveModel()");
                }
                reservation = null;
                try {
                    reservation = (AssociativeModelReservation)this.mReservations.get(key);
                }
                catch (InterruptedException e) {
                    reservation = null;
                    if (logger.isInfoEnabled()) {
                        logger.info("A previous attempt to load the model got interrupted -> retry in this thread. " + e.getLocalizedMessage(), this.getClass().getName() + "::reserveModel()");
                    }
                }
                catch (ExecutionException e) {
                    reservation = null;
                    if (!logger.isInfoEnabled()) break block25;
                    logger.info("A previous attempt to load the model failed. The error could be transient -> retry in this thread. " + e.getLocalizedMessage(), this.getClass().getName() + "::reserveModel()");
                }
            }
            this.mLock.lock();
            try {
                if (null == reservation) break block26;
                AssociativeModelReservation lockedReservation = reservation;
                lockedReservation.lock();
                try {
                    if (reservation.isDisposed()) {
                        boolean removed = this.mReservations.remove(key);
                        reservation = null;
                        if (logger.isInfoEnabled()) {
                            logger.info(String.format("Removed a disposed reservation (key=%s, removed=%b) from cache", key, removed), this.getClass().getName() + "::reserveModel()");
                        }
                    } else if (reservation.isStale()) {
                        boolean removed = this.mReservations.remove(key);
                        this.mStaleList.add(reservation);
                        reservation = null;
                        if (logger.isInfoEnabled()) {
                            logger.info(String.format("Removed a stale reservation (key=%s, removed=%b) from cache", key, removed), this.getClass().getName() + "::reserveModel()");
                        }
                    } else {
                        reservation.reserve();
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Acquired existing reservation (key=%s, id=%h) from cache", key, reservation), this.getClass().getName() + "::reserveModel()");
                        }
                    }
                }
                finally {
                    lockedReservation.unlock();
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
        if (null == reservation) {
            try {
                reservation = (AssociativeModelReservation)this.mReservations.getOrCreate(key, (IFactory)new IFactory<AssociativeModelReservation>(){

                    public AssociativeModelReservation create() throws Exception {
                        IAssociativeModel model = factory.create();
                        AssociativeModelReservation reservation = new AssociativeModelReservation(AssociativeModelCache.this, key, model, AssociativeModelCache.createWatchers(model));
                        reservation.reserve();
                        if (logger.isInfoEnabled()) {
                            logger.info(String.format("Created a new model and reservation (key=%s, id=%h)", key, reservation), this.getClass().getName() + "::reserveModel()");
                        }
                        return reservation;
                    }
                });
            }
            catch (InterruptedException e) {
                throw QLSRuntimeException.wrap(e);
            }
            catch (ExecutionException e) {
                throw QLSRuntimeException.wrap(e.getCause());
            }
        }
        if (event != null) {
            logger.stopPerfDebug(event, "Finished reserving model");
        }
        return reservation;
    }

    void updateWatchers() {
        Collection reservations = this.mReservations.values();
        for (AssociativeModelReservation r : reservations) {
            r.updateWatchers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupReservations() {
        if (this.mDisposed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Running cache maintenance", this.getClass().getName() + "::cleanupReservations()");
        }
        Collection reservations = this.mReservations.values();
        this.mLock.lock();
        try {
            for (AssociativeModelReservation r : reservations) {
                r.lock();
                try {
                    if (r.isDisposed()) {
                        this.mReservations.remove(r.getCacheKey());
                        if (!logger.isInfoEnabled()) continue;
                        logger.info(String.format("Removed a disposed reservation (key=%s, id=%h) from cache", r.getCacheKey(), r), this.getClass().getName() + "::cleanupReservations()");
                        continue;
                    }
                    if (r.isStale()) {
                        this.mReservations.remove(r.getCacheKey());
                        if (logger.isInfoEnabled()) {
                            logger.info(String.format("Removed a stale reservation (key=%s, id=%h) from cache", r.getCacheKey(), r), this.getClass().getName() + "::cleanupReservations()");
                        }
                        if (r.reservationCount() == 0) {
                            r.dispose();
                            continue;
                        }
                        this.mStaleList.add(r);
                        continue;
                    }
                    if (r.reservationCount() != 0 || r.millisSinceLastReservation() <= this.mLingerTime) continue;
                    this.mReservations.remove(r.getCacheKey());
                    r.dispose();
                    if (!logger.isInfoEnabled()) continue;
                    logger.info(String.format("Removed an inactive reservation (key=%s, id=%h) from cache", r.getCacheKey(), r), this.getClass().getName() + "::cleanupReservations()");
                }
                finally {
                    r.unlock();
                }
            }
            Iterator<AssociativeModelReservation> iter = this.mStaleList.iterator();
            while (iter.hasNext()) {
                AssociativeModelReservation r;
                r = iter.next();
                r.lock();
                try {
                    if (r.reservationCount() != 0) continue;
                    iter.remove();
                    r.dispose();
                    if (!logger.isInfoEnabled()) continue;
                    logger.info(String.format("Disposed a stale reservation (key=%s, id=%h) from cache", r.getCacheKey(), r), this.getClass().getName() + "::cleanupReservations()");
                }
                finally {
                    r.unlock();
                }
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAssociativeModelReservation[] getReservations() {
        Collection nonStaleReservations = this.mReservations.values();
        this.mLock.lock();
        try {
            int totalSize = nonStaleReservations.size() + this.mStaleList.size();
            IAssociativeModelReservation[] allReservations = new IAssociativeModelReservation[totalSize];
            nonStaleReservations.toArray(allReservations);
            Iterator<AssociativeModelReservation> staleIter = this.mStaleList.iterator();
            for (int i = nonStaleReservations.size(); i < totalSize; ++i) {
                allReservations[i] = staleIter.next();
            }
            IAssociativeModelReservation[] iAssociativeModelReservationArray = allReservations;
            return iAssociativeModelReservationArray;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private AssociativeModelReservation[] getNonStaleReservations() {
        Collection nonStaleReservations = this.mReservations.values();
        return nonStaleReservations.toArray(new AssociativeModelReservation[nonStaleReservations.size()]);
    }

    public static SafeScheduledThreadPoolExecutor createSafeScheduledThreadPoolExecutor() {
        SafeScheduledThreadPoolExecutor safeScheduledThreadPoolExecutor = new SafeScheduledThreadPoolExecutor(10000L, TimeUnit.MILLISECONDS, "AssociativeModelCache-Custodian");
        return safeScheduledThreadPoolExecutor;
    }

    private void onMaintenanceTaskTimeOut() {
        if (logger.isInfoEnabled()) {
            logger.info("Maintenance task times out", this.getClass().getName() + "::onMaintenanceTaskTimeOut()");
        }
        for (AssociativeModelReservation r : this.getNonStaleReservations()) {
            r.setStale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        boolean mayInterruptIfRunning = false;
        this.mMaintenanceScheduledFuture.cancel(false);
        if (this.mShutdownExecutor) {
            this.mSafeScheduledThreadPoolExecutor.shutdown();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Releasing cache", this.getClass().getName() + "::release()");
        }
        Collection reservations = this.mReservations.values();
        this.mReservations.clear();
        this.mLock.lock();
        try {
            for (AssociativeModelReservation r : reservations) {
                r.lock();
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("Forcing disposal of active reservation (key=%s, id=%h, count=%d)", r.getCacheKey(), r, r.reservationCount()), this.getClass().getName() + "::release()");
                    }
                    while (r.reservationCount() > 0) {
                        r.release();
                    }
                    r.dispose();
                }
                finally {
                    r.unlock();
                }
            }
            for (AssociativeModelReservation r : this.mStaleList) {
                r.lock();
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info(String.format("Forcing disposal of stale reservation (key=%s, id=%h, count=%d)", r.getCacheKey(), r, r.reservationCount()), this.getClass().getName() + "::release()");
                    }
                    while (r.reservationCount() > 0) {
                        r.release();
                    }
                    r.dispose();
                }
                finally {
                    r.unlock();
                }
            }
            this.mStaleList.clear();
        }
        finally {
            this.mLock.unlock();
        }
    }

    private static IPhysicalModelWatcher[] createWatchers(IAssociativeModel model) {
        Collection physModels = model.getPhysicalModels();
        IPhysicalModelWatcher[] watchers = new IPhysicalModelWatcher[physModels.size()];
        int i = 0;
        for (IPhysicalModel m : physModels) {
            watchers[i++] = m.createWatcher(model.getQLS(), false, 0L);
        }
        return watchers;
    }

    private final class MaintenanceTask
    implements Runnable {
        private MaintenanceTask() {
        }

        @Override
        public void run() {
            AssociativeModelCache.this.updateWatchers();
            AssociativeModelCache.this.cleanupReservations();
        }
    }
}

