/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.member;

import com.ibm.cognos.aurora.api.model.IAssociativeModel;
import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IHierarchy;
import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.IMemberLoader;
import com.ibm.cognos.aurora.api.model.IMemberLoaderFactory;
import com.ibm.cognos.aurora.api.model.IMemberSortSpec;
import com.ibm.cognos.aurora.api.model.IMemberTree;
import com.ibm.cognos.aurora.api.model.MemberRecord;
import com.ibm.cognos.aurora.core.util.Pair;
import com.ibm.cognos.fpm.common.graph.IPropertyGraph;
import com.ibm.cognos.fpm.common.graph.NodePropertyFilters;
import com.ibm.cognos.fpm.common.graph.PropertyGraphImpl;
import com.ibm.cognos.fpm.common.graph.PropertyGraphNodeFilter;
import com.ibm.cognos.fpm.common.utility.KeyedHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MemberTree
implements IMemberTree {
    private static final int MAX_INITIAL_CAPACITY = 22;
    private static final String MEMBER_ORDINAL = "memberOrdinal";
    private final IHierarchy hierarchy;
    private final IPropertyGraph<IMember> memberGraph;
    private final KeyedHashSet<String> stringDictionary;
    protected IMember defaultMember;
    protected String defaultMemberUniqueName;
    protected List<IMember> rootMembers = new ArrayList<IMember>();
    private int maxDepth = 0;
    private final IMemberLoaderFactory memberLoaderFactory;
    private final BitSet depthsFullyLoaded;
    private final Member searchMember = new Member(-1);

    public MemberTree(IHierarchy logicalHierarchy, IMemberLoaderFactory loaderFactory) {
        this.hierarchy = logicalHierarchy;
        this.memberLoaderFactory = loaderFactory;
        int numLevels = this.hierarchy.getLevels().size();
        this.maxDepth = numLevels - 1;
        this.depthsFullyLoaded = new BitSet(numLevels);
        this.depthsFullyLoaded.clear();
        int initialCapacity = (int)Math.pow(10.0, this.maxDepth);
        if (initialCapacity > 22) {
            initialCapacity = 22;
        }
        this.stringDictionary = new KeyedHashSet(Math.max(initialCapacity, 22));
        this.memberGraph = new PropertyGraphImpl(initialCapacity);
        this.loadMembers(this.memberLoaderFactory.createRootMembersLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member getMember(String uniqueName) {
        IPropertyGraph<IMember> iPropertyGraph = this.memberGraph;
        synchronized (iPropertyGraph) {
            int key = this.stringDictionary.getKey((Object)uniqueName);
            if (key == -1) {
                this.loadMembers(this.memberLoaderFactory.createMemberLoader(uniqueName));
                key = this.stringDictionary.getKey((Object)uniqueName);
            }
            if (key == -1) {
                return null;
            }
            Member aMember = new Member(key);
            assert (this.memberGraph.containsNode((Object)aMember));
            return aMember;
        }
    }

    private Member findMemberFromGraph(String uniqueName) {
        int key = this.stringDictionary.getKey((Object)uniqueName);
        if (key == -1) {
            return null;
        }
        this.searchMember.setKey(key);
        if (this.memberGraph.containsNode((Object)this.searchMember)) {
            return this.searchMember;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IMember> getMembers(int depth) {
        ArrayList<IMember> sortedMembers;
        if (depth < 0 || depth > this.maxDepth) {
            throw new IllegalArgumentException();
        }
        IPropertyGraph<IMember> iPropertyGraph = this.memberGraph;
        synchronized (iPropertyGraph) {
            if (!this.depthsFullyLoaded.get(depth)) {
                this.loadMembers(this.memberLoaderFactory.createHierarchyMembersLoader(0, depth));
                for (int i = 0; i <= depth; ++i) {
                    this.depthsFullyLoaded.set(i);
                }
            }
            sortedMembers = new ArrayList<IMember>(this.memberGraph.findNodes(new NodeDepthFilter<IMember>(this.memberGraph, depth)));
        }
        Collections.sort(sortedMembers, new MemberComparator());
        return sortedMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IMember> getMembers() {
        LinkedList<IMember> hierarchyMembers = new LinkedList<IMember>();
        IPropertyGraph<IMember> iPropertyGraph = this.memberGraph;
        synchronized (iPropertyGraph) {
            int i;
            boolean lowestDepthLoaded = this.depthsFullyLoaded.get(this.maxDepth);
            if (!lowestDepthLoaded) {
                this.loadMembers(this.memberLoaderFactory.createHierarchyMembersLoader());
                for (i = 0; i <= this.maxDepth; ++i) {
                    this.depthsFullyLoaded.set(i);
                }
            }
            for (i = 0; i <= this.maxDepth; ++i) {
                hierarchyMembers.addAll(this.getMembers(i));
            }
        }
        ArrayList<IMember> sortedMembers = new ArrayList<IMember>(hierarchyMembers);
        Collections.sort(sortedMembers, new MemberComparator());
        return sortedMembers;
    }

    private void loadMembers(IMemberLoader memberLoader) {
        String parentUniqueName;
        Member currentParent = null;
        Member currentMember = null;
        List levelAttributes = this.hierarchy.getLevels();
        Iterator records = memberLoader.load();
        LinkedList<Pair> orphanList = new LinkedList<Pair>();
        while (records.hasNext()) {
            MemberRecord record = (MemberRecord)records.next();
            String memberUniqueName = record.getMemberUniqueName();
            parentUniqueName = record.getParentUniqueName();
            if (this.findMemberFromGraph(memberUniqueName) != null) continue;
            IAttribute levelAttribute = (IAttribute)levelAttributes.get(record.getDepth());
            if (parentUniqueName == null) {
                currentMember = new Member(memberUniqueName);
                currentMember.setCaption(record.getCaption());
                currentMember.setAttribute(levelAttribute);
                currentMember.setMemberDepth(record.getDepth());
                currentMember.setChildrenCardinality(record.getChildrenCardinality());
                currentMember.setOrdinal(record.getOrdinal());
                this.rootMembers.add(currentMember);
            } else {
                if (currentParent == null || !parentUniqueName.equals(currentParent.getUniqueName())) {
                    currentParent = this.findMemberFromGraph(parentUniqueName);
                }
                currentMember = new Member(memberUniqueName);
                currentMember.setCaption(record.getCaption());
                currentMember.setAttribute(levelAttribute);
                currentMember.setMemberDepth(record.getDepth());
                currentMember.setChildrenCardinality(record.getChildrenCardinality());
                currentMember.setOrdinal(record.getOrdinal());
                if (currentParent == null) {
                    orphanList.add(new Pair((Object)parentUniqueName, (Object)currentMember));
                } else {
                    this.memberGraph.addEdge((Object)currentParent, (Object)currentMember, null);
                }
            }
            if (this.defaultMember != null || !memberUniqueName.equals(this.defaultMemberUniqueName)) continue;
            this.defaultMember = currentMember;
        }
        for (Pair pair : orphanList) {
            parentUniqueName = (String)pair.getFirst();
            IMember member = (IMember)pair.getSecond();
            Member parent = this.findMemberFromGraph(parentUniqueName);
            assert (parent != null);
            this.memberGraph.addEdge((Object)parent, (Object)member, null);
        }
        this.memberGraph.optimize();
    }

    public void setDefaultMember(String memberUniqueName) {
        this.defaultMemberUniqueName = memberUniqueName;
    }

    public Collection<IMember> getRootMembers() {
        return this.rootMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMember getDefaultMember() {
        if (this.defaultMemberUniqueName == null) {
            return null;
        }
        IPropertyGraph<IMember> iPropertyGraph = this.memberGraph;
        synchronized (iPropertyGraph) {
            if (this.defaultMember == null) {
                this.defaultMember = this.getMember(this.defaultMemberUniqueName);
            }
        }
        return this.defaultMember;
    }

    private class MemberComparator<T>
    implements Comparator<IMember> {
        private MemberComparator() {
        }

        @Override
        public int compare(IMember member1, IMember member2) {
            Member m1 = (Member)member1;
            Member m2 = (Member)member2;
            return m1.compareTo(m2);
        }
    }

    private static class NodeDepthFilter<K>
    implements PropertyGraphNodeFilter<K> {
        private final IPropertyGraph<K> graph;
        private final int depth;

        public NodeDepthFilter(IPropertyGraph<K> graph, int depth) {
            this.graph = graph;
            this.depth = depth;
        }

        public boolean evaluate(K nodeKey) {
            int currentDepth = 0;
            Object parentNodeKey = this.graph.getIncomingNode(nodeKey);
            while (parentNodeKey != null && ++currentDepth <= this.depth) {
                parentNodeKey = this.graph.getIncomingNode(parentNodeKey);
            }
            return currentDepth == this.depth;
        }

        public NodePropertyFilters getNodePropertyFilters() {
            return null;
        }

        public boolean callEvaluate() {
            return true;
        }

        public List<K> getNodeTypeFilters() {
            return Collections.emptyList();
        }
    }

    public class Member
    implements IMember,
    Comparable<Member> {
        private static final String CAPTION_PROPERTY = "caption";
        private static final String DEPTH_PROPERTY = "depth";
        private static final String LEVEL_PROPERTY = "level";
        private static final String CHILDREN_CARDINALITY_PROPERTY = "childrenCardinality";
        private static final String CHILDREN_LOADED_PROPERTY = "childrenLoaded";
        private int memberKey;

        Member(String uniqueName) {
            this.memberKey = MemberTree.this.stringDictionary.addAndReturnKey((Object)uniqueName);
            MemberTree.this.memberGraph.addNode((Object)this);
        }

        Member(int key) {
            this.memberKey = key;
        }

        public IAssociativeModel getReferencedModel() {
            return MemberTree.this.hierarchy.getReferencedModel();
        }

        public String getUniqueName() {
            return (String)MemberTree.this.stringDictionary.get(this.memberKey);
        }

        public String getCaption() {
            return (String)MemberTree.this.memberGraph.getNodeProperty((Object)this, CAPTION_PROPERTY);
        }

        void setCaption(String caption) {
            MemberTree.this.memberGraph.addNodeProperty((Object)this, CAPTION_PROPERTY, (Object)caption);
        }

        public IMember getParentMember() {
            return (IMember)MemberTree.this.memberGraph.getIncomingNode((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<IMember> getChildMembers() {
            Collection children;
            IPropertyGraph iPropertyGraph = MemberTree.this.memberGraph;
            synchronized (iPropertyGraph) {
                boolean loadChildren = true;
                int nextDepth = this.getMemberDepth() + 1;
                if (nextDepth < MemberTree.this.depthsFullyLoaded.size() && MemberTree.this.depthsFullyLoaded.get(nextDepth)) {
                    loadChildren = false;
                }
                if (loadChildren && this.getChildrenLoaded()) {
                    loadChildren = false;
                }
                if (loadChildren) {
                    MemberTree.this.loadMembers(MemberTree.this.memberLoaderFactory.createChildMembersLoader((IMember)this));
                    this.setChildrenLoaded();
                }
                children = MemberTree.this.memberGraph.getOutgoingNodes((Object)this, 1);
            }
            ArrayList<IMember> childrenList = new ArrayList<IMember>(children);
            Collections.sort(childrenList, new MemberComparator());
            return childrenList;
        }

        public IHierarchy getHierarchy() {
            return MemberTree.this.hierarchy;
        }

        public IAttribute getAttribute() {
            return (IAttribute)MemberTree.this.memberGraph.getNodeProperty((Object)this, LEVEL_PROPERTY);
        }

        void setAttribute(IAttribute attribute) {
            MemberTree.this.memberGraph.addNodeProperty((Object)this, LEVEL_PROPERTY, (Object)attribute);
        }

        public int getMemberDepth() {
            return (Integer)MemberTree.this.memberGraph.getNodeProperty((Object)this, DEPTH_PROPERTY);
        }

        void setMemberDepth(int memberDepth) {
            MemberTree.this.memberGraph.addNodeProperty((Object)this, DEPTH_PROPERTY, (Object)memberDepth);
        }

        public long getChildrenCardinality() {
            long cardinality = (Long)MemberTree.this.memberGraph.getNodeProperty((Object)this, CHILDREN_CARDINALITY_PROPERTY);
            if (cardinality == -1L) {
                return this.getChildMembers().size();
            }
            return cardinality;
        }

        public void setChildrenCardinality(long numChildren) {
            MemberTree.this.memberGraph.addNodeProperty((Object)this, CHILDREN_CARDINALITY_PROPERTY, (Object)numChildren);
        }

        public void setChildrenLoaded() {
            MemberTree.this.memberGraph.addNodeProperty((Object)this, CHILDREN_LOADED_PROPERTY, (Object)Boolean.TRUE);
        }

        public boolean getChildrenLoaded() {
            Object o = MemberTree.this.memberGraph.getNodeProperty((Object)this, CHILDREN_LOADED_PROPERTY);
            return o != null;
        }

        protected long getOrdinal() {
            Long ordinal = (Long)MemberTree.this.memberGraph.getNodeProperty((Object)this, MemberTree.MEMBER_ORDINAL);
            if (ordinal == null) {
                return -1L;
            }
            return ordinal;
        }

        protected void setOrdinal(long ordinal) {
            MemberTree.this.memberGraph.addNodeProperty((Object)this, MemberTree.MEMBER_ORDINAL, (Object)ordinal);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Member)) {
                return false;
            }
            Member otherMember = (Member)o;
            if (otherMember == this) {
                return true;
            }
            return this.memberKey == otherMember.memberKey;
        }

        public int hashCode() {
            return this.memberKey;
        }

        public String toString() {
            return this.getUniqueName();
        }

        protected void setKey(int key) {
            this.memberKey = key;
        }

        @Override
        public int compareTo(Member o) {
            long otherOrdinal;
            long ordinal = this.getOrdinal();
            if (ordinal < (otherOrdinal = o.getOrdinal())) {
                return -1;
            }
            if (ordinal == otherOrdinal) {
                return 0;
            }
            return 1;
        }

        public Comparator<IMember> createComparator(IMemberSortSpec memberSortSpec) {
            throw new UnsupportedOperationException();
        }
    }
}

