/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical;

import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public abstract class AbstractPhysicalMetadata
implements IPhysicalMetadata {
    private final IPhysicalModel mModel;
    private final IPhysicalMetadata mParent;
    private final List<IPhysicalMetadata> mChildren = new ArrayList<IPhysicalMetadata>(5);
    private String mInternalName;
    private String mInternalUniqueName;

    public AbstractPhysicalMetadata(IPhysicalModel model, IPhysicalMetadata parent) {
        this.mModel = model;
        this.mParent = parent;
    }

    public final IPhysicalModel getModel() {
        return this.mModel;
    }

    public final IPhysicalMetadata getParent() {
        return this.mParent;
    }

    public final String getInternalName() {
        return this.mInternalName;
    }

    public final void setInternalName(String internalName) {
        this.mInternalName = internalName;
    }

    public final String getInternalUniqueName() {
        if (null == this.mInternalUniqueName) {
            if (null == this.mInternalName) {
                throw new IllegalStateException("mInternalName was not set");
            }
            this.mInternalUniqueName = null != this.mParent ? UniqueNameGenerator.appendUniqueName((String)this.mParent.getInternalUniqueName(), (String)this.mInternalName) : UniqueNameGenerator.createSingleNamePart((String)this.mInternalName);
        }
        return this.mInternalUniqueName;
    }

    public final List<IPhysicalMetadata> getChildren() {
        return Collections.unmodifiableList(this.mChildren);
    }

    public final List<IPhysicalMetadata> getChildren(EPhysicalMetadataType type) {
        ArrayList<IPhysicalMetadata> children = new ArrayList<IPhysicalMetadata>(this.mChildren.size());
        for (IPhysicalMetadata child : this.mChildren) {
            if (child.getType() != type) continue;
            children.add(child);
        }
        return children;
    }

    public final <T extends IPhysicalMetadata> List<T> getChildren(EPhysicalMetadataType type, Class<T> clazz) {
        ArrayList<T> children = new ArrayList<T>(this.mChildren.size());
        for (IPhysicalMetadata child : this.mChildren) {
            if (child.getType() != type) continue;
            children.add(clazz.cast(child));
        }
        return children;
    }

    public final IPhysicalMetadata findChild(String internalName) {
        for (IPhysicalMetadata child : this.mChildren) {
            if (!child.getInternalName().equals(internalName)) continue;
            return child;
        }
        return null;
    }

    public final <T extends IPhysicalMetadata> T findChild(String internalName, Class<T> clazz) {
        return (T)((IPhysicalMetadata)clazz.cast(this.findChild(internalName)));
    }

    protected final void addChild(IPhysicalMetadata child) {
        if (null != this.findChild(child.getInternalName())) {
            throw new QLSRuntimeException(QLSMessageKeys.MOD_DuplicatePhysicalMetadataChildParam, child.getInternalName());
        }
        this.mChildren.add(child);
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addElement("internalName").setText(this.mInternalName);
        this.encodePropertiesElement(elem.addElement("props"), ctx);
        for (IPhysicalMetadata child : this.mChildren) {
            Element childElem = elem.addElement("child");
            childElem.addAttribute("type", child.getType().name());
            child.encodeElement(childElem, ctx);
        }
    }

    protected abstract void encodePropertiesElement(Element var1, EncoderContext var2);

    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mInternalName = elem.elementText("internalName");
        this.decodePropertiesElement(elem.element("props"), ctx);
        this.mChildren.clear();
        for (Element childElem : elem.elements("child")) {
            EPhysicalMetadataType type = EPhysicalMetadataType.valueOf((String)childElem.attributeValue("type"));
            IPhysicalMetadata child = ((AbstractPhysicalModel)this.mModel).createMetadata(type, this);
            child.decodeElement(childElem, ctx);
            this.mChildren.add(child);
        }
    }

    protected abstract void decodePropertiesElement(Element var1, EncoderContext var2);

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeString((DataOutput)out, (String)this.mInternalName);
        this.encodePropertiesBinary(out, ctx);
        out.writeInt(this.mChildren.size());
        for (IPhysicalMetadata child : this.mChildren) {
            out.writeByte(child.getType().ordinal());
            child.encodeBinary(out, ctx);
        }
    }

    protected abstract void encodePropertiesBinary(DataOutput var1, EncoderContext var2) throws IOException;

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        EPhysicalMetadataType[] allTypes = EPhysicalMetadataType.values();
        this.mInternalName = EncodeUtil.readString((DataInput)in);
        this.decodePropertiesBinary(in, ctx);
        int numChildren = in.readInt();
        this.mChildren.clear();
        for (int i = 0; i < numChildren; ++i) {
            EPhysicalMetadataType type = allTypes[in.readByte()];
            IPhysicalMetadata child = ((AbstractPhysicalModel)this.mModel).createMetadata(type, this);
            child.decodeBinary(in, ctx);
            this.mChildren.add(child);
        }
    }

    protected abstract void decodePropertiesBinary(DataInput var1, EncoderContext var2) throws IOException;

    public String toString() {
        return this.getInternalUniqueName();
    }

    public int hashCode() {
        return this.getInternalUniqueName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPhysicalMetadata)) {
            return false;
        }
        IPhysicalMetadata other = (IPhysicalMetadata)o;
        return this.getType() == other.getType() && this.getInternalUniqueName().equals(other.getInternalUniqueName());
    }
}

