/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalModel;
import com.ibm.cognos.aurora.api.model.value.TimestampValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.core.model.DataSource;
import com.ibm.cognos.aurora.core.util.UniqueNameParser;
import com.ibm.cognos.aurora.core.util.UniqueNameParserException;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.LocalDataSource;
import com.ibm.icu.util.ULocale;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dom4j.Element;

public abstract class AbstractPhysicalModel
implements IPhysicalModel {
    private IQueryLogicalStorage mQLS;
    private IDataSource mDataSource;
    private ULocale mLocale;
    private Date mCreationTime;
    private final List<IPhysicalMetadata> mRoots = new ArrayList<IPhysicalMetadata>();

    public AbstractPhysicalModel() {
    }

    protected AbstractPhysicalModel(IDataSource dataSource, ULocale locale, Date creationTime) {
        this.mDataSource = dataSource;
        this.mLocale = locale;
        this.mCreationTime = creationTime;
    }

    public final IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public final void setQLS(IQueryLogicalStorage qls) {
        this.mQLS = qls;
    }

    public final IDataSource getDataSource() {
        return this.mDataSource;
    }

    public final void setDataSource(IDataSource dataSource) {
        this.mDataSource = dataSource;
    }

    public final ULocale getLocale() {
        if (null == this.mLocale) {
            return ULocale.getDefault();
        }
        return this.mLocale;
    }

    public final void setLocale(ULocale locale) {
        this.mLocale = locale;
    }

    public final Date getCreationTime() {
        return this.mCreationTime;
    }

    public final void setCreationTime(Date creationTime) {
        this.mCreationTime = creationTime;
    }

    public final List<IPhysicalMetadata> getRoots() {
        return Collections.unmodifiableList(this.mRoots);
    }

    public final <T extends IPhysicalMetadata> List<T> getRoots(EPhysicalMetadataType type, Class<T> clazz) {
        ArrayList<T> roots = new ArrayList<T>(this.mRoots.size());
        for (IPhysicalMetadata root : this.mRoots) {
            if (root.getType() != type) continue;
            roots.add(clazz.cast(root));
        }
        return roots;
    }

    public final IPhysicalMetadata findRoot(String internalName) {
        for (IPhysicalMetadata root : this.mRoots) {
            if (!root.getInternalName().equals(internalName)) continue;
            return root;
        }
        return null;
    }

    public final <T extends IPhysicalMetadata> T findRoot(String internalName, Class<T> clazz) {
        return (T)((IPhysicalMetadata)clazz.cast(this.findRoot(internalName)));
    }

    protected final void addRoot(IPhysicalMetadata root) {
        if (null != this.findRoot(root.getInternalName())) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, "Root already exists: " + root.getInternalName());
        }
        this.mRoots.add(root);
    }

    public final IPhysicalMetadata lookupMetadata(String internalUniqueName) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)internalUniqueName);
        }
        catch (UniqueNameParserException ex) {
            return null;
        }
        if (parts.length == 0) {
            return null;
        }
        IPhysicalMetadata rootFound = null;
        for (IPhysicalMetadata root : this.mRoots) {
            if (!root.getInternalName().equals(parts[0])) continue;
            rootFound = root;
            break;
        }
        if (null == rootFound) {
            return null;
        }
        if (parts.length == 1) {
            return rootFound;
        }
        return this.lookupMetadata(rootFound, parts, 1);
    }

    public final <T extends IPhysicalMetadata> T lookupMetadata(String internalUniqueName, Class<T> clazz) {
        return (T)((IPhysicalMetadata)clazz.cast(this.lookupMetadata(internalUniqueName)));
    }

    private IPhysicalMetadata lookupMetadata(IPhysicalMetadata context, String[] parts, int offset) {
        IPhysicalMetadata childFound = null;
        for (IPhysicalMetadata child : context.getChildren()) {
            if (!child.getInternalName().equals(parts[offset])) continue;
            childFound = child;
            break;
        }
        if (null == childFound) {
            return null;
        }
        if (offset >= parts.length - 1) {
            return childFound;
        }
        return this.lookupMetadata(childFound, parts, offset + 1);
    }

    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        if (null != this.mDataSource) {
            out.writeBoolean(true);
            out.writeBoolean(this.mDataSource instanceof LocalDataSource);
            this.mDataSource.encodeBinary(out, ctx);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mLocale) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mLocale.toString());
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mCreationTime) {
            out.writeBoolean(true);
            out.writeLong(this.mCreationTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.mRoots.size());
        for (IPhysicalMetadata root : this.mRoots) {
            out.writeByte(root.getType().ordinal());
            root.encodeBinary(out, ctx);
        }
    }

    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        EPhysicalMetadataType[] allTypes = EPhysicalMetadataType.values();
        if (in.readBoolean()) {
            boolean isLocal = in.readBoolean();
            this.mDataSource = isLocal ? new LocalDataSource(this.getQLS()) : new DataSource();
            this.mDataSource.decodeBinary(in, ctx);
        } else {
            this.mDataSource = null;
        }
        this.mLocale = in.readBoolean() ? new ULocale(EncodeUtil.readString((DataInput)in)) : null;
        this.mCreationTime = in.readBoolean() ? new Date(in.readLong()) : null;
        int numRoots = in.readInt();
        this.mRoots.clear();
        for (int i = 0; i < numRoots; ++i) {
            EPhysicalMetadataType type = allTypes[in.readByte()];
            IPhysicalMetadata root = this.createMetadata(type, null);
            root.decodeBinary(in, ctx);
            this.mRoots.add(root);
        }
    }

    public void encodeElement(Element elem, EncoderContext ctx) {
        if (null != this.mDataSource) {
            Element dataSourceElem = elem.addElement("dataSource");
            dataSourceElem.addAttribute("isLocal", Boolean.toString(this.mDataSource instanceof LocalDataSource));
            this.mDataSource.encodeElement(dataSourceElem, ctx);
        }
        if (null != this.mLocale) {
            elem.addAttribute("locale", this.mLocale.toString());
        }
        if (null != this.mCreationTime) {
            if (ctx.containsKey((Object)"stableTestOutput")) {
                elem.addAttribute("creationTime", ValueFactory.createTimestamp((Date)new Date(0L)).stringValue());
            } else {
                elem.addAttribute("creationTime", ValueFactory.createTimestamp((Date)this.mCreationTime).stringValue());
            }
        }
        for (IPhysicalMetadata root : this.mRoots) {
            Element rootElem = elem.addElement("root");
            rootElem.addAttribute("type", root.getType().name());
            root.encodeElement(rootElem, ctx);
        }
    }

    public void decodeElement(Element elem, EncoderContext ctx) {
        Element dataSourceElem = elem.element("dataSource");
        if (null != dataSourceElem) {
            this.mDataSource = "true".equals(dataSourceElem.attributeValue("isLocal")) ? new LocalDataSource(this.getQLS()) : new DataSource();
            this.mDataSource.decodeElement(dataSourceElem, ctx);
        } else {
            this.mDataSource = null;
        }
        String localeStr = elem.attributeValue("locale");
        this.mLocale = null != localeStr ? new ULocale(localeStr) : null;
        String creationTimeStr = elem.attributeValue("creationTime");
        if (null != creationTimeStr) {
            TimestampValue ts = ValueFactory.createTimestamp();
            ts.assignFrom(creationTimeStr);
            this.mCreationTime = ts.dateValue();
            if (null == this.mCreationTime) {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_UnableToParseTimeStamp, creationTimeStr);
            }
        } else {
            this.mCreationTime = null;
        }
        this.mRoots.clear();
        for (Element rootElem : elem.elements("root")) {
            EPhysicalMetadataType type = EPhysicalMetadataType.valueOf((String)rootElem.attributeValue("type"));
            IPhysicalMetadata root = this.createMetadata(type, null);
            root.decodeElement(rootElem, ctx);
            this.mRoots.add(root);
        }
    }

    public String toString() {
        return String.valueOf(this.mDataSource);
    }

    public abstract IPhysicalMetadata createMetadata(EPhysicalMetadataType var1, IPhysicalMetadata var2);
}

