/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.model.physical.olap;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.EPhysicalMetadataType;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapCube;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMember;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapModel;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.provider.IProviderManager;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IHierarchyRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.model.physical.AbstractPhysicalModel;
import com.ibm.cognos.aurora.qls.model.physical.olap.AbstractOlapMetadata;
import com.ibm.cognos.aurora.qls.model.physical.olap.OlapCube;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.dom4j.Element;

public class OlapHierarchy
extends AbstractOlapMetadata
implements IOlapHierarchy {
    private int mOrdinal;
    private long mCardinality;
    private int mStructure;
    protected String mDefaultMemberUN;
    protected volatile IOlapMember mCachedDefaultMember;
    protected String mAllMemberUN;
    protected volatile IOlapMember mCachedAllMember;
    protected volatile List<IOlapMember> mCachedRootMembers;

    public OlapHierarchy(IOlapModel model, IOlapDimension parent) {
        super(model, (IOlapMetadata)parent);
    }

    public EPhysicalMetadataType getType() {
        return EPhysicalMetadataType.OLAP_HIERARCHY;
    }

    public IOlapCube getCube() {
        return this.getDimension().getCube();
    }

    public IOlapDimension getDimension() {
        return (IOlapDimension)this.getParent();
    }

    public int getOrdinal() {
        return this.mOrdinal;
    }

    public void setOrdinal(int ordinal) {
        this.mOrdinal = ordinal;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public void setCardinality(long cardinality) {
        this.mCardinality = cardinality;
    }

    public boolean isParentChild() {
        return 0 != (1 & this.mStructure);
    }

    public void setParentChild(boolean value) {
        this.mStructure = value ? (this.mStructure |= 1) : (this.mStructure &= 0xFFFFFFFE);
    }

    public boolean isRagged() {
        return 0 != (2 & this.mStructure);
    }

    public void setRagged(boolean value) {
        this.mStructure = value ? (this.mStructure |= 2) : (this.mStructure &= 0xFFFFFFFD);
    }

    public boolean isBalanced() {
        return 0 != (4 & this.mStructure);
    }

    public void setBalanced(boolean value) {
        this.mStructure = value ? (this.mStructure |= 4) : (this.mStructure &= 0xFFFFFFFB);
    }

    public IOlapMember getDefaultMember() {
        if (null == this.mCachedDefaultMember) {
            if (null != this.mDefaultMemberUN) {
                List members = this.getCube().fetchMembers(this.mDefaultMemberUN, EnumSet.of(ETreeOp.SELF));
                if (members.isEmpty()) {
                    throw new QLSRuntimeException(QLSMessageKeys.MOD_MemberNotFound, this.mDefaultMemberUN);
                }
                this.mCachedDefaultMember = (IOlapMember)members.get(0);
            } else {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_DefaultMemberNotKnown);
            }
        }
        return this.mCachedDefaultMember;
    }

    public void setDefaultMemberUN(String defaultMemberUN) {
        this.mCachedDefaultMember = null;
        this.mDefaultMemberUN = defaultMemberUN;
    }

    public void setDefaultMember(IOlapMember defaultMember) {
        this.mCachedDefaultMember = defaultMember;
        this.mDefaultMemberUN = defaultMember.getUniqueName();
    }

    public IOlapMember getAllMember() {
        if (null == this.mCachedAllMember) {
            if (null != this.mAllMemberUN) {
                List members = this.getCube().fetchMembers(this.mAllMemberUN, EnumSet.of(ETreeOp.SELF));
                if (members.isEmpty()) {
                    throw new QLSRuntimeException(QLSMessageKeys.MOD_MemberNotFound, this.mAllMemberUN);
                }
                this.mCachedAllMember = (IOlapMember)members.get(0);
            } else {
                throw new QLSRuntimeException(QLSMessageKeys.MOD_AllMemberNotKnown);
            }
        }
        return this.mCachedAllMember;
    }

    public void setAllMemberUN(String allMemberUN) {
        this.mCachedAllMember = null;
        this.mAllMemberUN = allMemberUN;
    }

    public void setAllMember(IOlapMember allMember) {
        this.mCachedAllMember = allMember;
        this.mAllMemberUN = allMember.getUniqueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IOlapMember> getRootMembers() {
        if (null == this.mCachedRootMembers) {
            IQueryLogicalStorage qls = ((AbstractPhysicalModel)this.getModel()).getQLS();
            IProviderManager providerMan = qls.getProviderManager();
            IDataSource dataSource = this.getModel().getDataSource();
            IConnectionSpec connSpec = dataSource.getConnectionSpec();
            String providerType = connSpec.getParameterStringValue("providerType");
            IDimensionalDataProvider provider = (IDimensionalDataProvider)providerMan.getDataProvider(providerType);
            OlapCube cube = (OlapCube)this.getCube();
            Restrictions restrictions = new Restrictions();
            restrictions.put("CATALOG_NAME", cube.getCatalogName());
            restrictions.put("CUBE_NAME", cube.getName());
            restrictions.put("HIERARCHY_UNIQUE_NAME", this.getUniqueName());
            QueryContext queryContext = new QueryContext(LocalSessionContext.get());
            queryContext.setContentLocale(this.getModel().getLocale().toLocale());
            try {
                List records = provider.discoverHierarchyRootMembers(dataSource, (IRestrictions)restrictions, (IQueryContext)queryContext);
                ArrayList<IOlapMember> members = new ArrayList<IOlapMember>(records.size());
                for (IMemberRecord rec : records) {
                    members.add(cube.getMemberFromRecord(rec));
                }
                this.mCachedRootMembers = members;
            }
            finally {
                queryContext.terminate();
            }
        }
        return this.mCachedRootMembers;
    }

    public List<IOlapMember> getMembers() {
        ArrayList<IOlapMember> result = new ArrayList<IOlapMember>();
        for (IOlapLevel level : this.getLevels()) {
            result.addAll(level.fetchMembers());
        }
        return result;
    }

    public List<IOlapMember> getLevelMembers(int startDepth, int extent) {
        List<IOlapLevel> levels = this.getLevels();
        if (startDepth < 0) {
            throw new IndexOutOfBoundsException("startDepth < 0");
        }
        if (extent < 0) {
            throw new IndexOutOfBoundsException("extent < 0");
        }
        if (startDepth + extent > levels.size()) {
            throw new IndexOutOfBoundsException("startDepth + extent > levels.size()");
        }
        ArrayList<IOlapMember> result = new ArrayList<IOlapMember>();
        for (int i = 0; i < extent; ++i) {
            result.addAll(levels.get(startDepth + i).fetchMembers());
        }
        return result;
    }

    public List<IOlapLevel> getLevels() {
        return this.getChildren(EPhysicalMetadataType.OLAP_LEVEL, IOlapLevel.class);
    }

    public IOlapLevel findLevel(String lun) {
        for (IOlapLevel lvl : this.getLevels()) {
            if (!lvl.getUniqueName().equals(lun)) continue;
            return lvl;
        }
        return null;
    }

    public void addLevel(IOlapLevel level) {
        this.addChild((IPhysicalMetadata)level);
    }

    public void populateFromRecord(IHierarchyRecord record) {
        this.mCachedAllMember = null;
        this.mCachedDefaultMember = null;
        this.mCachedRootMembers = null;
        this.setInternalName(record.getName());
        this.setName(record.getName());
        this.setUniqueName(record.getUniqueName());
        this.setCaption(record.getCaption());
        this.setOrdinal(record.getOrdinal());
        this.setCardinality(record.getCardinality());
        this.mStructure = 0;
        this.setBalanced(record.isBalanced());
        this.setParentChild(record.isParentChild());
        this.setRagged(record.isRagged());
        this.setDefaultMemberUN(record.getDefaultMember());
        this.setAllMemberUN(record.getAllMember());
    }

    @Override
    protected void encodePropertiesElement(Element elem, EncoderContext ctx) {
        super.encodePropertiesElement(elem, ctx);
        elem.addElement("ordinal").setText(Integer.toString(this.mOrdinal));
        elem.addElement("cardinality").setText(Long.toString(this.mCardinality));
        elem.addElement("structure").setText(Integer.toString(this.mStructure));
        if (null != this.mDefaultMemberUN) {
            elem.addElement("defaultMemberUN").setText(this.mDefaultMemberUN);
        }
        if (null != this.mAllMemberUN) {
            elem.addElement("allMemberUN").setText(this.mAllMemberUN);
        }
    }

    @Override
    protected void decodePropertiesElement(Element elem, EncoderContext ctx) {
        super.decodePropertiesElement(elem, ctx);
        this.mCachedAllMember = null;
        this.mCachedDefaultMember = null;
        this.mCachedRootMembers = null;
        this.mOrdinal = Integer.parseInt(elem.elementText("ordinal"));
        this.mCardinality = Long.parseLong(elem.elementText("cardinality"));
        this.mStructure = Integer.parseInt(elem.elementText("structure"));
        this.mDefaultMemberUN = elem.elementText("defaultMemberUN");
        this.mAllMemberUN = elem.elementText("allMemberUN");
    }

    @Override
    protected void encodePropertiesBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodePropertiesBinary(out, ctx);
        out.writeInt(this.mOrdinal);
        out.writeLong(this.mCardinality);
        out.writeInt(this.mStructure);
        if (null != this.mDefaultMemberUN) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mDefaultMemberUN);
        } else {
            out.writeBoolean(false);
        }
        if (null != this.mAllMemberUN) {
            out.writeBoolean(true);
            EncodeUtil.writeString((DataOutput)out, (String)this.mAllMemberUN);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    protected void decodePropertiesBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodePropertiesBinary(in, ctx);
        this.mCachedAllMember = null;
        this.mCachedDefaultMember = null;
        this.mCachedRootMembers = null;
        this.mOrdinal = in.readInt();
        this.mCardinality = in.readLong();
        this.mStructure = in.readInt();
        this.mDefaultMemberUN = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
        this.mAllMemberUN = in.readBoolean() ? EncodeUtil.readString((DataInput)in) : null;
    }
}

